/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/AnnotationNewLineRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkAnnotation", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "deleteSpaces", "rightSide", "", "fixAnnotation", "logic", "Companion", "diktat-rules"})
public final class AnnotationNewLineRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "abo-annotation-new-line";

    public AnnotationNewLineRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.ANNOTATION_NEW_LINE)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (!(((Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUN())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPRIMARY_CONSTRUCTOR())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSECONDARY_CONSTRUCTOR()))) {
            return;
        }
        this.checkAnnotation(node);
    }

    private final void checkAnnotation(ASTNode node) {
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getMODIFIER_LIST());
        if (aSTNode != null) {
            ASTNode modList = aSTNode;
            boolean bl = false;
            this.fixAnnotation(modList);
        }
    }

    private final void fixAnnotation(ASTNode node) {
        if (AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getANNOTATION_ENTRY()).size() <= 1) {
            return;
        }
        Iterable $this$forEach$iv = AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getANNOTATION_ENTRY());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (AstNodeUtilsKt.isFollowedByNewlineWithComment(it) && AstNodeUtilsKt.isBeginNewLineWithComment(it)) continue;
            this.deleteSpaces(it, !AstNodeUtilsKt.isFollowedByNewlineWithComment(it));
        }
    }

    private final void deleteSpaces(ASTNode node, boolean rightSide) {
        Warnings.warnAndFix$default(Warnings.ANNOTATION_NEW_LINE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)node.getText(), (Object)" not on a single line"), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(rightSide, node){
            final /* synthetic */ boolean $rightSide;
            final /* synthetic */ ASTNode $node;
            {
                this.$rightSide = $rightSide;
                this.$node = $node;
                super(0);
            }

            public final void invoke() {
                boolean hasSpaceBeforeGrandparent;
                if (this.$rightSide) {
                    ASTNode aSTNode = this.$node.getTreeNext();
                    if (aSTNode == null ? false : PackageKt.isWhiteSpace((ASTNode)aSTNode)) {
                        this.$node.removeChild(this.$node.getTreeNext());
                    }
                    this.$node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$node.getTreeNext());
                }
                ASTNode aSTNode = this.$node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
                ASTNode aSTNode2 = aSTNode;
                aSTNode = this.$node.getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.elementType");
                if (Intrinsics.areEqual((Object)this.$node, (Object)AstNodeUtilsKt.getFirstChildWithType(aSTNode2, (IElementType)aSTNode)) && (hasSpaceBeforeGrandparent = PackageKt.isWhiteSpace((ASTNode)this.$node.getTreeParent().getTreeParent().getTreePrev()))) {
                    ASTNode aSTNode3 = this.$node.getTreeParent().getTreeParent().getTreePrev();
                    if (aSTNode3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                    }
                    ((LeafPsiElement)aSTNode3).rawReplaceWithText("\n");
                }
            }
        }, 64, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/AnnotationNewLineRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

