/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstConstantsKt;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J \u0010\u001a\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006 "}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/BlockStructureBraces;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkBraceNode", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "shouldContainNewline", "checkClass", "", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter3/BlockStructureBraces$BlockStructureBracesConfiguration;", "checkCloseBrace", "checkFun", "checkIf", "checkLambda", "checkLoop", "checkMidBrace", "allMiddleSpace", "keyword", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "checkOpenBraceEndLine", "beforeType", "checkOpenBraceOnSameLine", "checkTry", "checkWhen", "logic", "BlockStructureBracesConfiguration", "Companion", "diktat-rules"})
public final class BlockStructureBraces
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "acn-block-structure";

    public BlockStructureBraces(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.BRACES_BLOCK_STRUCTURE_ERROR)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.BRACES_BLOCK_STRUCTURE_ERROR);
        Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        BlockStructureBracesConfiguration configuration2 = new BlockStructureBracesConfiguration(map);
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) {
            this.checkLambda(node, configuration2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getOBJECT_DECLARATION())) {
            this.checkClass(node, configuration2);
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUN()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS_INITIALIZER())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSECONDARY_CONSTRUCTOR())) {
            this.checkFun(node, configuration2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getIF())) {
            this.checkIf(node, configuration2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getWHEN())) {
            this.checkWhen(node, configuration2);
        } else if (AstConstantsKt.getLoopType().contains(iElementType)) {
            this.checkLoop(node, configuration2);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getTRY())) {
            this.checkTry(node, configuration2);
        } else {
            return;
        }
    }

    private final void checkLambda(ASTNode node, BlockStructureBracesConfiguration configuration2) {
        boolean isSingleLineLambda;
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        boolean bl = isSingleLineLambda = StringsKt.lines((CharSequence)string).size() == 1;
        if (!isSingleLineLambda) {
            this.checkCloseBrace(node, configuration2);
        }
    }

    private final void checkClass(ASTNode node, BlockStructureBracesConfiguration configuration2) {
        if (AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getCLASS_BODY()) && !AstNodeUtilsKt.isBlockEmpty(node.findChildByType(ElementType.INSTANCE.getCLASS_BODY()))) {
            this.checkOpenBraceOnSameLine(node, ElementType.INSTANCE.getCLASS_BODY(), configuration2);
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getCLASS_BODY());
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode aSTNode2 = aSTNode;
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(CLASS_BODY)!!");
            this.checkCloseBrace(aSTNode2, configuration2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTry(ASTNode node, BlockStructureBracesConfiguration configuration2) {
        Iterable it;
        Iterator $this$mapTo$iv$iv;
        Iterator it2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtTryExpression");
        }
        KtTryExpression tryBlock = (KtTryExpression)psiElement;
        List list = tryBlock.getCatchClauses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tryBlock.catchClauses");
        Iterable $this$map$iv = list;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            KtCatchClause ktCatchClause = (KtCatchClause)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getNode());
        }
        List catchBlocks = (List)destination$iv$iv;
        KtFinallySection ktFinallySection = tryBlock.getFinallyBlock();
        ASTNode finallyBlock = ktFinallySection == null ? null : ktFinallySection.getNode();
        ASTNode $i$f$map22 = tryBlock.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"tryBlock.node");
        this.checkOpenBraceOnSameLine($i$f$map22, ElementType.INSTANCE.getBLOCK(), configuration2);
        Iterable $this$map$iv2 = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getCATCH(), false, 2, null);
        boolean $i$f$map = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        it2 = $this$mapTo$iv$iv.iterator();
        while (it2.hasNext()) {
            Object item$iv$iv = it2.next();
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getTreePrev());
        }
        List allMiddleSpaceNodes = (List)destination$iv$iv2;
        this.checkMidBrace(allMiddleSpaceNodes, node, ElementType.INSTANCE.getCATCH_KEYWORD());
        Iterable $this$forEach$iv = catchBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode item$iv$iv;
            ASTNode it3 = (ASTNode)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
            this.checkOpenBraceOnSameLine(it3, ElementType.INSTANCE.getBLOCK(), configuration2);
            Intrinsics.checkNotNull((Object)it3.findChildByType(ElementType.INSTANCE.getBLOCK()));
            Intrinsics.checkNotNullExpressionValue((Object)item$iv$iv, (String)"it.findChildByType(BLOCK)!!");
            this.checkCloseBrace(item$iv$iv, configuration2);
        }
        ASTNode aSTNode = finallyBlock;
        if (aSTNode != null) {
            void $this$mapTo$iv$iv3;
            ASTNode block = aSTNode;
            boolean bl = false;
            this.checkOpenBraceOnSameLine(block, ElementType.INSTANCE.getBLOCK(), configuration2);
            ASTNode aSTNode2 = block.findChildByType(ElementType.INSTANCE.getBLOCK());
            Intrinsics.checkNotNull((Object)aSTNode2);
            ASTNode it3 = aSTNode2;
            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"block.findChildByType(BLOCK)!!");
            this.checkCloseBrace(it3, configuration2);
            Iterable $this$map$iv3 = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getFINALLY(), false, 2, null);
            boolean $i$f$map3 = false;
            it = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it4;
                ASTNode aSTNode3 = (ASTNode)item$iv$iv;
                Collection collection2 = destination$iv$iv3;
                boolean bl2 = false;
                collection2.add(it4.getTreePrev());
            }
            List newAllMiddleSpaceNodes = (List)destination$iv$iv3;
            this.checkMidBrace(newAllMiddleSpaceNodes, node, ElementType.INSTANCE.getFINALLY_KEYWORD());
        }
    }

    private final void checkLoop(ASTNode node, BlockStructureBracesConfiguration configuration2) {
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getBODY());
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl = false;
            if (!AstNodeUtilsKt.isBlockEmpty(it.findChildByType(ElementType.INSTANCE.getBLOCK()))) {
                this.checkOpenBraceOnSameLine(node, ElementType.INSTANCE.getBODY(), configuration2);
                ASTNode aSTNode2 = it.findChildByType(ElementType.INSTANCE.getBLOCK());
                Intrinsics.checkNotNull((Object)aSTNode2);
                ASTNode aSTNode3 = aSTNode2;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"it.findChildByType(BLOCK)!!");
                this.checkCloseBrace(aSTNode3, configuration2);
                if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getDO_WHILE())) {
                    ASTNode aSTNode4 = node.findChildByType(ElementType.INSTANCE.getBODY());
                    Intrinsics.checkNotNull((Object)aSTNode4);
                    List allMiddleNode = CollectionsKt.listOf((Object)aSTNode4.getTreeNext());
                    this.checkMidBrace(allMiddleNode, node, ElementType.INSTANCE.getWHILE_KEYWORD());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkWhen(ASTNode node, BlockStructureBracesConfiguration configuration2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int n;
        List list;
        List $this$checkWhen_u24lambda_u2d7;
        Object object;
        block4: {
            void $this$indexOfFirst$iv;
            object = node.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node\n            .getChildren(null)");
            $this$checkWhen_u24lambda_u2d7 = ArraysKt.toList((Object[])object);
            boolean bl = false;
            List list2 = $this$checkWhen_u24lambda_u2d7;
            list = $this$checkWhen_u24lambda_u2d7;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                ASTNode it = (ASTNode)item$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getLBRACE())) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = -1;
        }
        int n2 = n;
        List childrenAfterLbrace = list.subList(n2, $this$checkWhen_u24lambda_u2d7.size());
        object = CollectionsKt.distinct((Iterable)childrenAfterLbrace);
        List<IElementType> list3 = AstConstantsKt.getEmptyBlockList();
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            IElementType iElementType = it.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"it.elementType");
            collection.add(iElementType);
        }
        if (!list3.containsAll((List)destination$iv$iv)) {
            this.checkOpenBraceOnSameLine(node, ElementType.INSTANCE.getLBRACE(), configuration2);
            this.checkCloseBrace(node, configuration2);
        }
    }

    private final void checkFun(ASTNode node, BlockStructureBracesConfiguration configuration2) {
        if (!AstNodeUtilsKt.isBlockEmpty(node.findChildByType(ElementType.INSTANCE.getBLOCK()))) {
            this.checkOpenBraceOnSameLine(node, ElementType.INSTANCE.getBLOCK(), configuration2);
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getBLOCK());
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode aSTNode2 = aSTNode;
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(BLOCK)!!");
            this.checkCloseBrace(aSTNode2, configuration2);
        }
    }

    private final void checkIf(ASTNode node, BlockStructureBracesConfiguration configuration2) {
        ASTNode elseNode;
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtIfExpression");
        }
        KtIfExpression ifPsi = (KtIfExpression)psiElement;
        KtExpression ktExpression = ifPsi.getThen();
        ASTNode thenNode = ktExpression == null ? null : ktExpression.getNode();
        boolean hasElseBranch = ifPsi.getElseKeyword() != null;
        KtExpression ktExpression2 = ifPsi.getElse();
        Object object = elseNode = ktExpression2 == null ? null : ktExpression2.getNode();
        if (thenNode != null && AstNodeUtilsKt.hasChildOfType(thenNode, ElementType.INSTANCE.getLBRACE())) {
            this.checkOpenBraceOnSameLine(node, ElementType.INSTANCE.getTHEN(), configuration2);
            this.checkCloseBrace(thenNode, configuration2);
            if (hasElseBranch) {
                ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTHEN());
                Intrinsics.checkNotNull((Object)aSTNode);
                List allMiddleNode = CollectionsKt.listOf((Object)aSTNode.getTreeNext());
                this.checkMidBrace(allMiddleNode, node, ElementType.INSTANCE.getELSE_KEYWORD());
            }
        }
        if (hasElseBranch && elseNode != null && !Intrinsics.areEqual((Object)elseNode.getElementType(), (Object)ElementType.INSTANCE.getIF()) && AstNodeUtilsKt.hasChildOfType(elseNode, ElementType.INSTANCE.getLBRACE())) {
            this.checkOpenBraceOnSameLine(node, ElementType.INSTANCE.getELSE(), configuration2);
            this.checkCloseBrace(elseNode, configuration2);
        }
    }

    private final void checkOpenBraceOnSameLine(ASTNode node, IElementType beforeType, BlockStructureBracesConfiguration configuration2) {
        ASTNode braceSpace;
        ASTNode nodeBefore;
        if (!configuration2.getOpenBrace()) {
            return;
        }
        ASTNode aSTNode = nodeBefore = node.findChildByType(beforeType);
        Object object = braceSpace = aSTNode == null ? null : aSTNode.getTreePrev();
        if (braceSpace == null || this.checkBraceNode(braceSpace, true)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            ASTNode aSTNode2 = braceSpace;
            if (aSTNode2 == null) {
                aSTNode2 = node;
            }
            Warnings.warnAndFix$default(Warnings.BRACES_BLOCK_STRUCTURE_ERROR, list, function3, bl, "incorrect newline before opening brace", aSTNode2.getStartOffset(), node, false, (Function0)new Function0<Unit>(braceSpace, node, nodeBefore){
                final /* synthetic */ ASTNode $braceSpace;
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ ASTNode $nodeBefore;
                {
                    this.$braceSpace = $braceSpace;
                    this.$node = $node;
                    this.$nodeBefore = $nodeBefore;
                    super(0);
                }

                public final void invoke() {
                    if (this.$braceSpace == null || !Intrinsics.areEqual((Object)this.$braceSpace.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                        this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), this.$nodeBefore);
                    } else {
                        if (AstConstantsKt.getCommentType().contains(this.$braceSpace.getTreePrev().getElementType())) {
                            ASTNode commentBefore = this.$braceSpace.getTreePrev();
                            if (Intrinsics.areEqual((Object)commentBefore.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                                commentBefore.getTreeParent().removeChild(commentBefore.getTreePrev());
                            }
                            commentBefore.getTreeParent().removeChild(commentBefore);
                            this.$node.getTreeParent().addChild((ASTNode)commentBefore.clone(), this.$node);
                            this.$node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$node);
                        }
                        ASTNode aSTNode = this.$braceSpace.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"braceSpace.treeParent");
                        AstNodeUtilsKt.replaceWhiteSpaceText(aSTNode, this.$braceSpace, " ");
                    }
                }
            }, 64, null);
        }
        this.checkOpenBraceEndLine(node, beforeType);
    }

    private final void checkOpenBraceEndLine(ASTNode node, IElementType beforeType) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode aSTNode3;
        ASTNode aSTNode4 = aSTNode3 = Intrinsics.areEqual((Object)beforeType, (Object)ElementType.INSTANCE.getTHEN()) || Intrinsics.areEqual((Object)beforeType, (Object)ElementType.INSTANCE.getELSE()) ? node.findChildByType(beforeType) : node;
        ASTNode aSTNode5 = aSTNode3 == null ? null : (aSTNode2 = (aSTNode = AstNodeUtilsKt.findLBrace(aSTNode3)) == null ? null : aSTNode.getTreeNext());
        if (aSTNode2 == null) {
            return;
        }
        ASTNode newNode = aSTNode2;
        if (BlockStructureBraces.checkBraceNode$default(this, newNode, false, 2, null)) {
            Warnings.warnAndFix$default(Warnings.BRACES_BLOCK_STRUCTURE_ERROR, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "incorrect same line after opening brace", newNode.getStartOffset(), newNode, false, (Function0)new Function0<Unit>(newNode){
                final /* synthetic */ ASTNode $newNode;
                {
                    this.$newNode = $newNode;
                    super(0);
                }

                public final void invoke() {
                    if (!Intrinsics.areEqual((Object)this.$newNode.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                        this.$newNode.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$newNode);
                    } else {
                        ((LeafPsiElement)this.$newNode).rawReplaceWithText("\n");
                    }
                }
            }, 64, null);
        }
    }

    private final void checkMidBrace(List<? extends ASTNode> allMiddleSpace, ASTNode node, IElementType keyword) {
        Iterable $this$forEach$iv = allMiddleSpace;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode space = (ASTNode)element$iv;
            boolean bl = false;
            if (!this.checkBraceNode(space, true)) continue;
            Warnings.warnAndFix$default(Warnings.BRACES_BLOCK_STRUCTURE_ERROR, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "incorrect new line after closing brace", space.getStartOffset(), space, false, (Function0)new Function0<Unit>(space, node, keyword){
                final /* synthetic */ ASTNode $space;
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ IElementType $keyword;
                {
                    this.$space = $space;
                    this.$node = $node;
                    this.$keyword = $keyword;
                    super(0);
                }

                public final void invoke() {
                    if (!Intrinsics.areEqual((Object)this.$space.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                        this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), this.$node.findChildByType(this.$keyword));
                    } else {
                        ((LeafPsiElement)this.$space).rawReplaceWithText(" ");
                    }
                }
            }, 64, null);
        }
    }

    private final void checkCloseBrace(ASTNode node, BlockStructureBracesConfiguration configuration2) {
        if (!configuration2.getCloseBrace()) {
            return;
        }
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getRBRACE());
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode space = aSTNode.getTreePrev();
        ASTNode aSTNode2 = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getLAMBDA_ARGUMENT());
        if (aSTNode2 != null) {
            ASTNode it = aSTNode2;
            boolean bl = false;
            String string = space.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"space.text");
            if (((CharSequence)string).length() == 0) {
                return;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)space, (String)"space");
        if (BlockStructureBraces.checkBraceNode$default(this, space, false, 2, null)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            ASTNode aSTNode3 = space.getTreeNext();
            if (aSTNode3 == null) {
                aSTNode3 = node.findChildByType(ElementType.INSTANCE.getRBRACE());
            }
            Intrinsics.checkNotNull((Object)aSTNode3);
            Warnings.warnAndFix$default(Warnings.BRACES_BLOCK_STRUCTURE_ERROR, list, function3, bl, "no newline before closing brace", aSTNode3.getStartOffset(), node, false, (Function0)new Function0<Unit>(space, node){
                final /* synthetic */ ASTNode $space;
                final /* synthetic */ ASTNode $node;
                {
                    this.$space = $space;
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    if (!Intrinsics.areEqual((Object)this.$space.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                        this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$node.findChildByType(ElementType.INSTANCE.getRBRACE()));
                    } else {
                        ASTNode aSTNode = this.$space;
                        if (aSTNode == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                        }
                        ((LeafPsiElement)aSTNode).rawReplaceWithText("\n");
                    }
                }
            }, 64, null);
        }
    }

    private final boolean checkBraceNode(ASTNode node, boolean shouldContainNewline) {
        return shouldContainNewline == PackageKt.isWhiteSpaceWithNewline((ASTNode)node);
    }

    static /* synthetic */ boolean checkBraceNode$default(BlockStructureBraces blockStructureBraces, ASTNode aSTNode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return blockStructureBraces.checkBraceNode(aSTNode, bl);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/BlockStructureBraces$BlockStructureBracesConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "closeBrace", "", "getCloseBrace", "()Z", "openBrace", "getOpenBrace", "diktat-rules"})
    public static final class BlockStructureBracesConfiguration
    extends RuleConfiguration {
        private final boolean openBrace;
        private final boolean closeBrace;

        public BlockStructureBracesConfiguration(@NotNull Map<String, String> config2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("openBraceNewline");
            this.openBrace = string == null ? true : (bl = Boolean.parseBoolean(string));
            string = config2.get("closeBraceNewline");
            this.closeBrace = string == null ? true : (bl = Boolean.parseBoolean(string));
        }

        public final boolean getOpenBrace() {
            return this.openBrace;
        }

        public final boolean getCloseBrace() {
            return this.closeBrace;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/BlockStructureBraces$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

