/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0011\u001a\u00020\u000e*\u00020\tH\u0002J\u0011\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014*\u00020\tH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/ConsecutiveSpacesRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkWhiteSpace", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter3/ConsecutiveSpacesRule$TooManySpacesRuleConfiguration;", "checkWhiteSpaceEnum", "isWhitespaceInEnum", "", "logic", "squeezeSpacesToOne", "hasEolComment", "squeezeSpaces", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/source/tree/LeafElement;", "Lorg/jetbrains/annotations/NotNull;", "Companion", "TooManySpacesRuleConfiguration", "diktat-rules"})
public final class ConsecutiveSpacesRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_SPACES = 1;
    @NotNull
    public static final String NAME_ID = "aco-too-many-spaces";

    public ConsecutiveSpacesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.TOO_MANY_CONSECUTIVE_SPACES)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.TOO_MANY_CONSECUTIVE_SPACES);
        Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        TooManySpacesRuleConfiguration configuration2 = new TooManySpacesRuleConfiguration(map);
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            this.checkWhiteSpace(node, configuration2);
        }
    }

    private final void checkWhiteSpace(ASTNode node, TooManySpacesRuleConfiguration configuration2) {
        if (configuration2.getEnumInitialFormatting()) {
            this.checkWhiteSpaceEnum(node, configuration2);
        } else {
            this.squeezeSpacesToOne(node, configuration2);
        }
    }

    private final void checkWhiteSpaceEnum(ASTNode node, TooManySpacesRuleConfiguration configuration2) {
        boolean isInEnum = this.isWhitespaceInEnum(node);
        if (!isInEnum) {
            this.squeezeSpacesToOne(node, configuration2);
        }
    }

    private final boolean isWhitespaceInEnum(ASTNode node) {
        return PackageKt.parent$default((ASTNode)node, (IElementType)ElementType.INSTANCE.getENUM_ENTRY(), (boolean)false, (int)2, null) != null;
    }

    private final void squeezeSpacesToOne(ASTNode node, TooManySpacesRuleConfiguration configuration2) {
        int spaces = node.getTextLength();
        if (spaces > configuration2.getNumberOfSpaces() && !PackageKt.isWhiteSpaceWithNewline((ASTNode)node) && !this.hasEolComment(node)) {
            Warnings.warnAndFix$default(Warnings.TOO_MANY_CONSECUTIVE_SPACES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "found: " + spaces + ". need to be: " + configuration2.getNumberOfSpaces(), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node){
                final /* synthetic */ ConsecutiveSpacesRule this$0;
                final /* synthetic */ ASTNode $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ConsecutiveSpacesRule.access$squeezeSpaces(this.this$0, this.$node);
                }
            }, 64, null);
        }
    }

    private final boolean hasEolComment(ASTNode $this$hasEolComment) {
        return Intrinsics.areEqual((Object)$this$hasEolComment.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getEOL_COMMENT());
    }

    private final LeafElement squeezeSpaces(ASTNode $this$squeezeSpaces) {
        LeafElement leafElement = ((LeafElement)$this$squeezeSpaces).rawReplaceWithText(" ");
        Intrinsics.checkNotNullExpressionValue((Object)leafElement, (String)"this as LeafElement).rawReplaceWithText(\" \")");
        return leafElement;
    }

    public static final /* synthetic */ LeafElement access$squeezeSpaces(ConsecutiveSpacesRule $this, ASTNode $receiver) {
        return $this.squeezeSpaces($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/ConsecutiveSpacesRule$TooManySpacesRuleConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "enumInitialFormatting", "", "getEnumInitialFormatting", "()Z", "numberOfSpaces", "", "getNumberOfSpaces", "()I", "diktat-rules"})
    public static final class TooManySpacesRuleConfiguration
    extends RuleConfiguration {
        private final int numberOfSpaces;
        private final boolean enumInitialFormatting;

        public TooManySpacesRuleConfiguration(@NotNull Map<String, String> config2) {
            boolean bl;
            int n;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("maxSpaces");
            if (string == null) {
                n = 1;
            } else {
                Integer n2 = StringsKt.toIntOrNull((String)string);
                n = n2 == null ? 1 : n2;
            }
            this.numberOfSpaces = n;
            String string2 = config2.get("saveInitialFormattingForEnums");
            this.enumInitialFormatting = string2 == null ? false : (bl = Boolean.parseBoolean(string2));
        }

        public final int getNumberOfSpaces() {
            return this.numberOfSpaces;
        }

        public final boolean getEnumInitialFormatting() {
            return this.enumInitialFormatting;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/ConsecutiveSpacesRule$Companion;", "", "()V", "MAX_SPACES", "", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

