/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.StringCaseUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/EmptyBlock;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkEmptyBlock", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter3/EmptyBlock$EmptyBlockStyleConfiguration;", "isAnonymousSamClass", "", "isLambdaUsedAsFunction", "isNewLine", "logic", "searchNode", "Companion", "EmptyBlockStyleConfiguration", "diktat-rules"})
public final class EmptyBlock
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aan-empty-block-structure";

    public EmptyBlock(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.EMPTY_BLOCK_STRUCTURE_ERROR)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.EMPTY_BLOCK_STRUCTURE_ERROR);
        Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        EmptyBlockStyleConfiguration configuration2 = new EmptyBlockStyleConfiguration(map);
        this.searchNode(node, configuration2);
    }

    private final void searchNode(ASTNode node, EmptyBlockStyleConfiguration configuration2) {
        ASTNode aSTNode = AstNodeUtilsKt.findLBrace(node);
        Object object = aSTNode == null ? null : aSTNode.getTreeParent();
        if (object == null) {
            return;
        }
        ASTNode newNode = object;
        this.checkEmptyBlock(newNode, configuration2);
    }

    private final boolean isNewLine(ASTNode node) {
        boolean bl;
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getWHITE_SPACE());
        if (aSTNode == null) {
            bl = false;
        } else {
            boolean bl2;
            String string = aSTNode.getText();
            bl = string == null ? false : (bl2 = StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkEmptyBlock(ASTNode node, EmptyBlockStyleConfiguration configuration2) {
        String string;
        ASTNode aSTNode = node.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
        if (AstNodeUtilsKt.isOverridden(aSTNode)) return;
        if (this.isAnonymousSamClass(node)) return;
        if (this.isLambdaUsedAsFunction(node)) {
            return;
        }
        if (!AstNodeUtilsKt.isBlockEmpty(node)) return;
        if (!configuration2.getEmptyBlockExist()) {
            Warnings.EMPTY_BLOCK_STRUCTURE_ERROR.warn(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "empty blocks are forbidden unless it is function with override keyword", node.getStartOffset(), node);
            return;
        }
        ASTNode aSTNode2 = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getLAMBDA_ARGUMENT());
        if (aSTNode2 != null) {
            ASTNode it = aSTNode2;
            boolean bl = false;
            if (!this.isNewLine(node)) return;
            String freeText = "do not put newlines in empty lambda";
            Warnings.warnAndFix$default(Warnings.EMPTY_BLOCK_STRUCTURE_ERROR, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ASTNode whiteSpaceNode;
                    ASTNode aSTNode = whiteSpaceNode = this.$node.findChildByType(ElementType.INSTANCE.getWHITE_SPACE());
                    if (aSTNode != null) {
                        ASTNode aSTNode2 = aSTNode;
                        ASTNode aSTNode3 = this.$node;
                        ASTNode it = aSTNode2;
                        boolean bl = false;
                        aSTNode3.replaceChild(whiteSpaceNode, (ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "));
                    }
                }
            }, 64, null);
            return;
        }
        ASTNode aSTNode3 = node.findChildByType(ElementType.INSTANCE.getRBRACE());
        Intrinsics.checkNotNull((Object)aSTNode3);
        ASTNode space = aSTNode3.getTreePrev();
        if (configuration2.getEmptyBlockNewline()) {
            string = space.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"space.text");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                Warnings.warnAndFix$default(Warnings.EMPTY_BLOCK_STRUCTURE_ERROR, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "different style for empty block", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(space, node){
                    final /* synthetic */ ASTNode $space;
                    final /* synthetic */ ASTNode $node;
                    {
                        this.$space = $space;
                        this.$node = $node;
                        super(0);
                    }

                    public final void invoke() {
                        if (Intrinsics.areEqual((Object)this.$space.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                            ASTNode aSTNode = this.$space.getTreeNext();
                            if (aSTNode == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
                            }
                            ((LeafPsiElement)aSTNode).rawReplaceWithText("\n");
                        } else {
                            this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$space.getTreeNext());
                        }
                    }
                }, 64, null);
                return;
            }
        }
        if (configuration2.getEmptyBlockNewline()) return;
        string = space.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"space.text");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) return;
        Warnings.warnAndFix$default(Warnings.EMPTY_BLOCK_STRUCTURE_ERROR, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "different style for empty block", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node, space){
            final /* synthetic */ ASTNode $node;
            final /* synthetic */ ASTNode $space;
            {
                this.$node = $node;
                this.$space = $space;
                super(0);
            }

            public final void invoke() {
                this.$node.removeChild(this.$space);
            }
        }, 64, null);
    }

    private final boolean isAnonymousSamClass(ASTNode node) {
        boolean bl;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL()) && AstNodeUtilsKt.hasParent(node, ElementType.INSTANCE.getCALL_EXPRESSION())) {
            ASTNode aSTNode = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getCALL_EXPRESSION());
            Intrinsics.checkNotNull((Object)aSTNode);
            ASTNode valueArgument = aSTNode;
            ASTNode aSTNode2 = AstNodeUtilsKt.findLeafWithSpecificType(valueArgument, ElementType.INSTANCE.getIDENTIFIER());
            if (aSTNode2 == null) {
                bl = false;
            } else {
                boolean bl2;
                String string = aSTNode2.getText();
                bl = string == null ? false : (bl2 = StringCaseUtilsKt.isPascalCase(string));
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isLambdaUsedAsFunction(ASTNode node) {
        boolean bl;
        boolean bl2;
        Object it;
        boolean $i$f$any;
        Sequence $this$any$iv;
        Sequence parents;
        block8: {
            parents = PsiUtilsKt.parents((ASTNode)node);
            $this$any$iv = parents;
            $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                it = (ASTNode)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getCALL_EXPRESSION())) continue;
                bl2 = true;
                break block8;
            }
            bl2 = false;
        }
        if (bl2) {
            Object object;
            block9: {
                Object element$iv;
                element$iv = parents.iterator();
                while (element$iv.hasNext()) {
                    Object it2 = it = element$iv.next();
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it2.getElementType(), (Object)ElementType.INSTANCE.getCALL_EXPRESSION())) continue;
                    object = it;
                    break block9;
                }
                object = null;
            }
            Intrinsics.checkNotNull(object);
            ASTNode callExpression = object;
            bl = AstNodeUtilsKt.hasChildOfType(callExpression, ElementType.INSTANCE.getVALUE_ARGUMENT_LIST());
        } else {
            boolean bl5;
            block10: {
                $this$any$iv = parents;
                $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    it = (ASTNode)element$iv;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getLAMBDA_EXPRESSION())) continue;
                    bl5 = true;
                    break block10;
                }
                bl5 = false;
            }
            if (bl5) {
                Object v4;
                block11: {
                    for (Object e : parents) {
                        ASTNode it3 = (ASTNode)e;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)it3.getElementType(), (Object)ElementType.INSTANCE.getLAMBDA_EXPRESSION())) continue;
                        v4 = e;
                        break block11;
                    }
                    v4 = null;
                }
                Intrinsics.checkNotNull(v4);
                ASTNode lambdaExpression = v4;
                bl = Intrinsics.areEqual((Object)lambdaExpression.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER());
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/EmptyBlock$EmptyBlockStyleConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "emptyBlockExist", "", "getEmptyBlockExist", "()Z", "emptyBlockNewline", "getEmptyBlockNewline", "diktat-rules"})
    public static final class EmptyBlockStyleConfiguration
    extends RuleConfiguration {
        private final boolean emptyBlockExist;
        private final boolean emptyBlockNewline;

        public EmptyBlockStyleConfiguration(@NotNull Map<String, String> config2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("allowEmptyBlocks");
            this.emptyBlockExist = string == null ? false : (bl = Boolean.parseBoolean(string));
            string = config2.get("styleEmptyBlockWithNewline");
            this.emptyBlockNewline = string == null ? true : (bl = Boolean.parseBoolean(string));
        }

        public final boolean getEmptyBlockExist() {
            return this.emptyBlockExist;
        }

        public final boolean getEmptyBlockNewline() {
            return this.emptyBlockNewline;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/EmptyBlock$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

