/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u0003H\u0002J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/EnumsSeparated;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkEnumEntry", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkLastEnum", "isEnumOneLine", "", "nodes", "isEnumSimple", "enumEntries", "logic", "Companion", "diktat-rules"})
public final class EnumsSeparated
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "abq-enum-separated";
    @NotNull
    private static final List<IElementType> simpleValue;
    @NotNull
    private static final List<IElementType> simpleEnum;

    public EnumsSeparated(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.ENUMS_SEPARATED)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCLASS()) && AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getCLASS_BODY()) && AstNodeUtilsKt.isClassEnum(node)) {
            this.checkEnumEntry(node);
        }
    }

    private final void checkEnumEntry(ASTNode node) {
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getCLASS_BODY());
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode aSTNode2 = aSTNode;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(CLASS_BODY)!!");
        List<ASTNode> enumEntries = AstNodeUtilsKt.getAllChildrenWithType(aSTNode2, ElementType.INSTANCE.getENUM_ENTRY());
        if (enumEntries.isEmpty() || this.isEnumSimple(enumEntries) && this.isEnumOneLine(enumEntries)) {
            return;
        }
        Iterable $this$forEach$iv = enumEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (PackageKt.isWhiteSpaceWithNewline((ASTNode)it.getTreeNext())) continue;
            Warnings.warnAndFix$default(Warnings.ENUMS_SEPARATED, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "enum entries must end with a line break", it.getStartOffset(), it, false, (Function0)new Function0<Unit>(it){
                final /* synthetic */ ASTNode $it;
                {
                    this.$it = $it;
                    super(0);
                }

                public final void invoke() {
                    AstNodeUtilsKt.appendNewlineMergingWhiteSpace(this.$it, this.$it.getTreeNext(), this.$it.getTreeNext());
                }
            }, 64, null);
        }
        this.checkLastEnum((ASTNode)CollectionsKt.last(enumEntries));
    }

    private final boolean isEnumOneLine(List<? extends ASTNode> nodes) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = CollectionsKt.dropLast(nodes, (int)1);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!PackageKt.isWhiteSpaceWithNewline((ASTNode)it.getTreeNext())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEnumSimple(List<? extends ASTNode> enumEntries) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IElementType iElementType;
        ASTNode aSTNode;
        Iterable $this$forEach$iv = enumEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            ASTNode node = (ASTNode)element$iv;
            boolean bl = false;
            Object[] objectArray = node.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"node.getChildren(null)");
            objectArray = objectArray;
            aSTNode = simpleValue;
            boolean $i$f$map = false;
            iElementType = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv2).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ASTNode aSTNode2 = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                IElementType iElementType2 = it.getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"it.elementType");
                collection.add(iElementType2);
            }
            if (aSTNode.containsAll((List)destination$iv$iv)) continue;
            return false;
        }
        $this$forEach$iv = AstNodeUtilsKt.allSiblings((ASTNode)CollectionsKt.last(enumEntries), true);
        List<IElementType> list = simpleEnum;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            aSTNode = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            iElementType = it.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"it.elementType");
            collection.add(iElementType);
        }
        return list.containsAll((List)destination$iv$iv);
    }

    private final void checkLastEnum(ASTNode node) {
        if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getSEMICOLON())) {
            Warnings.warnAndFix$default(Warnings.ENUMS_SEPARATED, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "enums must end with semicolon", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    this.$node.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getSEMICOLON(), (CharSequence)";"), null);
                    ASTNode aSTNode = (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n");
                    ASTNode aSTNode2 = this.$node.findChildByType(ElementType.INSTANCE.getSEMICOLON());
                    Intrinsics.checkNotNull((Object)aSTNode2);
                    this.$node.addChild(aSTNode, aSTNode2);
                }
            }, 64, null);
        } else {
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getSEMICOLON());
            Intrinsics.checkNotNull((Object)aSTNode);
            if (!PackageKt.isWhiteSpaceWithNewline((ASTNode)aSTNode.getTreePrev())) {
                Warnings.warnAndFix$default(Warnings.ENUMS_SEPARATED, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "semicolon must be on a new line", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                    final /* synthetic */ ASTNode $node;
                    {
                        this.$node = $node;
                        super(0);
                    }

                    public final void invoke() {
                        ASTNode aSTNode = this.$node.findChildByType(ElementType.INSTANCE.getSEMICOLON());
                        Intrinsics.checkNotNull((Object)aSTNode);
                        ASTNode aSTNode2 = this.$node.findChildByType(ElementType.INSTANCE.getSEMICOLON());
                        Intrinsics.checkNotNull((Object)aSTNode2);
                        AstNodeUtilsKt.appendNewlineMergingWhiteSpace(this.$node, aSTNode, aSTNode2);
                    }
                }, 64, null);
            }
        }
        if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getCOMMA())) {
            Warnings.warnAndFix$default(Warnings.ENUMS_SEPARATED, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "last enum entry must end with a comma", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode = (ASTNode)new LeafPsiElement(ElementType.INSTANCE.getCOMMA(), (CharSequence)",");
                    ASTNode aSTNode2 = this.$node.findChildByType(ElementType.INSTANCE.getSEMICOLON());
                    Intrinsics.checkNotNull((Object)aSTNode2);
                    this.$node.addChild(aSTNode, aSTNode2.getTreePrev());
                }
            }, 64, null);
        }
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getIDENTIFIER(), ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getCOMMA(), ElementType.INSTANCE.getSEMICOLON()};
        simpleValue = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new IElementType[]{ElementType.INSTANCE.getENUM_ENTRY(), ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getLBRACE(), ElementType.INSTANCE.getRBRACE()};
        simpleEnum = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/EnumsSeparated$Companion;", "", "()V", "NAME_ID", "", "simpleEnum", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "simpleValue", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

