/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter3.LineLength;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 ;2\u00020\u0001:\u0003;<=B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0011H\u0002J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013H\u0002J\u0010\u00102\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u00103\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u00104\u001a\u0002052\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u00106\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u001e\u00107\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130 H\u0002J \u00108\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u000eH\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u000f0\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LineLengthConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LineLengthConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "positionByOffset", "Lkotlin/Function1;", "", "Lkotlin/Pair;", "checkComment", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "wrongNode", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkCondition", "checkFun", "checkLength", "", "node", "checkProperty", "checkStringTemplate", "createSplitProperty", "wrongProperty", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Property;", "dfsForProperty", "binList", "", "findAllText", "", "astNode", "fixBinaryExpression", "fixComment", "wrongComment", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Comment;", "fixError", "fixableType", "fixLongBinaryExpression", "wrongBinaryExpression", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Condition;", "fixStringTemplate", "wrongStringTemplate", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$StringTemplate;", "getBraceAndBeforeText", "prevNode", "getTextFromParenthesized", "isFixable", "isKdocValid", "", "logic", "searchBinaryExpression", "splitTextAndCreateNode", "text", "index", "Companion", "LineLengthConfiguration", "LongLineFixableCases", "diktat-rules"})
public final class LineLength
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configuration$delegate;
    private Function1<? super Integer, Pair<Integer, Integer>> positionByOffset;
    private static final long MAX_LENGTH = 120L;
    @NotNull
    public static final String NAME_ID = "abv-line-length";
    private static final int STRING_PART_OFFSET = 4;
    @NotNull
    private static final List<IElementType> propertyList;

    public LineLength(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.LONG_LINE)), null, 8, null);
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LineLengthConfiguration>(configRules){
            final /* synthetic */ List<RulesConfig> $configRules;
            {
                this.$configRules = $configRules;
                super(0);
            }

            @NotNull
            public final LineLengthConfiguration invoke() {
                RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.$configRules, (Rule)Warnings.LONG_LINE);
                Map<K, V> map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return new LineLengthConfiguration(map);
            }
        }));
    }

    private final LineLengthConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (LineLengthConfiguration)((Object)lazy.getValue());
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            ASTNode[] aSTNodeArray = node.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
            Object[] $this$forEach$iv = aSTNodeArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getPACKAGE_DIRECTIVE()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_LIST())) continue;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.checkLength(it, this.getConfiguration());
            }
        }
    }

    private final void checkLength(ASTNode node, LineLengthConfiguration configuration2) {
        Ref.IntRef offset2 = new Ref.IntRef();
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)string);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line;
            block3: {
                ASTNode newNode;
                block4: {
                    line = (String)element$iv;
                    boolean bl = false;
                    if ((long)line.length() <= configuration2.getLineLength()) break block3;
                    PsiElement psiElement = node.getPsi().findElementAt(offset2.element + (int)configuration2.getLineLength() - 1);
                    Intrinsics.checkNotNull((Object)psiElement);
                    newNode = psiElement.getNode();
                    if (!Intrinsics.areEqual((Object)newNode.getElementType(), (Object)ElementType.INSTANCE.getKDOC_TEXT()) && !Intrinsics.areEqual((Object)newNode.getElementType(), (Object)ElementType.INSTANCE.getKDOC_MARKDOWN_INLINE_LINK())) break block4;
                    Intrinsics.checkNotNullExpressionValue((Object)newNode, (String)"newNode");
                    if (this.isKdocValid(newNode)) break block3;
                }
                ASTNode aSTNode = node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
                this.positionByOffset = AstNodeUtilsKt.calculateLineColByOffset(aSTNode);
                Intrinsics.checkNotNullExpressionValue((Object)newNode, (String)"newNode");
                LongLineFixableCases fixableType = this.isFixable(newNode, configuration2);
                Warnings.LONG_LINE.warnAndFix(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "max line length " + configuration2.getLineLength() + ", but was " + line.length(), offset2.element + node.getStartOffset(), node, !Intrinsics.areEqual((Object)fixableType, (Object)LongLineFixableCases.None.INSTANCE), (Function0<Unit>)((Function0)new Function0<Unit>(node, this, fixableType, offset2){
                    final /* synthetic */ ASTNode $node;
                    final /* synthetic */ LineLength this$0;
                    final /* synthetic */ LongLineFixableCases $fixableType;
                    final /* synthetic */ Ref.IntRef $offset;
                    {
                        this.$node = $node;
                        this.this$0 = $receiver;
                        this.$fixableType = $fixableType;
                        this.$offset = $offset;
                        super(0);
                    }

                    public final void invoke() {
                        int textLenBeforeFix = this.$node.getTextLength();
                        LineLength.access$fixError(this.this$0, this.$fixableType);
                        int textLenAfterFix = this.$node.getTextLength();
                        this.$offset.element += textLenAfterFix - textLenBeforeFix;
                    }
                }));
            }
            offset2.element += line.length() + 1;
        }
    }

    private final LongLineFixableCases isFixable(ASTNode wrongNode, LineLengthConfiguration configuration2) {
        ASTNode parent = null;
        parent = wrongNode;
        do {
            ASTNode aSTNode;
            block12: {
                block15: {
                    Unit unit;
                    Unit unit2;
                    block13: {
                        ASTNode node;
                        block17: {
                            block16: {
                                boolean bl;
                                block11: {
                                    block14: {
                                        Unit unit3;
                                        IElementType iElementType;
                                        if (Intrinsics.areEqual((Object)(iElementType = parent.getElementType()), (Object)ElementType.INSTANCE.getFUN())) {
                                            return this.checkFun(parent);
                                        }
                                        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCONDITION())) {
                                            return this.checkCondition(parent, configuration2);
                                        }
                                        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPROPERTY())) {
                                            return this.checkProperty(parent, configuration2);
                                        }
                                        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEOL_COMMENT())) {
                                            return this.checkComment(parent, configuration2);
                                        }
                                        if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) break block12;
                                        if (AstNodeUtilsKt.findParentNodeWithSpecificType(parent, ElementType.INSTANCE.getIF()) == null) {
                                            unit3 = null;
                                        } else {
                                            boolean bl2 = false;
                                            ASTNode aSTNode2 = parent.getTreeParent();
                                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"parent.treeParent");
                                            parent = aSTNode2;
                                            unit3 = unit2 = Unit.INSTANCE;
                                        }
                                        if (unit2 != null) break block13;
                                        if (AstNodeUtilsKt.findParentNodeWithSpecificType(parent, ElementType.INSTANCE.getFUN()) != null) break block14;
                                        unit = null;
                                        break block15;
                                    }
                                    boolean bl3 = false;
                                    if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getEQ())) break block16;
                                    Sequence $this$any$iv = PsiUtilsKt.parents((ASTNode)wrongNode);
                                    boolean $i$f$any = false;
                                    for (Object element$iv : $this$any$iv) {
                                        ASTNode it = (ASTNode)element$iv;
                                        boolean bl4 = false;
                                        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getANNOTATION_ENTRY())) continue;
                                        bl = true;
                                        break block11;
                                    }
                                    bl = false;
                                }
                                if (!bl) break block17;
                            }
                            return this.checkStringTemplate(parent, configuration2);
                        }
                        parent = node;
                        unit = Unit.INSTANCE;
                        break block15;
                    }
                    unit = aSTNode = unit2;
                }
                if (aSTNode != null) continue;
                return this.checkStringTemplate(parent, configuration2);
            }
            aSTNode = parent.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"parent.treeParent");
            parent = aSTNode;
        } while (parent.getTreeParent() != null);
        return LongLineFixableCases.None.INSTANCE;
    }

    private final LongLineFixableCases checkStringTemplate(ASTNode node, LineLengthConfiguration configuration2) {
        int correcterDelimiter;
        int n;
        boolean shouldAddTwoSpaces;
        int n2;
        String string;
        int multiLineOffset = 0;
        Object object = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
        if (StringsKt.lines((CharSequence)((CharSequence)object)).size() > 1) {
            Object object2;
            block14: {
                String $this$first$iv;
                Object element$iv;
                Iterable $this$takeWhile$iv;
                boolean $i$f$takeWhile;
                block13: {
                    String it;
                    Object $this$forEach$iv;
                    object = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node\n                .text");
                    object = StringsKt.lines((CharSequence)((CharSequence)object));
                    $i$f$takeWhile = false;
                    Iterator list$iv = new ArrayList();
                    for (Object item$iv : $this$takeWhile$iv) {
                        String it2 = (String)item$iv;
                        boolean bl = false;
                        if (!((long)it2.length() < configuration2.getLineLength())) break;
                        ((ArrayList)((Object)list$iv)).add(item$iv);
                    }
                    $this$takeWhile$iv = (List)((Object)list$iv);
                    boolean $i$f$forEach = false;
                    list$iv = $this$forEach$iv.iterator();
                    while (list$iv.hasNext()) {
                        element$iv = list$iv.next();
                        it = (String)element$iv;
                        boolean bl = false;
                        multiLineOffset += it.length();
                    }
                    $this$forEach$iv = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"node\n                .text");
                    $this$forEach$iv = StringsKt.lines((CharSequence)((CharSequence)$this$forEach$iv));
                    boolean $i$f$first = false;
                    list$iv = $this$first$iv.iterator();
                    while (list$iv.hasNext()) {
                        element$iv = list$iv.next();
                        it = (String)element$iv;
                        boolean bl = false;
                        if (!((long)it.length() > configuration2.getLineLength())) continue;
                        break block13;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                $this$first$iv = (String)element$iv;
                $i$f$takeWhile = false;
                int list$iv = 0;
                int element$iv2 = ((String)((Object)$this$takeWhile$iv)).length();
                while (list$iv < element$iv2) {
                    int index$iv = list$iv++;
                    char it = ((String)((Object)$this$takeWhile$iv)).charAt(index$iv);
                    boolean bl = false;
                    if (CharsKt.isWhitespace((char)it)) continue;
                    Iterable iterable = $this$takeWhile$iv;
                    int n3 = 0;
                    string = ((String)((Object)iterable)).substring(n3, index$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    object2 = string;
                    break block14;
                }
                object2 = $this$takeWhile$iv;
            }
            n2 = ((CharSequence)object2).length();
        } else {
            Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
            if (function1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
                function1 = null;
            }
            n2 = ((Number)((Pair)function1.invoke((Object)node.getStartOffset())).getSecond()).intValue();
        }
        int leftOffset = n2;
        String $i$f$takeWhile = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$takeWhile, (String)"node.text");
        String index$iv = $i$f$takeWhile.substring(0, multiLineOffset + (int)configuration2.getLineLength() - leftOffset);
        Intrinsics.checkNotNullExpressionValue((Object)index$iv, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        int delimiterIndex = StringsKt.lastIndexOf$default((CharSequence)index$iv, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (delimiterIndex == -1) {
            ASTNode aSTNode = node.getTreeParent().findChildByType(ElementType.INSTANCE.getOPERATION_REFERENCE());
            if (aSTNode != null) {
                ASTNode it = aSTNode;
                boolean bl = false;
                ASTNode aSTNode2 = node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
                return new LongLineFixableCases.BinaryExpression(aSTNode2);
            }
            return LongLineFixableCases.None.INSTANCE;
        }
        PsiElement psiElement = node.getPsi().findElementAt(delimiterIndex);
        Intrinsics.checkNotNull((Object)psiElement);
        boolean isSpaceIsWhiteSpace = PackageKt.isWhiteSpace((ASTNode)psiElement.getNode());
        if (isSpaceIsWhiteSpace) {
            return LongLineFixableCases.None.INSTANCE;
        }
        boolean bl = shouldAddTwoSpaces = multiLineOffset == 0 && leftOffset + delimiterIndex > (int)configuration2.getLineLength() - 2;
        if (shouldAddTwoSpaces) {
            String string2 = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.text");
            string = string2.substring(0, delimiterIndex - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            n = StringsKt.lastIndexOf$default((CharSequence)string, (char)' ', (int)0, (boolean)false, (int)6, null);
        } else {
            n = correcterDelimiter = delimiterIndex;
        }
        if (correcterDelimiter == -1) {
            return LongLineFixableCases.None.INSTANCE;
        }
        return new LongLineFixableCases.StringTemplate(node, correcterDelimiter, multiLineOffset == 0);
    }

    private final LongLineFixableCases checkFun(ASTNode wrongNode) {
        return AstNodeUtilsKt.hasChildOfType(wrongNode, ElementType.INSTANCE.getEQ()) ? (LongLineFixableCases)new LongLineFixableCases.Fun(wrongNode) : (LongLineFixableCases)LongLineFixableCases.None.INSTANCE;
    }

    private final LongLineFixableCases checkComment(ASTNode wrongNode, LineLengthConfiguration configuration2) {
        boolean isNewLine;
        boolean bl;
        String stringBeforeCommentContent;
        int leftOffset;
        block8: {
            String string;
            Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
            if (function1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
                function1 = null;
            }
            leftOffset = ((Number)((Pair)function1.invoke((Object)wrongNode.getStartOffset())).getSecond()).intValue();
            String string2 = wrongNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"wrongNode.text");
            String $this$takeWhile$iv = string2;
            boolean $i$f$takeWhile = false;
            int n = 0;
            int n2 = $this$takeWhile$iv.length();
            while (n < n2) {
                int index$iv = n++;
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl2 = false;
                if (it == ' ' || it == '/') continue;
                String string3 = $this$takeWhile$iv;
                int n3 = 0;
                String string4 = string3.substring(n3, index$iv);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string4;
                break block8;
            }
            string = stringBeforeCommentContent = $this$takeWhile$iv;
        }
        if (stringBeforeCommentContent.length() >= (int)configuration2.getLineLength() - leftOffset) {
            return LongLineFixableCases.None.INSTANCE;
        }
        String $i$f$takeWhile = wrongNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$takeWhile, (String)"wrongNode.text");
        String string = $i$f$takeWhile.substring(stringBeforeCommentContent.length(), (int)configuration2.getLineLength() - leftOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        int indexLastSpace = StringsKt.lastIndexOf$default((CharSequence)string, (char)' ', (int)0, (boolean)false, (int)6, null);
        ASTNode aSTNode = wrongNode.getTreePrev();
        Boolean bl3 = aSTNode == null ? null : Boolean.valueOf(PackageKt.isWhiteSpaceWithNewline((ASTNode)aSTNode));
        if (bl3 == null) {
            ASTNode aSTNode2 = wrongNode.getTreeParent();
            if (aSTNode2 == null) {
                bl = false;
            } else {
                boolean bl4;
                ASTNode aSTNode3 = aSTNode2.getTreePrev();
                bl = aSTNode3 == null ? false : (bl4 = PackageKt.isWhiteSpaceWithNewline((ASTNode)aSTNode3));
            }
        } else {
            bl = isNewLine = bl3.booleanValue();
        }
        if (isNewLine && indexLastSpace == -1) {
            return LongLineFixableCases.None.INSTANCE;
        }
        return new LongLineFixableCases.Comment(wrongNode, isNewLine, indexLastSpace + stringBeforeCommentContent.length());
    }

    private final LongLineFixableCases checkCondition(ASTNode wrongNode, LineLengthConfiguration configuration2) {
        Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
            function1 = null;
        }
        int leftOffset = ((Number)((Pair)function1.invoke((Object)wrongNode.getFirstChildNode().getStartOffset())).getSecond()).intValue();
        List binList = new ArrayList();
        this.searchBinaryExpression(wrongNode, binList);
        if (binList.size() == 1) {
            return LongLineFixableCases.None.INSTANCE;
        }
        return new LongLineFixableCases.Condition(configuration2.getLineLength(), leftOffset, binList);
    }

    private final LongLineFixableCases checkProperty(ASTNode wrongNode, LineLengthConfiguration configuration2) {
        ASTNode newParent = wrongNode;
        while (AstNodeUtilsKt.hasChildOfType(newParent, ElementType.INSTANCE.getPARENTHESIZED())) {
            ASTNode aSTNode;
            Intrinsics.checkNotNull((Object)wrongNode.findChildByType(ElementType.INSTANCE.getPARENTHESIZED()));
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"wrongNode.findChildByType(PARENTHESIZED)!!");
            newParent = aSTNode;
        }
        if (!AstNodeUtilsKt.hasChildOfType(newParent, ElementType.INSTANCE.getSTRING_TEMPLATE())) {
            if (AstNodeUtilsKt.hasChildOfType(newParent, ElementType.INSTANCE.getBINARY_EXPRESSION())) {
                Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
                    function1 = null;
                }
                ASTNode aSTNode = newParent.findChildByType(ElementType.INSTANCE.getBINARY_EXPRESSION());
                Intrinsics.checkNotNull((Object)aSTNode);
                int leftOffset = ((Number)((Pair)function1.invoke((Object)aSTNode.getStartOffset())).getSecond()).intValue();
                List binList = new ArrayList();
                this.dfsForProperty(wrongNode, binList);
                if (binList.size() == 1) {
                    return LongLineFixableCases.None.INSTANCE;
                }
                return new LongLineFixableCases.Condition(configuration2.getLineLength(), leftOffset, binList);
            }
            return LongLineFixableCases.None.INSTANCE;
        }
        Function1<? super Integer, Pair<Integer, Integer>> function1 = this.positionByOffset;
        if (function1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"positionByOffset");
            function1 = null;
        }
        ASTNode aSTNode = newParent.findChildByType(ElementType.INSTANCE.getSTRING_TEMPLATE());
        Intrinsics.checkNotNull((Object)aSTNode);
        int leftOffset = ((Number)((Pair)function1.invoke((Object)aSTNode.getStartOffset())).getSecond()).intValue();
        if ((long)leftOffset > configuration2.getLineLength() - (long)4) {
            return LongLineFixableCases.None.INSTANCE;
        }
        ASTNode aSTNode2 = wrongNode.findChildByType(ElementType.INSTANCE.getSTRING_TEMPLATE());
        Intrinsics.checkNotNull((Object)aSTNode2);
        Object object = aSTNode2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wrongNode.findChildByType(STRING_TEMPLATE)!!.text");
        String string = object;
        object = new char[1];
        object[0] = 34;
        String text = StringsKt.trim((String)string, (char[])object);
        int lastCharIndex = (int)configuration2.getLineLength() - leftOffset - 4;
        String string2 = text;
        int n = 0;
        String string3 = string2.substring(n, lastCharIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        int indexLastSpace = StringsKt.lastIndexOf$default((CharSequence)string3, (char)' ', (int)0, (boolean)false, (int)6, null);
        if (indexLastSpace == -1) {
            return LongLineFixableCases.None.INSTANCE;
        }
        return new LongLineFixableCases.Property(wrongNode, indexLastSpace, text);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isKdocValid(ASTNode node) {
        boolean bl;
        try {
            CharSequence charSequence;
            if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getKDOC_TEXT())) {
                Object element$iv;
                block6: {
                    charSequence = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"node.text");
                    charSequence = charSequence;
                    Regex regex = new Regex("\\s");
                    int n = 0;
                    List $this$last$iv = regex.split(charSequence, n);
                    boolean $i$f$last = false;
                    ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        element$iv = iterator$iv.previous();
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        boolean bl3 = ((CharSequence)it).length() > 0;
                        if (!bl3) continue;
                        break block6;
                    }
                    throw new NoSuchElementException("List contains no element matching the predicate.");
                }
                String string = (String)element$iv;
                new URL(string);
            } else {
                int n;
                String string;
                block7: {
                    void $this$indexOfFirst$iv;
                    charSequence = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"node.text");
                    CharSequence $i$f$last = node.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$last, (String)"node.text");
                    $i$f$last = $i$f$last;
                    string = charSequence;
                    boolean $i$f$indexOfFirst = false;
                    int n2 = 0;
                    int n3 = $this$indexOfFirst$iv.length();
                    while (n2 < n3) {
                        int index$iv = n2++;
                        char it = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl4 = false;
                        if (!(it == ']')) continue;
                        n = index$iv;
                        break block7;
                    }
                    n = -1;
                }
                int n4 = n;
                String string2 = string.substring(n4 + 2, node.getTextLength() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string3 = string2;
                new URL(string3);
            }
            bl = true;
        }
        catch (MalformedURLException e) {
            bl = false;
        }
        return bl;
    }

    private final void fixError(LongLineFixableCases fixableType) {
        LongLineFixableCases longLineFixableCases = fixableType;
        if (longLineFixableCases instanceof LongLineFixableCases.Fun) {
            ASTNode aSTNode = ((LongLineFixableCases.Fun)fixableType).getNode();
            ASTNode aSTNode2 = ((LongLineFixableCases.Fun)fixableType).getNode().findChildByType(ElementType.INSTANCE.getEQ());
            Intrinsics.checkNotNull((Object)aSTNode2);
            AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode, null, aSTNode2.getTreeNext());
        } else if (longLineFixableCases instanceof LongLineFixableCases.Comment) {
            this.fixComment((LongLineFixableCases.Comment)fixableType);
        } else if (longLineFixableCases instanceof LongLineFixableCases.Condition) {
            this.fixLongBinaryExpression((LongLineFixableCases.Condition)fixableType);
        } else if (longLineFixableCases instanceof LongLineFixableCases.Property) {
            this.createSplitProperty((LongLineFixableCases.Property)fixableType);
        } else if (longLineFixableCases instanceof LongLineFixableCases.StringTemplate) {
            this.fixStringTemplate((LongLineFixableCases.StringTemplate)fixableType);
        } else if (longLineFixableCases instanceof LongLineFixableCases.BinaryExpression) {
            this.fixBinaryExpression(((LongLineFixableCases.BinaryExpression)fixableType).getNode());
        } else if (longLineFixableCases instanceof LongLineFixableCases.None) {
            return;
        }
    }

    private final void fixComment(LongLineFixableCases.Comment wrongComment) {
        ASTNode wrongNode = wrongComment.getNode();
        if (wrongComment.getHasNewLineBefore()) {
            int indexLastSpace = wrongComment.getIndexLastSpace();
            String string = wrongNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrongNode.text");
            int n = wrongNode.getText().length();
            String string2 = string.substring(indexLastSpace, n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String nodeText = Intrinsics.stringPlus((String)"//", (Object)string2);
            String $this$fixComment_u24lambda_u2d13 = string = wrongNode.getTreeParent();
            boolean bl = false;
            IElementType iElementType = ElementType.INSTANCE.getEOL_COMMENT();
            String string3 = wrongNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"wrongNode.text");
            int n2 = 0;
            String string4 = string3.substring(n2, indexLastSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            $this$fixComment_u24lambda_u2d13.addChild((ASTNode)new LeafPsiElement(iElementType, (CharSequence)string4), wrongNode);
            $this$fixComment_u24lambda_u2d13.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), wrongNode);
            $this$fixComment_u24lambda_u2d13.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getEOL_COMMENT(), (CharSequence)nodeText), wrongNode);
            $this$fixComment_u24lambda_u2d13.removeChild(wrongNode);
        } else {
            List<ASTNode> list;
            ASTNode newLineNodeOnPreviousLine2;
            if (PackageKt.isWhiteSpace((ASTNode)wrongNode.getTreePrev())) {
                wrongNode.getTreeParent().removeChild(wrongNode.getTreePrev());
            }
            ASTNode aSTNode = newLineNodeOnPreviousLine2 = (list = AstNodeUtilsKt.findAllNodesWithConditionOnLine(wrongNode, AstNodeUtilsKt.getLineNumber(wrongNode) - 1, (Function1<? super ASTNode, Boolean>)((Function1)fixComment.newLineNodeOnPreviousLine.1.INSTANCE))) == null ? null : (ASTNode)CollectionsKt.lastOrNull(list);
            if (aSTNode != null) {
                ASTNode it = aSTNode;
                boolean bl = false;
                ASTNode parent = wrongNode.getTreeParent();
                parent.removeChild(wrongNode);
                newLineNodeOnPreviousLine2.getTreeParent().addChild(wrongNode, newLineNodeOnPreviousLine2.getTreeNext());
                newLineNodeOnPreviousLine2.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), newLineNodeOnPreviousLine2.getTreeNext().getTreeNext());
            }
        }
    }

    private final void fixBinaryExpression(ASTNode node) {
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getOPERATION_REFERENCE());
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode whiteSpaceAfterPlus = aSTNode.getTreeNext();
        node.replaceChild(whiteSpaceAfterPlus, (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"));
    }

    private final void fixStringTemplate(LongLineFixableCases.StringTemplate wrongStringTemplate) {
        String string = wrongStringTemplate.getNode().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wrongStringTemplate.node.text");
        String incorrectText = string;
        String string2 = incorrectText.substring(0, wrongStringTemplate.getDelimiterIndex());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String firstPart = string2;
        String string3 = incorrectText.substring(wrongStringTemplate.getDelimiterIndex(), incorrectText.length());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String secondPart = string3;
        String textBetwenParts = wrongStringTemplate.isOneLineString() ? "\" +\n\"" : "\n";
        ASTNode correctNode = KotlinParser.createNode$default(new KotlinParser(), firstPart + textBetwenParts + secondPart, false, 2, null);
        wrongStringTemplate.getNode().getTreeParent().replaceChild(wrongStringTemplate.getNode(), correctNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void fixLongBinaryExpression(LongLineFixableCases.Condition wrongBinaryExpression) {
        int leftOffset = wrongBinaryExpression.getLeftOffset();
        List<ASTNode> binList = wrongBinaryExpression.getBinList();
        String binaryText = null;
        binaryText = "";
        Iterable $this$forEachIndexed$iv = binList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void astNode;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ASTNode aSTNode = (ASTNode)item$iv;
            int index = n;
            boolean bl = false;
            if ((long)(leftOffset + (binaryText = Intrinsics.stringPlus((String)binaryText, (Object)this.findAllText((ASTNode)astNode))).length()) <= wrongBinaryExpression.getMaximumLineLength() || index == 0) continue;
            ASTNode aSTNode2 = PackageKt.parent$default((ASTNode)astNode, (Function1)((Function1)new Function1<ASTNode, Boolean>(binList, index){
                final /* synthetic */ List<ASTNode> $binList;
                final /* synthetic */ int $index;
                {
                    this.$binList = $binList;
                    this.$index = $index;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) && SequencesKt.contains((Sequence)PsiUtilsKt.parents((ASTNode)this.$binList.get(this.$index - 1)), (Object)it);
                }
            }), (boolean)false, (int)2, null);
            Intrinsics.checkNotNull((Object)aSTNode2);
            ASTNode commonParent2 = aSTNode2;
            ASTNode aSTNode3 = commonParent2.findChildByType(ElementType.INSTANCE.getOPERATION_REFERENCE());
            Intrinsics.checkNotNull((Object)aSTNode3);
            ASTNode nextNode2 = aSTNode3.getTreeNext();
            String string = nextNode2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextNode.text");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                AstNodeUtilsKt.appendNewlineMergingWhiteSpace(commonParent2, nextNode2, nextNode2);
            }
            return;
        }
    }

    private final String findAllText(ASTNode astNode) {
        ASTNode aSTNode;
        ASTNode node;
        String text;
        block9: {
            ASTNode aSTNode2;
            text = "";
            node = astNode;
            ASTNode prevNode = null;
            do {
                prevNode = node;
                aSTNode2 = node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
                node = aSTNode2;
                if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPARENTHESIZED())) continue;
                text = Intrinsics.stringPlus((String)text, (Object)this.getTextFromParenthesized(node));
            } while (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()));
            if (Intrinsics.areEqual((Object)node.getFirstChildNode(), (Object)prevNode)) {
                if (node.getTreePrev() != null && Intrinsics.areEqual((Object)node.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                    text = Intrinsics.stringPlus((String)text, (Object)node.getTreePrev().getText());
                }
            } else if (prevNode.getTreePrev() != null && Intrinsics.areEqual((Object)prevNode.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                text = Intrinsics.stringPlus((String)text, (Object)prevNode.getTreePrev().getText());
            }
            while (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getPARENTHESIZED())) {
                aSTNode2 = node.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.treeParent");
                node = aSTNode2;
                text = Intrinsics.stringPlus((String)text, (Object)this.getBraceAndBeforeText(node, prevNode));
            }
            text = Intrinsics.stringPlus((String)text, (Object)astNode.getText());
            aSTNode2 = PackageKt.parent((ASTNode)astNode, (Function1)findAllText.1.INSTANCE, (boolean)false);
            if (aSTNode2 == null) {
                return text;
            }
            ASTNode $this$nextSibling$iv = node = aSTNode2;
            boolean $i$f$nextSibling = false;
            for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                ASTNode it = n$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) continue;
                aSTNode = n$iv;
                break block9;
            }
            aSTNode = null;
        }
        Intrinsics.checkNotNull(aSTNode);
        node = aSTNode;
        if (Intrinsics.areEqual((Object)node.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            text = Intrinsics.stringPlus((String)text, (Object)node.getTreePrev().getText());
        }
        text = Intrinsics.stringPlus((String)text, (Object)node.getText());
        return text;
    }

    private final String getBraceAndBeforeText(ASTNode node, ASTNode prevNode) {
        IElementType iElementType;
        ASTNode aSTNode;
        block6: {
            ASTNode $this$prevSibling$iv = prevNode;
            boolean $i$f$prevSibling = false;
            for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                ASTNode it = n$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) continue;
                aSTNode = n$iv;
                break block6;
            }
            aSTNode = null;
        }
        if (aSTNode == null) {
            iElementType = null;
        } else {
            ASTNode it = aSTNode;
            boolean bl = false;
            iElementType = ElementType.INSTANCE.getLPAR();
        }
        IElementType iElementType2 = iElementType;
        if (iElementType == null) {
            iElementType2 = ElementType.INSTANCE.getRPAR();
        }
        IElementType par = iElementType2;
        String text = "";
        ASTNode aSTNode2 = node.findChildByType(par);
        Intrinsics.checkNotNull((Object)aSTNode2);
        if (aSTNode2.getTreePrev() != null) {
            ASTNode aSTNode3 = node.findChildByType(par);
            Intrinsics.checkNotNull((Object)aSTNode3);
            if (Intrinsics.areEqual((Object)aSTNode3.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                ASTNode aSTNode4 = node.findChildByType(par);
                Intrinsics.checkNotNull((Object)aSTNode4);
                text = Intrinsics.stringPlus((String)text, (Object)aSTNode4.getTreePrev().getText());
            }
        }
        ASTNode aSTNode5 = node.findChildByType(par);
        Intrinsics.checkNotNull((Object)aSTNode5);
        text = Intrinsics.stringPlus((String)text, (Object)aSTNode5.getText());
        return text;
    }

    private final String getTextFromParenthesized(ASTNode node) {
        String text = "";
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getLPAR());
        Intrinsics.checkNotNull((Object)aSTNode);
        text = Intrinsics.stringPlus((String)text, (Object)aSTNode.getText());
        ASTNode aSTNode2 = node.findChildByType(ElementType.INSTANCE.getLPAR());
        Intrinsics.checkNotNull((Object)aSTNode2);
        if (Intrinsics.areEqual((Object)aSTNode2.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            ASTNode aSTNode3 = node.findChildByType(ElementType.INSTANCE.getLPAR());
            Intrinsics.checkNotNull((Object)aSTNode3);
            text = Intrinsics.stringPlus((String)text, (Object)aSTNode3.getTreeNext().getText());
        }
        ASTNode aSTNode4 = node.findChildByType(ElementType.INSTANCE.getRPAR());
        Intrinsics.checkNotNull((Object)aSTNode4);
        if (Intrinsics.areEqual((Object)aSTNode4.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            ASTNode aSTNode5 = node.findChildByType(ElementType.INSTANCE.getRPAR());
            Intrinsics.checkNotNull((Object)aSTNode5);
            text = Intrinsics.stringPlus((String)text, (Object)aSTNode5.getTreePrev().getText());
        }
        ASTNode aSTNode6 = node.findChildByType(ElementType.INSTANCE.getRPAR());
        Intrinsics.checkNotNull((Object)aSTNode6);
        text = Intrinsics.stringPlus((String)text, (Object)aSTNode6.getText());
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final void searchBinaryExpression(ASTNode node, List<ASTNode> binList) {
        if (AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getBINARY_EXPRESSION()) || AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getPARENTHESIZED()) || AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getPOSTFIX_EXPRESSION())) {
            void $this$filterTo$iv$iv;
            ASTNode[] aSTNodeArray = node.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
            Object[] $this$filter$iv = aSTNodeArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            void var8_9 = $this$filterTo$iv$iv;
            int n = 0;
            int n2 = ((void)var8_9).length;
            while (n < n2) {
                void element$iv$iv = var8_9[n];
                ++n;
                ASTNode it = (ASTNode)element$iv$iv;
                boolean bl = false;
                boolean bl2 = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getPARENTHESIZED()) || Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getPOSTFIX_EXPRESSION());
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.searchBinaryExpression(it, binList);
            }
        } else {
            binList.add(node);
            ASTNode aSTNode = node.getTreeParent().findChildByType(ElementType.INSTANCE.getPREFIX_EXPRESSION());
            if (aSTNode == null) {
                return;
            }
            binList.add(aSTNode);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void dfsForProperty(ASTNode node, List<ASTNode> binList) {
        var3_3 = node.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"node.getChildren(null)");
        $this$forEach$iv = var3_3;
        $i$f$forEach = false;
        var5_5 = $this$forEach$iv;
        var6_6 = 0;
        var7_7 = var5_5.length;
        while (var6_6 < var7_7) {
            block3: {
                element$iv = var5_5[var6_6];
                ++var6_6;
                it = (ASTNode)element$iv;
                $i$a$-forEach-LineLength$dfsForProperty$1 = false;
                if (!LineLength.propertyList.contains(it.getElementType())) break block3;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getREFERENCE_EXPRESSION())) ** GOTO lbl-1000
                v0 = it.getTreeParent();
                if (Intrinsics.areEqual((Object)(v0 == null ? null : v0.getElementType()), (Object)ElementType.INSTANCE.getCALL_EXPRESSION())) {
                    var11_11 = it.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)var11_11, (String)"it.treeParent");
                    binList.add(var11_11);
                } else lbl-1000:
                // 2 sources

                {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    binList.add(it);
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.dfsForProperty(it, binList);
        }
    }

    private final void createSplitProperty(LongLineFixableCases.Property wrongProperty) {
        ASTNode node = wrongProperty.getNode();
        int indexLastSpace = wrongProperty.getIndexLastSpace();
        String text = wrongProperty.getText();
        this.splitTextAndCreateNode(node, text, indexLastSpace);
    }

    private final void splitTextAndCreateNode(ASTNode node, String text, int index) {
        StringBuilder stringBuilder = new StringBuilder().append('\"');
        String string = text;
        int n = 0;
        String string2 = string.substring(n, index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("\" +\n\"");
        String string3 = text.substring(index);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        String resultText = stringBuilder2.append(string3).append('\"').toString();
        ASTNode newNode = KotlinParser.createNode$default(new KotlinParser(), resultText, false, 2, null);
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getSTRING_TEMPLATE());
        Intrinsics.checkNotNull((Object)aSTNode);
        node.removeChild(aSTNode);
        CompositeElement prevExp = new CompositeElement(ElementType.INSTANCE.getBINARY_EXPRESSION());
        node.addChild((ASTNode)prevExp, null);
        prevExp.addChild(newNode, null);
    }

    public static final /* synthetic */ void access$fixError(LineLength $this, LongLineFixableCases fixableType) {
        $this.fixError(fixableType);
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getINTEGER_CONSTANT(), ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY(), ElementType.INSTANCE.getFLOAT_CONSTANT(), ElementType.INSTANCE.getCHARACTER_CONSTANT(), ElementType.INSTANCE.getREFERENCE_EXPRESSION(), ElementType.INSTANCE.getBOOLEAN_CONSTANT(), ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY(), ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY(), ElementType.INSTANCE.getNULL()};
        propertyList = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LineLengthConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "lineLength", "", "getLineLength", "()J", "diktat-rules"})
    public static final class LineLengthConfiguration
    extends RuleConfiguration {
        private final long lineLength;

        public LineLengthConfiguration(@NotNull Map<String, String> config2) {
            long l;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("lineLength");
            if (string == null) {
                l = 120L;
            } else {
                Long l2 = StringsKt.toLongOrNull((String)string);
                l = l2 == null ? 120L : l2;
            }
            this.lineLength = l;
        }

        public final long getLineLength() {
            return this.lineLength;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\u0003\u0004\u0005\u0006\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0007\n\u000b\f\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "", "()V", "BinaryExpression", "Comment", "Condition", "Fun", "None", "Property", "StringTemplate", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$None;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Comment;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$StringTemplate;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$BinaryExpression;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Condition;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Fun;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Property;", "diktat-rules"})
    public static abstract class LongLineFixableCases {
        private LongLineFixableCases() {
        }

        public /* synthetic */ LongLineFixableCases(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$None;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "()V", "diktat-rules"})
        public static final class None
        extends LongLineFixableCases {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Comment;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "hasNewLineBefore", "", "indexLastSpace", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;ZI)V", "getHasNewLineBefore", "()Z", "getIndexLastSpace", "()I", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "diktat-rules"})
        public static final class Comment
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;
            private final boolean hasNewLineBefore;
            private final int indexLastSpace;

            public Comment(@NotNull ASTNode node, boolean hasNewLineBefore, int indexLastSpace) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super(null);
                this.node = node;
                this.hasNewLineBefore = hasNewLineBefore;
                this.indexLastSpace = indexLastSpace;
            }

            public /* synthetic */ Comment(ASTNode aSTNode, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 4) != 0) {
                    n = 0;
                }
                this(aSTNode, bl, n);
            }

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }

            public final boolean getHasNewLineBefore() {
                return this.hasNewLineBefore;
            }

            public final int getIndexLastSpace() {
                return this.indexLastSpace;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$StringTemplate;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "delimiterIndex", "", "isOneLineString", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;IZ)V", "getDelimiterIndex", "()I", "()Z", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "diktat-rules"})
        public static final class StringTemplate
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;
            private final int delimiterIndex;
            private final boolean isOneLineString;

            public StringTemplate(@NotNull ASTNode node, int delimiterIndex, boolean isOneLineString) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super(null);
                this.node = node;
                this.delimiterIndex = delimiterIndex;
                this.isOneLineString = isOneLineString;
            }

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }

            public final int getDelimiterIndex() {
                return this.delimiterIndex;
            }

            public final boolean isOneLineString() {
                return this.isOneLineString;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$BinaryExpression;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)V", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "diktat-rules"})
        public static final class BinaryExpression
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;

            public BinaryExpression(@NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super(null);
                this.node = node;
            }

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Condition;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "maximumLineLength", "", "leftOffset", "", "binList", "", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "(JILjava/util/List;)V", "getBinList", "()Ljava/util/List;", "getLeftOffset", "()I", "getMaximumLineLength", "()J", "diktat-rules"})
        public static final class Condition
        extends LongLineFixableCases {
            private final long maximumLineLength;
            private final int leftOffset;
            @NotNull
            private final List<ASTNode> binList;

            public Condition(long maximumLineLength, int leftOffset, @NotNull List<ASTNode> binList) {
                Intrinsics.checkNotNullParameter(binList, (String)"binList");
                super(null);
                this.maximumLineLength = maximumLineLength;
                this.leftOffset = leftOffset;
                this.binList = binList;
            }

            public final long getMaximumLineLength() {
                return this.maximumLineLength;
            }

            public final int getLeftOffset() {
                return this.leftOffset;
            }

            @NotNull
            public final List<ASTNode> getBinList() {
                return this.binList;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Fun;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)V", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "diktat-rules"})
        public static final class Fun
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;

            public Fun(@NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                super(null);
                this.node = node;
            }

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases$Property;", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$LongLineFixableCases;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "indexLastSpace", "", "text", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;ILjava/lang/String;)V", "getIndexLastSpace", "()I", "getNode", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getText", "()Ljava/lang/String;", "diktat-rules"})
        public static final class Property
        extends LongLineFixableCases {
            @NotNull
            private final ASTNode node;
            private final int indexLastSpace;
            @NotNull
            private final String text;

            public Property(@NotNull ASTNode node, int indexLastSpace, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                super(null);
                this.node = node;
                this.indexLastSpace = indexLastSpace;
                this.text = text;
            }

            @NotNull
            public final ASTNode getNode() {
                return this.node;
            }

            public final int getIndexLastSpace() {
                return this.indexLastSpace;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LineLength$Companion;", "", "()V", "MAX_LENGTH", "", "NAME_ID", "", "STRING_PART_OFFSET", "", "propertyList", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

