/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter3.LongNumericalValuesSeparatedRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LongNumericalValuesSeparatedRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkBlocks", "", "text", "", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter3/LongNumericalValuesSeparatedRule$LongNumericalValuesConfiguration;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "fixFloatConstantPart", "realPart", "fractionalPart", "fixIntegerConstant", "maxBlockLength", "", "isValidConstant", "", "logic", "nodePrefix", "nodeText", "nodeSuffix", "removePrefixSuffix", "Companion", "LongNumericalValuesConfiguration", "diktat-rules"})
public final class LongNumericalValuesSeparatedRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int DELIMITER_LENGTH = 3;
    private static final int MAX_NUMBER_LENGTH = 3;
    @NotNull
    public static final String NAME_ID = "abm-long-numerical-values";

    public LongNumericalValuesSeparatedRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.LONG_NUMERICAL_VALUES_SEPARATED)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.LONG_NUMERICAL_VALUES_SEPARATED);
        Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        LongNumericalValuesConfiguration configuration2 = new LongNumericalValuesConfiguration(map);
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getINTEGER_LITERAL())) {
            string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            if (!this.isValidConstant(string, configuration2, node)) {
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl = this.isFixMode();
                string = node.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
                Warnings.warnAndFix$default(Warnings.LONG_NUMERICAL_VALUES_SEPARATED, list, function3, bl, string, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node, configuration2){
                    final /* synthetic */ LongNumericalValuesSeparatedRule this$0;
                    final /* synthetic */ ASTNode $node;
                    final /* synthetic */ LongNumericalValuesConfiguration $configuration;
                    {
                        this.this$0 = $receiver;
                        this.$node = $node;
                        this.$configuration = $configuration;
                        super(0);
                    }

                    public final void invoke() {
                        LongNumericalValuesSeparatedRule.access$fixIntegerConstant(this.this$0, this.$node, this.$configuration.getMaxBlockLength());
                    }
                }, 64, null);
            }
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFLOAT_LITERAL())) {
            string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            if (!this.isValidConstant(string, configuration2, node)) {
                Object object = node.getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
                CharSequence charSequence = (CharSequence)object;
                object = new String[]{"."};
                List parts = StringsKt.split$default((CharSequence)charSequence, (String[])object, (boolean)false, (int)0, (int)6, null);
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl = this.isFixMode();
                object = node.getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
                Warnings.warnAndFix$default(Warnings.LONG_NUMERICAL_VALUES_SEPARATED, list, function3, bl, (String)object, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, (List<String>)parts, configuration2, node){
                    final /* synthetic */ LongNumericalValuesSeparatedRule this$0;
                    final /* synthetic */ List<String> $parts;
                    final /* synthetic */ LongNumericalValuesConfiguration $configuration;
                    final /* synthetic */ ASTNode $node;
                    {
                        this.this$0 = $receiver;
                        this.$parts = $parts;
                        this.$configuration = $configuration;
                        this.$node = $node;
                        super(0);
                    }

                    public final void invoke() {
                        LongNumericalValuesSeparatedRule.access$fixFloatConstantPart(this.this$0, this.$parts.get(0), this.$parts.get(1), this.$configuration, this.$node);
                    }
                }, 64, null);
            }
        }
    }

    private final void fixIntegerConstant(ASTNode node, int maxBlockLength) {
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        StringBuilder resultRealPart = new StringBuilder(this.nodePrefix(string));
        String string2 = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.text");
        List chunks = CollectionsKt.reversed((Iterable)StringsKt.chunked((CharSequence)((Object)StringsKt.reversed((CharSequence)this.removePrefixSuffix(string2))).toString(), (int)maxBlockLength));
        resultRealPart.append(CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)"_", null, null, (int)0, null, (Function1)fixIntegerConstant.1.INSTANCE, (int)30, null));
        string2 = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.text");
        resultRealPart.append(this.nodeSuffix(string2));
        ((LeafPsiElement)node).rawReplaceWithText(resultRealPart.toString());
    }

    private final void fixFloatConstantPart(String realPart, String fractionalPart, LongNumericalValuesConfiguration configuration2, ASTNode node) {
        StringBuilder resultRealPart = new StringBuilder(this.nodePrefix(realPart));
        StringBuilder resultFractionalPart = new StringBuilder();
        String realNumber = this.removePrefixSuffix(realPart);
        if (realNumber.length() > configuration2.getMaxLength()) {
            List chunks = CollectionsKt.reversed((Iterable)StringsKt.chunked((CharSequence)((Object)StringsKt.reversed((CharSequence)realNumber)).toString(), (int)configuration2.getMaxBlockLength()));
            resultRealPart.append(CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)"_", null, null, (int)0, null, (Function1)fixFloatConstantPart.1.INSTANCE, (int)30, null));
            resultRealPart.append(this.nodeSuffix(realPart)).append(".");
        } else {
            resultRealPart.append(realNumber).append(".");
        }
        String fractionalNumber = this.removePrefixSuffix(fractionalPart);
        if (fractionalNumber.length() > configuration2.getMaxLength()) {
            List chunks = StringsKt.chunked((CharSequence)fractionalNumber, (int)configuration2.getMaxBlockLength());
            resultFractionalPart.append(CollectionsKt.joinToString$default((Iterable)chunks, (CharSequence)"_", null, (CharSequence)this.nodeSuffix(fractionalPart), (int)0, null, (Function1)fixFloatConstantPart.2.INSTANCE, (int)26, null));
            resultFractionalPart.append(this.nodeSuffix(fractionalPart));
        } else {
            resultFractionalPart.append(fractionalNumber).append(this.nodeSuffix(fractionalPart));
        }
        ((LeafPsiElement)node).rawReplaceWithText(resultRealPart.append((CharSequence)resultFractionalPart).toString());
    }

    private final String nodePrefix(String nodeText) {
        return StringsKt.startsWith$default((String)nodeText, (String)"0b", (boolean)false, (int)2, null) ? "0b" : (StringsKt.startsWith$default((String)nodeText, (String)"0x", (boolean)false, (int)2, null) ? "0x" : "");
    }

    private final String nodeSuffix(String nodeText) {
        return StringsKt.endsWith$default((String)nodeText, (String)"L", (boolean)false, (int)2, null) ? "L" : (StringsKt.endsWith((String)nodeText, (String)"f", (boolean)true) ? "f" : "");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValidConstant(String text, LongNumericalValuesConfiguration configuration2, ASTNode node) {
        boolean bl;
        block5: {
            void $this$all$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            if (StringsKt.contains$default((CharSequence)text, (CharSequence)"_", (boolean)false, (int)2, null)) {
                this.checkBlocks(this.removePrefixSuffix(text), configuration2, node);
                return true;
            }
            Object object = new String[]{"."};
            object = StringsKt.split$default((CharSequence)text, (String[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.removePrefixSuffix((String)it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (it.length() <= configuration2.getMaxLength()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void checkBlocks(String text, LongNumericalValuesConfiguration configuration2, ASTNode node) {
        String[] stringArray = new String[]{"_", "."};
        List blocks2 = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$forEach$iv = blocks2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (it.length() <= configuration2.getMaxBlockLength()) continue;
            Warnings.LONG_NUMERICAL_VALUES_SEPARATED.warn(this.getConfigRules(), this.getEmitWarn(), false, Intrinsics.stringPlus((String)"this block is too long ", (Object)it), node.getStartOffset(), node);
        }
    }

    private final String removePrefixSuffix(String text) {
        if (StringsKt.startsWith$default((String)text, (String)"0x", (boolean)false, (int)2, null)) {
            return StringsKt.removePrefix((String)text, (CharSequence)"0x");
        }
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)text, (CharSequence)"0b"), (CharSequence)"L"), (CharSequence)"f"), (CharSequence)"F");
    }

    public static final /* synthetic */ void access$fixIntegerConstant(LongNumericalValuesSeparatedRule $this, ASTNode node, int maxBlockLength) {
        $this.fixIntegerConstant(node, maxBlockLength);
    }

    public static final /* synthetic */ void access$fixFloatConstantPart(LongNumericalValuesSeparatedRule $this, String realPart, String fractionalPart, LongNumericalValuesConfiguration configuration2, ASTNode node) {
        $this.fixFloatConstantPart(realPart, fractionalPart, configuration2, node);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LongNumericalValuesSeparatedRule$LongNumericalValuesConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxBlockLength", "", "getMaxBlockLength", "()I", "maxLength", "getMaxLength", "diktat-rules"})
    public static final class LongNumericalValuesConfiguration
    extends RuleConfiguration {
        private final int maxLength;
        private final int maxBlockLength;

        public LongNumericalValuesConfiguration(@NotNull Map<String, String> config2) {
            int n;
            int n2;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("maxNumberLength");
            if (string == null) {
                n2 = 3;
            } else {
                Integer n3 = StringsKt.toIntOrNull((String)string);
                n2 = n3 == null ? 3 : n3;
            }
            this.maxLength = n2;
            String string2 = config2.get("maxBlockLength");
            if (string2 == null) {
                n = 3;
            } else {
                Integer n4 = StringsKt.toIntOrNull((String)string2);
                n = n4 == null ? 3 : n4;
            }
            this.maxBlockLength = n;
        }

        public final int getMaxLength() {
            return this.maxLength;
        }

        public final int getMaxBlockLength() {
            return this.maxBlockLength;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/LongNumericalValuesSeparatedRule$Companion;", "", "()V", "DELIMITER_LENGTH", "", "MAX_NUMBER_LENGTH", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

