/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/MultipleModifiersSequence;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkAnnotation", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkModifierList", "logic", "Companion", "diktat-rules"})
public final class MultipleModifiersSequence
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aar-multiple-modifiers";
    @NotNull
    private static final List<KtModifierKeywordToken> modifierOrder;

    public MultipleModifiersSequence(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.WRONG_MULTIPLE_MODIFIERS_ORDER)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getMODIFIER_LIST())) {
            this.checkModifierList(node);
            this.checkAnnotation(node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkModifierList(ASTNode node) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        ASTNode[] aSTNodeArray = node.getChildren(KtTokens.MODIFIER_KEYWORDS);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node\n            .getChi\u2026Tokens.MODIFIER_KEYWORDS)");
        Iterable $this$map$iv2 = ArraysKt.toList((Object[])aSTNodeArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it, (Object)CollectionsKt.indexOf(modifierOrder, (Object)it.getElementType())));
        }
        List modifierListOfPair = (List)destination$iv$iv;
        Iterable $this$sortedBy$iv = modifierListOfPair;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
            }
        });
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((ASTNode)it.getFirst());
        }
        List sortModifierListOfPair = (List)destination$iv$iv2;
        Iterable $this$forEachIndexed$iv = modifierListOfPair;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $dstr$modifierNode$_u24__u24;
            Object item$iv$iv;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (Pair)item$iv;
            int index = n;
            boolean bl = false;
            ASTNode modifierNode = (ASTNode)$dstr$modifierNode$_u24__u24.component1();
            if (Intrinsics.areEqual((Object)modifierNode, sortModifierListOfPair.get(index))) continue;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl3 = this.isFixMode();
            String string = modifierNode.getText() + " should be on position " + (sortModifierListOfPair.indexOf(modifierNode) + 1) + ", but is on position " + (index + 1);
            int n2 = modifierNode.getStartOffset();
            Intrinsics.checkNotNullExpressionValue((Object)modifierNode, (String)"modifierNode");
            Warnings.warnAndFix$default(Warnings.WRONG_MULTIPLE_MODIFIERS_ORDER, list, function3, bl3, string, n2, modifierNode, false, (Function0)new Function0<Unit>(modifierNode, node, (List<? extends ASTNode>)sortModifierListOfPair, index){
                final /* synthetic */ ASTNode $modifierNode;
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ List<ASTNode> $sortModifierListOfPair;
                final /* synthetic */ int $index;
                {
                    this.$modifierNode = $modifierNode;
                    this.$node = $node;
                    this.$sortModifierListOfPair = $sortModifierListOfPair;
                    this.$index = $index;
                    super(0);
                }

                public final void invoke() {
                    ASTNode nodeAfter = this.$modifierNode.getTreeNext();
                    this.$node.removeChild(this.$modifierNode);
                    this.$node.addChild((ASTNode)this.$sortModifierListOfPair.get(this.$index).clone(), nodeAfter);
                }
            }, 64, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAnnotation(ASTNode node) {
        void $this$filterIndexedTo$iv$iv;
        ASTNode[] aSTNodeArray;
        int n;
        ASTNode[] $this$indexOfFirst$iv;
        block6: {
            Sequence sequence = PsiUtilsKt.children((ASTNode)node);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object e : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ASTNode it = (ASTNode)e;
                boolean bl = false;
                if (KtTokens.MODIFIER_KEYWORDS.contains(it.getElementType())) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = -1;
        }
        $this$indexOfFirst$iv = Integer.valueOf(n);
        int it232 = ((Number)$this$indexOfFirst$iv).intValue();
        boolean bl = false;
        Object object = aSTNodeArray = it232 >= 0 ? $this$indexOfFirst$iv : null;
        if (aSTNodeArray == null) {
            return;
        }
        int firstModifierIndex = aSTNodeArray.intValue();
        aSTNodeArray = node.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node\n            .getChildren(null)");
        Object[] $this$filterIndexed$iv = aSTNodeArray;
        boolean $i$f$filterIndexed = false;
        Object[] it232 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void var8_12 = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (void item$iv$iv$iv : var8_12) {
            void astNode;
            void element$iv$iv;
            int n2 = index$iv$iv$iv;
            index$iv$iv$iv = n2 + 1;
            void var16_24 = item$iv$iv$iv;
            int index$iv$iv = n2;
            boolean bl2 = false;
            ASTNode aSTNode = (ASTNode)element$iv$iv;
            int index = index$iv$iv;
            boolean bl3 = false;
            if (!(Intrinsics.areEqual((Object)astNode.getElementType(), (Object)ElementType.INSTANCE.getANNOTATION_ENTRY()) && index > firstModifierIndex)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode astNode = (ASTNode)element$iv;
            boolean bl2 = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl3 = this.isFixMode();
            String string = Intrinsics.stringPlus((String)astNode.getText(), (Object)" annotation should be before all modifiers");
            int n3 = astNode.getStartOffset();
            Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"astNode");
            Warnings.warnAndFix$default(Warnings.WRONG_MULTIPLE_MODIFIERS_ORDER, list, function3, bl3, string, n3, astNode, false, (Function0)new Function0<Unit>(astNode, node){
                final /* synthetic */ ASTNode $astNode;
                final /* synthetic */ ASTNode $node;
                {
                    this.$astNode = $astNode;
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ASTNode spaceBefore = this.$astNode.getTreePrev();
                    this.$node.removeChild(this.$astNode);
                    if (spaceBefore != null && Intrinsics.areEqual((Object)spaceBefore.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                        this.$node.removeChild(spaceBefore);
                        this.$node.addChild(spaceBefore, this.$node.getFirstChildNode());
                        this.$node.addChild((ASTNode)this.$astNode.clone(), spaceBefore);
                    } else {
                        ASTNode aSTNode = (ASTNode)new PsiWhiteSpaceImpl((CharSequence)" ");
                        ASTNode[] aSTNodeArray = this.$node.getChildren(null);
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
                        this.$node.addChild(aSTNode, (ASTNode)ArraysKt.first((Object[])aSTNodeArray));
                        ASTNode aSTNode2 = (ASTNode)this.$astNode.clone();
                        aSTNodeArray = this.$node.getChildren(null);
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
                        this.$node.addChild(aSTNode2, (ASTNode)ArraysKt.first((Object[])aSTNodeArray));
                    }
                }
            }, 64, null);
        }
    }

    static {
        Object[] objectArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.INTERNAL_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.EXPECT_KEYWORD, KtTokens.ACTUAL_KEYWORD, KtTokens.FINAL_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.ABSTRACT_KEYWORD, KtTokens.SEALED_KEYWORD, KtTokens.CONST_KEYWORD, KtTokens.EXTERNAL_KEYWORD, KtTokens.OVERRIDE_KEYWORD, KtTokens.LATEINIT_KEYWORD, KtTokens.TAILREC_KEYWORD, KtTokens.CROSSINLINE_KEYWORD, KtTokens.VARARG_KEYWORD, KtTokens.SUSPEND_KEYWORD, KtTokens.INNER_KEYWORD, KtTokens.OUT_KEYWORD, KtTokens.ENUM_KEYWORD, KtTokens.ANNOTATION_KEYWORD, KtTokens.COMPANION_KEYWORD, KtTokens.VALUE_KEYWORD, KtTokens.INLINE_KEYWORD, KtTokens.NOINLINE_KEYWORD, KtTokens.REIFIED_KEYWORD, KtTokens.INFIX_KEYWORD, KtTokens.OPERATOR_KEYWORD, KtTokens.DATA_KEYWORD, KtTokens.IN_KEYWORD, KtTokens.HEADER_KEYWORD, KtTokens.IMPL_KEYWORD};
        modifierOrder = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/MultipleModifiersSequence$Companion;", "", "()V", "NAME_ID", "", "modifierOrder", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

