/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/NullableTypeRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkProperty", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "findFixableForCollectionParam", "Lorg/cqfn/diktat/ruleset/rules/chapter3/NullableTypeRule$FixedParam;", "referenceText", "", "findFixableParam", "findSubstitution", "fixedParam", "logic", "replaceValue", "insertConstantType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "insertType", "textNode", "replaceValueByText", "nodeText", "replaceValueForString", "Companion", "FixedParam", "diktat-rules"})
public final class NullableTypeRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "acg-nullable-type";
    @NotNull
    private static final List<String> allowExpression;

    public NullableTypeRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.NULLABLE_PROPERTY_TYPE)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY())) {
            this.checkProperty(node);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkProperty(ASTNode node) {
        block2: {
            block3: {
                if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getVAL_KEYWORD())) return;
                if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getEQ())) return;
                if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getTYPE_REFERENCE())) return;
                ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
                Intrinsics.checkNotNull((Object)aSTNode);
                ASTNode aSTNode2 = aSTNode;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.findChildByType(TYPE_REFERENCE)!!");
                ASTNode typeReferenceNode = aSTNode2;
                if (AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getNULL()) || !AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION(), false, 2, null).isEmpty() || !AstNodeUtilsKt.hasChildOfType(typeReferenceNode, ElementType.INSTANCE.getNULLABLE_TYPE())) break block2;
                ASTNode aSTNode3 = typeReferenceNode.findChildByType(ElementType.INSTANCE.getNULLABLE_TYPE());
                Intrinsics.checkNotNull((Object)aSTNode3);
                aSTNode2 = aSTNode3;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"typeReferenceNode.findChildByType(NULLABLE_TYPE)!!");
                if (!AstNodeUtilsKt.hasChildOfType(aSTNode2, ElementType.INSTANCE.getQUEST())) break block2;
                ASTNode aSTNode4 = node.findChildByType(ElementType.INSTANCE.getCALL_EXPRESSION());
                if ((aSTNode4 == null ? null : aSTNode4.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION())) == null) break block3;
                ASTNode aSTNode5 = node.findChildByType(ElementType.INSTANCE.getCALL_EXPRESSION());
                Intrinsics.checkNotNull((Object)aSTNode5);
                ASTNode aSTNode6 = aSTNode5.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                Intrinsics.checkNotNull((Object)aSTNode6);
                if (!allowExpression.contains(aSTNode6.getText())) break block2;
            }
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
            Intrinsics.checkNotNull((Object)aSTNode);
            Warnings.NULLABLE_PROPERTY_TYPE.warn(list, function3, bl, "don't use nullable type", aSTNode.getStartOffset(), node);
            return;
        }
        if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getNULL())) return;
        FixedParam fixedParam = this.findFixableParam(node);
        List<RulesConfig> list = this.getConfigRules();
        Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
        boolean bl = this.isFixMode();
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode);
        Warnings.NULLABLE_PROPERTY_TYPE.warnAndFix(list, function3, bl, "initialize explicitly", aSTNode.getStartOffset(), node, fixedParam != null, (Function0<Unit>)((Function0)new Function0<Unit>(fixedParam, this, node){
            final /* synthetic */ FixedParam $fixedParam;
            final /* synthetic */ NullableTypeRule this$0;
            final /* synthetic */ ASTNode $node;
            {
                this.$fixedParam = $fixedParam;
                this.this$0 = $receiver;
                this.$node = $node;
                super(0);
            }

            public final void invoke() {
                FixedParam fixedParam = this.$fixedParam;
                if (fixedParam != null) {
                    FixedParam fixedParam2 = fixedParam;
                    NullableTypeRule nullableTypeRule = this.this$0;
                    ASTNode aSTNode = this.$node;
                    FixedParam fixedParam3 = this.$fixedParam;
                    FixedParam it = fixedParam2;
                    boolean bl = false;
                    NullableTypeRule.access$findSubstitution(nullableTypeRule, aSTNode, fixedParam3);
                }
            }
        }));
    }

    private final FixedParam findFixableParam(ASTNode node) {
        FixedParam fixedParam;
        Object object;
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode aSTNode2 = aSTNode.findChildByType(ElementType.INSTANCE.getNULLABLE_TYPE());
        Intrinsics.checkNotNull((Object)aSTNode2);
        ASTNode aSTNode3 = aSTNode2.findChildByType(ElementType.INSTANCE.getUSER_TYPE());
        ASTNode aSTNode4 = object = aSTNode3 == null ? null : aSTNode3.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
        if (object == null) {
            return null;
        }
        ASTNode reference = object;
        switch (reference.getText()) {
            case "Boolean": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getBOOLEAN_CONSTANT(), ElementType.INSTANCE.getTRUE_KEYWORD(), "true", false, 8, null);
                break;
            }
            case "Byte": 
            case "Int": 
            case "Short": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getINTEGER_CONSTANT(), ElementType.INSTANCE.getINTEGER_LITERAL(), "0", false, 8, null);
                break;
            }
            case "Double": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getFLOAT_CONSTANT(), ElementType.INSTANCE.getFLOAT_LITERAL(), "0.0", false, 8, null);
                break;
            }
            case "Float": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getFLOAT_CONSTANT(), ElementType.INSTANCE.getFLOAT_LITERAL(), "0.0F", false, 8, null);
                break;
            }
            case "Long": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getINTEGER_CONSTANT(), ElementType.INSTANCE.getINTEGER_LITERAL(), "0L", false, 8, null);
                break;
            }
            case "Char": {
                fixedParam = new FixedParam(ElementType.INSTANCE.getCHARACTER_CONSTANT(), ElementType.INSTANCE.getCHARACTER_LITERAL(), "''", false, 8, null);
                break;
            }
            case "String": {
                fixedParam = new FixedParam(null, null, "", true);
                break;
            }
            default: {
                object = reference.getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reference.text");
                fixedParam = this.findFixableForCollectionParam((String)object);
            }
        }
        return fixedParam;
    }

    private final FixedParam findFixableForCollectionParam(String referenceText) {
        FixedParam fixedParam;
        switch (referenceText) {
            case "Iterable": 
            case "List": {
                fixedParam = new FixedParam(null, null, "emptyList()", false, 8, null);
                break;
            }
            case "Map": {
                fixedParam = new FixedParam(null, null, "emptyMap()", false, 8, null);
                break;
            }
            case "Array": {
                fixedParam = new FixedParam(null, null, "emptyArray()", false, 8, null);
                break;
            }
            case "Set": {
                fixedParam = new FixedParam(null, null, "emptySet()", false, 8, null);
                break;
            }
            case "Sequence": {
                fixedParam = new FixedParam(null, null, "emptySequence()", false, 8, null);
                break;
            }
            case "Queue": {
                fixedParam = new FixedParam(null, null, "LinkedList()", false, 8, null);
                break;
            }
            case "MutableList": {
                fixedParam = new FixedParam(null, null, "mutableListOf()", false, 8, null);
                break;
            }
            case "MutableMap": {
                fixedParam = new FixedParam(null, null, "mutableMapOf()", false, 8, null);
                break;
            }
            case "MutableSet": {
                fixedParam = new FixedParam(null, null, "mutableSetOf()", false, 8, null);
                break;
            }
            case "LinkedList": {
                fixedParam = new FixedParam(null, null, "LinkedList()", false, 8, null);
                break;
            }
            case "LinkedHashMap": {
                fixedParam = new FixedParam(null, null, "LinkedHashMap()", false, 8, null);
                break;
            }
            case "LinkedHashSet": {
                fixedParam = new FixedParam(null, null, "LinkedHashSet()", false, 8, null);
                break;
            }
            default: {
                fixedParam = null;
            }
        }
        return fixedParam;
    }

    private final void findSubstitution(ASTNode node, FixedParam fixedParam) {
        if (fixedParam.isString()) {
            this.replaceValueForString(node);
        } else if (fixedParam.getInsertConstantType() != null && fixedParam.getInsertType() != null) {
            this.replaceValue(node, fixedParam.getInsertConstantType(), fixedParam.getInsertType(), fixedParam.getTextNode());
        } else {
            this.replaceValueByText(node, fixedParam.getTextNode());
        }
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode aSTNode2 = aSTNode.findChildByType(ElementType.INSTANCE.getNULLABLE_TYPE());
        Intrinsics.checkNotNull((Object)aSTNode2);
        ASTNode aSTNode3 = aSTNode2;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"node.findChildByType(TYP\u2026ldByType(NULLABLE_TYPE)!!");
        ASTNode nullableNode = aSTNode3;
        ASTNode userTypeNode = nullableNode.getFirstChildNode();
        ASTNode aSTNode4 = node.findChildByType(ElementType.INSTANCE.getTYPE_REFERENCE());
        Intrinsics.checkNotNull((Object)aSTNode4);
        aSTNode4.replaceChild(nullableNode, userTypeNode);
    }

    private final void replaceValueByText(ASTNode node, String nodeText) {
        ASTNode newNode = KotlinParser.createNode$default(new KotlinParser(), nodeText, false, 2, null);
        if (Intrinsics.areEqual((Object)newNode.getElementType(), (Object)ElementType.INSTANCE.getCALL_EXPRESSION())) {
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getNULL());
            Intrinsics.checkNotNull((Object)aSTNode);
            node.replaceChild(aSTNode, newNode);
        }
    }

    private final void replaceValue(ASTNode node, IElementType insertConstantType, IElementType insertType, String textNode) {
        CompositeElement value = new CompositeElement(insertConstantType);
        ASTNode aSTNode = (ASTNode)value;
        ASTNode aSTNode2 = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode2);
        node.addChild(aSTNode, aSTNode2);
        ASTNode aSTNode3 = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode3);
        node.removeChild(aSTNode3);
        value.addChild((ASTNode)new LeafPsiElement(insertType, (CharSequence)textNode));
    }

    private final void replaceValueForString(ASTNode node) {
        CompositeElement value = new CompositeElement(ElementType.INSTANCE.getSTRING_TEMPLATE());
        ASTNode aSTNode = (ASTNode)value;
        ASTNode aSTNode2 = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode2);
        node.addChild(aSTNode, aSTNode2);
        ASTNode aSTNode3 = node.findChildByType(ElementType.INSTANCE.getNULL());
        Intrinsics.checkNotNull((Object)aSTNode3);
        node.removeChild(aSTNode3);
        value.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getOPEN_QUOTE(), (CharSequence)""));
        value.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getCLOSING_QUOTE(), (CharSequence)""));
    }

    public static final /* synthetic */ void access$findSubstitution(NullableTypeRule $this, ASTNode node, FixedParam fixedParam) {
        $this.findSubstitution(node, fixedParam);
    }

    static {
        Object[] objectArray = new String[]{"emptyList", "emptySequence", "emptyArray", "emptyMap", "emptySet", "listOf", "mapOf", "arrayOf", "sequenceOf", "setOf"};
        allowExpression = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J5\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/NullableTypeRule$FixedParam;", "", "insertConstantType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "insertType", "textNode", "", "isString", "", "(Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;Ljava/lang/String;Z)V", "getInsertConstantType", "()Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getInsertType", "()Z", "getTextNode", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "diktat-rules"})
    private static final class FixedParam {
        @Nullable
        private final IElementType insertConstantType;
        @Nullable
        private final IElementType insertType;
        @NotNull
        private final String textNode;
        private final boolean isString;

        public FixedParam(@Nullable IElementType insertConstantType, @Nullable IElementType insertType, @NotNull String textNode, boolean isString) {
            Intrinsics.checkNotNullParameter((Object)textNode, (String)"textNode");
            this.insertConstantType = insertConstantType;
            this.insertType = insertType;
            this.textNode = textNode;
            this.isString = isString;
        }

        public /* synthetic */ FixedParam(IElementType iElementType, IElementType iElementType2, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            this(iElementType, iElementType2, string, bl);
        }

        @Nullable
        public final IElementType getInsertConstantType() {
            return this.insertConstantType;
        }

        @Nullable
        public final IElementType getInsertType() {
            return this.insertType;
        }

        @NotNull
        public final String getTextNode() {
            return this.textNode;
        }

        public final boolean isString() {
            return this.isString;
        }

        @Nullable
        public final IElementType component1() {
            return this.insertConstantType;
        }

        @Nullable
        public final IElementType component2() {
            return this.insertType;
        }

        @NotNull
        public final String component3() {
            return this.textNode;
        }

        public final boolean component4() {
            return this.isString;
        }

        @NotNull
        public final FixedParam copy(@Nullable IElementType insertConstantType, @Nullable IElementType insertType, @NotNull String textNode, boolean isString) {
            Intrinsics.checkNotNullParameter((Object)textNode, (String)"textNode");
            return new FixedParam(insertConstantType, insertType, textNode, isString);
        }

        public static /* synthetic */ FixedParam copy$default(FixedParam fixedParam, IElementType iElementType, IElementType iElementType2, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                iElementType = fixedParam.insertConstantType;
            }
            if ((n & 2) != 0) {
                iElementType2 = fixedParam.insertType;
            }
            if ((n & 4) != 0) {
                string = fixedParam.textNode;
            }
            if ((n & 8) != 0) {
                bl = fixedParam.isString;
            }
            return fixedParam.copy(iElementType, iElementType2, string, bl);
        }

        @NotNull
        public String toString() {
            return "FixedParam(insertConstantType=" + this.insertConstantType + ", insertType=" + this.insertType + ", textNode=" + this.textNode + ", isString=" + this.isString + ')';
        }

        public int hashCode() {
            int result = this.insertConstantType == null ? 0 : this.insertConstantType.hashCode();
            result = result * 31 + (this.insertType == null ? 0 : this.insertType.hashCode());
            result = result * 31 + this.textNode.hashCode();
            int n = this.isString ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FixedParam)) {
                return false;
            }
            FixedParam fixedParam = (FixedParam)other;
            if (!Intrinsics.areEqual((Object)this.insertConstantType, (Object)fixedParam.insertConstantType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.insertType, (Object)fixedParam.insertType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.textNode, (Object)fixedParam.textNode)) {
                return false;
            }
            return this.isString == fixedParam.isString;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/NullableTypeRule$Companion;", "", "()V", "NAME_ID", "", "allowExpression", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

