/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter3.RangeConventionalRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/RangeConventionalRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter3/RangeConventionalRule$RangeConventionalConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/chapter3/RangeConventionalRule$RangeConventionalConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "handleQualifiedExpression", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleRange", "logic", "replaceUntil", "Companion", "RangeConventionalConfiguration", "diktat-rules"})
public final class RangeConventionalRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configuration$delegate;
    @NotNull
    public static final String NAME_ID = "abj-range";

    public RangeConventionalRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.CONVENTIONAL_RANGE)), null, 8, null);
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<RangeConventionalConfiguration>(this){
            final /* synthetic */ RangeConventionalRule this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final RangeConventionalConfiguration invoke() {
                RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.this$0.getConfigRules(), (Rule)Warnings.CONVENTIONAL_RANGE);
                Map<K, V> map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return new RangeConventionalConfiguration(map);
            }
        }));
    }

    private final RangeConventionalConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (RangeConventionalConfiguration)((Object)lazy.getValue());
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION()) && !this.getConfiguration().isRangeToIgnore()) {
            this.handleQualifiedExpression(node);
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getRANGE())) {
            this.handleRange(node);
        }
    }

    private final void handleQualifiedExpression(ASTNode node) {
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
        }
        KtExpression ktExpression = ((KtDotQualifiedExpression)psiElement).getSelectorExpression();
        if (ktExpression != null) {
            ASTNode aSTNode = ktExpression.getNode();
            if (aSTNode != null) {
                String string;
                ASTNode it = aSTNode;
                boolean bl = false;
                ASTNode aSTNode2 = it.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                if (aSTNode2 == null) {
                    string = null;
                } else {
                    ASTNode aSTNode3 = AstNodeUtilsKt.getIdentifierName(aSTNode2);
                    string = aSTNode3 == null ? null : aSTNode3.getText();
                }
                if (Intrinsics.areEqual((Object)string, (Object)"rangeTo")) {
                    ASTNode[] arguments;
                    ASTNode[] aSTNodeArray;
                    ASTNode aSTNode4 = it.findChildByType(ElementType.INSTANCE.getVALUE_ARGUMENT_LIST());
                    if (aSTNode4 == null) {
                        aSTNodeArray = null;
                    } else {
                        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getVALUE_ARGUMENT()};
                        aSTNodeArray = aSTNode4.getChildren(TokenSet.create((IElementType[])iElementTypeArray));
                    }
                    if (arguments == null ? false : (arguments = aSTNodeArray).length == 1) {
                        Warnings.warnAndFix$default(Warnings.CONVENTIONAL_RANGE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)"replace `rangeTo` with `..`: ", (Object)node.getText()), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node, arguments){
                            final /* synthetic */ ASTNode $node;
                            final /* synthetic */ ASTNode[] $arguments;
                            {
                                this.$node = $node;
                                this.$arguments = $arguments;
                                super(0);
                            }

                            public final void invoke() {
                                PsiElement psiElement = this.$node.getPsi();
                                if (psiElement == null) {
                                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDotQualifiedExpression");
                                }
                                String receiverExpression = ((KtDotQualifiedExpression)psiElement).getReceiverExpression().getText();
                                ASTNode correctNode = KotlinParser.createNode$default(new KotlinParser(), receiverExpression + ".." + this.$arguments[0].getText(), false, 2, null);
                                this.$node.getTreeParent().addChild(correctNode, this.$node);
                                this.$node.getTreeParent().removeChild(this.$node);
                            }
                        }, 64, null);
                    }
                }
            }
        }
    }

    private final void handleRange(ASTNode node) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        PsiElement psiElement;
        ASTNode aSTNode3 = PackageKt.parent$default((ASTNode)node, (Function1)handleRange.binaryInExpression.1.INSTANCE, (boolean)false, (int)2, null);
        KtBinaryExpression binaryInExpression2 = (KtBinaryExpression)(aSTNode3 == null ? null : aSTNode3.getPsi());
        KtBinaryExpression ktBinaryExpression = binaryInExpression2;
        if (ktBinaryExpression == null) {
            psiElement = null;
        } else {
            KtExpression ktExpression = ktBinaryExpression.getRight();
            if (ktExpression == null) {
                psiElement = null;
            } else {
                ASTNode aSTNode4 = ktExpression.getNode();
                if (aSTNode4 == null) {
                    psiElement = null;
                } else {
                    aSTNode2 = new ASTNode[]{ElementType.INSTANCE.getBINARY_EXPRESSION()};
                    aSTNode = AstNodeUtilsKt.takeByChainOfTypes(aSTNode4, (IElementType[])aSTNode2);
                    psiElement = aSTNode == null ? null : aSTNode.getPsi();
                }
            }
        }
        KtBinaryExpression ktBinaryExpression2 = (KtBinaryExpression)psiElement;
        if (ktBinaryExpression2 != null) {
            KtBinaryExpression it = ktBinaryExpression2;
            boolean bl = false;
            aSTNode = it.getOperationReference().getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.operationReference.node");
            if (AstNodeUtilsKt.hasChildOfType(aSTNode, ElementType.INSTANCE.getMINUS())) {
                KtBinaryExpression ktBinaryExpression3 = binaryInExpression2;
                Intrinsics.checkNotNull((Object)ktBinaryExpression3);
                aSTNode2 = ktBinaryExpression3.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"binaryInExpression!!.node");
                ASTNode errorNode = aSTNode2;
                Warnings.warnAndFix$default(Warnings.CONVENTIONAL_RANGE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)"replace `..` with `until`: ", (Object)errorNode.getText()), errorNode.getStartOffset(), errorNode, false, (Function0)new Function0<Unit>(this, node, it){
                    final /* synthetic */ RangeConventionalRule this$0;
                    final /* synthetic */ ASTNode $node;
                    final /* synthetic */ KtBinaryExpression $it;
                    {
                        this.this$0 = $receiver;
                        this.$node = $node;
                        this.$it = $it;
                        super(0);
                    }

                    public final void invoke() {
                        RangeConventionalRule.access$replaceUntil(this.this$0, this.$node);
                        ASTNode aSTNode = this.$it.getNode();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
                        ASTNode astNode = aSTNode;
                        ASTNode parent = astNode.getTreeParent();
                        parent.addChild(astNode.getFirstChildNode(), astNode);
                        parent.removeChild(astNode);
                    }
                }, 64, null);
            }
        }
    }

    private final void replaceUntil(ASTNode node) {
        LeafPsiElement untilNode = new LeafPsiElement(ElementType.INSTANCE.getIDENTIFIER(), (CharSequence)"until");
        ASTNode parent = node.getTreeParent();
        ASTNode aSTNode = parent.getTreePrev();
        if (!(aSTNode == null ? false : PackageKt.isWhiteSpace((ASTNode)aSTNode))) {
            parent.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), parent);
        }
        ASTNode aSTNode2 = parent.getTreeNext();
        if (!(aSTNode2 == null ? false : PackageKt.isWhiteSpace((ASTNode)aSTNode2))) {
            parent.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), parent.getTreeNext());
        }
        parent.addChild((ASTNode)untilNode, node);
        parent.removeChild(node);
    }

    public static final /* synthetic */ void access$replaceUntil(RangeConventionalRule $this, ASTNode node) {
        $this.replaceUntil(node);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\t"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/RangeConventionalRule$RangeConventionalConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "isRangeToIgnore", "", "()Z", "diktat-rules"})
    public static final class RangeConventionalConfiguration
    extends RuleConfiguration {
        private final boolean isRangeToIgnore;

        public RangeConventionalConfiguration(@NotNull Map<String, String> config2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("isRangeToIgnore");
            this.isRangeToIgnore = string == null ? false : (bl = Boolean.parseBoolean(string));
        }

        public final boolean isRangeToIgnore() {
            return this.isRangeToIgnore;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/RangeConventionalRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

