/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter3.SingleLineStatementsRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/SingleLineStatementsRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkSemicolon", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "logic", "Companion", "diktat-rules"})
public final class SingleLineStatementsRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aaq-statement";
    @NotNull
    private static final TokenSet semicolonToken;

    public SingleLineStatementsRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.MORE_THAN_ONE_STATEMENT_PER_LINE)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.checkSemicolon(node);
    }

    private final void checkSemicolon(ASTNode node) {
        ASTNode[] aSTNodeArray = node.getChildren(semicolonToken);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(semicolonToken)");
        Object[] $this$forEach$iv = aSTNodeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode astNode = (ASTNode)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"astNode");
            if (AstNodeUtilsKt.isFollowedByNewline(astNode)) continue;
            Warnings.warnAndFix$default(Warnings.MORE_THAN_ONE_STATEMENT_PER_LINE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), AstNodeUtilsKt.extractLineOfText(astNode), astNode.getStartOffset(), astNode, false, (Function0)new Function0<Unit>(astNode, node){
                final /* synthetic */ ASTNode $astNode;
                final /* synthetic */ ASTNode $node;
                {
                    this.$astNode = $astNode;
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    if (Intrinsics.areEqual((Object)this.$astNode.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getENUM_ENTRY())) {
                        this.$node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), this.$node.getTreeNext());
                    } else {
                        ASTNode aSTNode = this.$astNode;
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"astNode");
                        if (!AstNodeUtilsKt.isBeginByNewline(aSTNode)) {
                            ASTNode aSTNode2 = this.$astNode;
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"astNode");
                            ASTNode aSTNode3 = PackageKt.parent((ASTNode)aSTNode2, (Function1)checkSemicolon.1.nextNode.1.INSTANCE, (boolean)false);
                            ASTNode nextNode2 = aSTNode3 == null ? null : aSTNode3.getTreeNext();
                            AstNodeUtilsKt.appendNewlineMergingWhiteSpace(this.$node, nextNode2, this.$astNode);
                        }
                        this.$node.removeChild(this.$astNode);
                    }
                }
            }, 64, null);
        }
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getSEMICOLON()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(SEMICOLON)");
        semicolonToken = tokenSet;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/SingleLineStatementsRule$Companion;", "", "()V", "NAME_ID", "", "semicolonToken", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

