/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\f\u0010\u001c\u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010\u001d\u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010\u001e\u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010\u001f\u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010 \u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010!\u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010\"\u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010#\u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010$\u001a\u00020\u0011*\u00020\tH\u0002J\f\u0010%\u001a\u00020\u0011*\u00020\tH\u0002\u00a8\u0006'"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/StringConcatenationRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkKtExpression", "", "binaryExpressionPsi", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "detectStringConcatenation", "", "topLevelBinaryExpr", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "fixBinaryExpressionWithConcatenation", "node", "isDetectStringConcatenationInExpression", "", "isPlusBinaryExpression", "isPlusBinaryExpressionAndFirstElementString", "binaryExpressionNode", "isSingleLineStatement", "isStringVar", "firstChild", "lastChild", "logic", "loop", "parentTopLevelBinaryExpr", "isLvalueBinaryExpression", "isLvalueConstantExpression", "isLvalueDotQualifiedExpression", "isLvalueReferenceExpression", "isRvalueCallExpression", "isRvalueConstantExpression", "isRvalueExpression", "isRvalueParenthesized", "isRvalueReferenceExpression", "isRvalueStringTemplateExpression", "Companion", "diktat-rules"})
public final class StringConcatenationRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "abr-string-concatenation";

    public StringConcatenationRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.STRING_CONCATENATION)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) && AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getBINARY_EXPRESSION()) == null && this.isSingleLineStatement(node)) {
            this.detectStringConcatenation(node);
        }
    }

    private final boolean isSingleLineStatement(ASTNode node) {
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        return !StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null);
    }

    private final void detectStringConcatenation(ASTNode topLevelBinaryExpr) {
        Object v0;
        block2: {
            List allBinaryExpressions = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(topLevelBinaryExpr, ElementType.INSTANCE.getBINARY_EXPRESSION(), false, 2, null);
            for (Object t : (Iterable)allBinaryExpressions) {
                ASTNode it = (ASTNode)t;
                boolean bl = false;
                if (!this.isDetectStringConcatenationInExpression(it)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ASTNode nodeWithBug = v0;
        if (nodeWithBug != null) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            String string = topLevelBinaryExpr.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"topLevelBinaryExpr.text");
            Warnings.warnAndFix$default(Warnings.STRING_CONCATENATION, list, function3, bl, (String)CollectionsKt.first((List)StringsKt.lines((CharSequence)string)), nodeWithBug.getStartOffset(), nodeWithBug, false, (Function0)new Function0<Unit>(this, nodeWithBug, topLevelBinaryExpr){
                final /* synthetic */ StringConcatenationRule this$0;
                final /* synthetic */ ASTNode $nodeWithBug;
                final /* synthetic */ ASTNode $topLevelBinaryExpr;
                {
                    this.this$0 = $receiver;
                    this.$nodeWithBug = $nodeWithBug;
                    this.$topLevelBinaryExpr = $topLevelBinaryExpr;
                    super(0);
                }

                public final void invoke() {
                    StringConcatenationRule.access$fixBinaryExpressionWithConcatenation(this.this$0, this.$nodeWithBug);
                    ASTNode aSTNode = this.$topLevelBinaryExpr.getTreeParent();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"topLevelBinaryExpr.treeParent");
                    StringConcatenationRule.access$loop(this.this$0, aSTNode);
                }
            }, 64, null);
        }
    }

    private final void loop(ASTNode parentTopLevelBinaryExpr) {
        boolean bugDetected;
        Object v0;
        block2: {
            List allBinaryExpressions = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(parentTopLevelBinaryExpr, ElementType.INSTANCE.getBINARY_EXPRESSION(), false, 2, null);
            for (Object t : (Iterable)allBinaryExpressions) {
                ASTNode it = (ASTNode)t;
                boolean bl = false;
                if (!this.isDetectStringConcatenationInExpression(it)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        ASTNode nodeWithBug = v0;
        boolean bl = bugDetected = nodeWithBug != null;
        if (bugDetected) {
            this.fixBinaryExpressionWithConcatenation(nodeWithBug);
            this.loop(parentTopLevelBinaryExpr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDetectStringConcatenationInExpression(ASTNode node) {
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) {
            boolean $i$a$-require-StringConcatenationRule$isDetectStringConcatenationInExpression$22 = false;
            String $i$a$-require-StringConcatenationRule$isDetectStringConcatenationInExpression$22 = "cannot process non binary expression in the process of detecting string concatenation";
            throw new IllegalArgumentException($i$a$-require-StringConcatenationRule$isDetectStringConcatenationInExpression$22.toString());
        }
        ASTNode firstChild = node.getFirstChildNode();
        ASTNode lastChild2 = node.getLastChildNode();
        if (!this.isPlusBinaryExpression(node)) return false;
        Intrinsics.checkNotNullExpressionValue((Object)firstChild, (String)"firstChild");
        Intrinsics.checkNotNullExpressionValue((Object)lastChild2, (String)"lastChild");
        if (!this.isStringVar(firstChild, lastChild2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStringVar(ASTNode firstChild, ASTNode lastChild2) {
        if (Intrinsics.areEqual((Object)firstChild.getElementType(), (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) return true;
        String string = firstChild.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"firstChild.text");
        if (!StringsKt.endsWith$default((String)string, (String)"toString()", (boolean)false, (int)2, null)) return false;
        if (!Intrinsics.areEqual((Object)firstChild.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) return false;
        if (!Intrinsics.areEqual((Object)lastChild2.getElementType(), (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) return false;
        return true;
    }

    private final boolean isPlusBinaryExpression(ASTNode node) {
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ASTNode operationReference = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getOPERATION_REFERENCE());
        ASTNode aSTNode = operationReference;
        return (aSTNode == null ? null : AstNodeUtilsKt.getFirstChildWithType(aSTNode, ElementType.INSTANCE.getPLUS())) != null;
    }

    private final void fixBinaryExpressionWithConcatenation(ASTNode node) {
        ASTNode aSTNode = node;
        Object object = aSTNode == null ? null : aSTNode.getPsi();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtBinaryExpression binaryExpressionPsi = (KtBinaryExpression)object;
        ASTNode parentNode = node.getTreeParent();
        String textNode = this.checkKtExpression(binaryExpressionPsi);
        ASTNode newNode = KotlinParser.createNode$default(new KotlinParser(), '\"' + textNode + '\"', false, 2, null);
        parentNode.replaceChild(node, newNode);
    }

    private final boolean isPlusBinaryExpressionAndFirstElementString(KtBinaryExpression binaryExpressionNode) {
        return binaryExpressionNode.getLeft() instanceof KtStringTemplateExpression && Intrinsics.areEqual((Object)ElementType.INSTANCE.getPLUS(), (Object)binaryExpressionNode.getOperationToken());
    }

    private final String checkKtExpression(KtBinaryExpression binaryExpressionPsi) {
        String leftText;
        String string;
        String rvalueText;
        String string2;
        KtExpression ktExpression = binaryExpressionPsi.getLeft();
        if (ktExpression == null) {
            string2 = null;
        } else {
            String string3 = ktExpression.getText();
            if (string3 == null) {
                string2 = null;
            } else {
                char[] cArray = new char[]{'\"'};
                string2 = StringsKt.trim((String)string3, (char[])cArray);
            }
        }
        String lvalueText = string2;
        KtExpression ktExpression2 = binaryExpressionPsi.getRight();
        String string4 = rvalueText = ktExpression2 == null ? null : ktExpression2.getText();
        if (this.isLvalueDotQualifiedExpression(binaryExpressionPsi)) {
            string = binaryExpressionPsi.getFirstChild().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"binaryExpressionPsi.firstChild.text");
            if (StringsKt.endsWith$default((String)string, (String)"toString()", (boolean)false, (int)2, null)) {
                leftText = binaryExpressionPsi.getFirstChild().getFirstChild().getText();
                lvalueText = "${" + leftText + '}';
            }
        }
        if (this.isLvalueReferenceExpression(binaryExpressionPsi) || this.isLvalueConstantExpression(binaryExpressionPsi)) {
            leftText = binaryExpressionPsi.getText();
            Intrinsics.checkNotNullExpressionValue((Object)leftText, (String)"binaryExpressionPsi.text");
            return leftText;
        }
        if (this.isLvalueBinaryExpression(binaryExpressionPsi)) {
            String string5;
            KtExpression ktExpression3 = binaryExpressionPsi.getLeft();
            if (ktExpression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
            }
            String rightValue = this.checkKtExpression((KtBinaryExpression)ktExpression3);
            KtExpression rightEx = binaryExpressionPsi.getRight();
            if (this.isRvalueParenthesized(binaryExpressionPsi)) {
                PsiElement psiElement;
                KtExpression ktExpression4 = rightEx;
                if (ktExpression4 == null) {
                    psiElement = null;
                } else {
                    PsiElement[] psiElementArray = ktExpression4.getChildren();
                    psiElement = psiElementArray == null ? null : psiElementArray[0];
                }
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                string5 = this.checkKtExpression((KtBinaryExpression)psiElement);
            } else {
                KtExpression ktExpression5 = rightEx;
                if (ktExpression5 == null) {
                    string5 = null;
                } else {
                    String string6 = ktExpression5.getText();
                    if (string6 == null) {
                        string5 = null;
                    } else {
                        char[] cArray = new char[]{'\"'};
                        string5 = StringsKt.trim((String)string6, (char[])cArray);
                    }
                }
            }
            String rightVal = string5;
            KtExpression ktExpression6 = binaryExpressionPsi.getLeft();
            if (Intrinsics.areEqual((Object)(ktExpression6 == null ? null : ktExpression6.getText()), (Object)rightValue)) {
                String string7 = binaryExpressionPsi.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"binaryExpressionPsi.text");
                return string7;
            }
            return Intrinsics.stringPlus((String)rightValue, (Object)rightVal);
        }
        if (this.isRvalueConstantExpression(binaryExpressionPsi) || this.isRvalueStringTemplateExpression(binaryExpressionPsi)) {
            String string8;
            String string9 = rvalueText;
            if (string9 == null) {
                string8 = null;
            } else {
                char[] rightVal = new char[]{'\"'};
                string8 = StringsKt.trim((String)string9, (char[])rightVal);
            }
            String rvalueTextNew = string8;
            return Intrinsics.stringPlus((String)lvalueText, rvalueTextNew);
        }
        if (this.isRvalueCallExpression(binaryExpressionPsi)) {
            return lvalueText + "${" + rvalueText + '}';
        }
        if (this.isRvalueReferenceExpression(binaryExpressionPsi)) {
            return lvalueText + '$' + rvalueText;
        }
        if (!this.isRvalueParenthesized(binaryExpressionPsi) && this.isRvalueExpression(binaryExpressionPsi)) {
            return lvalueText + "${" + rvalueText + '}';
        }
        if (this.isRvalueParenthesized(binaryExpressionPsi)) {
            PsiElement binExpression;
            PsiElement psiElement;
            KtExpression ktExpression7 = binaryExpressionPsi.getRight();
            if (ktExpression7 == null) {
                psiElement = null;
            } else {
                Object[] objectArray = ktExpression7.getChildren();
                psiElement = binExpression = objectArray == null ? null : (PsiElement)ArraysKt.first((Object[])objectArray);
            }
            if (binExpression instanceof KtBinaryExpression) {
                String rightValue;
                if (this.isPlusBinaryExpressionAndFirstElementString((KtBinaryExpression)binExpression)) {
                    rightValue = this.checkKtExpression((KtBinaryExpression)binExpression);
                    return Intrinsics.stringPlus((String)lvalueText, (Object)rightValue);
                }
                if (this.isLvalueBinaryExpression((KtBinaryExpression)binExpression)) {
                    String string10;
                    KtExpression ktExpression8 = ((KtBinaryExpression)binExpression).getLeft();
                    if (ktExpression8 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                    }
                    rightValue = this.checkKtExpression((KtBinaryExpression)ktExpression8);
                    KtExpression rightEx = ((KtBinaryExpression)binExpression).getRight();
                    if (this.isRvalueParenthesized((KtBinaryExpression)binExpression)) {
                        PsiElement psiElement2;
                        KtExpression ktExpression9 = rightEx;
                        if (ktExpression9 == null) {
                            psiElement2 = null;
                        } else {
                            PsiElement[] psiElementArray = ktExpression9.getChildren();
                            psiElement2 = psiElementArray == null ? null : psiElementArray[0];
                        }
                        if (psiElement2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                        }
                        string10 = this.checkKtExpression((KtBinaryExpression)psiElement2);
                    } else {
                        KtExpression ktExpression10 = rightEx;
                        if (ktExpression10 == null) {
                            string10 = null;
                        } else {
                            String string11 = ktExpression10.getText();
                            if (string11 == null) {
                                string10 = null;
                            } else {
                                char[] cArray = new char[]{'\"'};
                                string10 = StringsKt.trim((String)string11, (char[])cArray);
                            }
                        }
                    }
                    String rightVal = string10;
                    KtExpression ktExpression11 = ((KtBinaryExpression)binExpression).getLeft();
                    if (Intrinsics.areEqual((Object)(ktExpression11 == null ? null : ktExpression11.getText()), (Object)rightValue)) {
                        return lvalueText + "${" + rvalueText + '}';
                    }
                    return lvalueText + rightValue + rightVal;
                }
            }
            return lvalueText + "${" + rvalueText + '}';
        }
        string = binaryExpressionPsi.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"binaryExpressionPsi.text");
        return string;
    }

    private final boolean isRvalueConstantExpression(KtBinaryExpression $this$isRvalueConstantExpression) {
        return $this$isRvalueConstantExpression.getRight() instanceof KtConstantExpression;
    }

    private final boolean isRvalueStringTemplateExpression(KtBinaryExpression $this$isRvalueStringTemplateExpression) {
        return $this$isRvalueStringTemplateExpression.getRight() instanceof KtStringTemplateExpression;
    }

    private final boolean isRvalueCallExpression(KtBinaryExpression $this$isRvalueCallExpression) {
        return $this$isRvalueCallExpression.getRight() instanceof KtCallExpression;
    }

    private final boolean isRvalueReferenceExpression(KtBinaryExpression $this$isRvalueReferenceExpression) {
        return $this$isRvalueReferenceExpression.getRight() instanceof KtReferenceExpression;
    }

    private final boolean isRvalueParenthesized(KtBinaryExpression $this$isRvalueParenthesized) {
        return $this$isRvalueParenthesized.getRight() instanceof KtParenthesizedExpression;
    }

    private final boolean isLvalueDotQualifiedExpression(KtBinaryExpression $this$isLvalueDotQualifiedExpression) {
        return $this$isLvalueDotQualifiedExpression.getLeft() instanceof KtDotQualifiedExpression;
    }

    private final boolean isLvalueBinaryExpression(KtBinaryExpression $this$isLvalueBinaryExpression) {
        return $this$isLvalueBinaryExpression.getLeft() instanceof KtBinaryExpression;
    }

    private final boolean isLvalueReferenceExpression(KtBinaryExpression $this$isLvalueReferenceExpression) {
        return $this$isLvalueReferenceExpression.getLeft() instanceof KtReferenceExpression;
    }

    private final boolean isLvalueConstantExpression(KtBinaryExpression $this$isLvalueConstantExpression) {
        return $this$isLvalueConstantExpression.getLeft() instanceof KtConstantExpression;
    }

    private final boolean isRvalueExpression(KtBinaryExpression $this$isRvalueExpression) {
        return $this$isRvalueExpression.getRight() != null;
    }

    public static final /* synthetic */ void access$fixBinaryExpressionWithConcatenation(StringConcatenationRule $this, ASTNode node) {
        $this.fixBinaryExpressionWithConcatenation(node);
    }

    public static final /* synthetic */ void access$loop(StringConcatenationRule $this, ASTNode parentTopLevelBinaryExpr) {
        $this.loop(parentTopLevelBinaryExpr);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/StringConcatenationRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

