/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/StringTemplateFormatRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "bracesCanBeOmitted", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleLongStringTemplate", "", "handleShortStringTemplate", "logic", "Companion", "diktat-rules"})
public final class StringTemplateFormatRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "abs-string-template-format";

    public StringTemplateFormatRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Warnings[] warningsArray = new Warnings[]{Warnings.STRING_TEMPLATE_CURLY_BRACES, Warnings.STRING_TEMPLATE_QUOTES};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])warningsArray), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY())) {
            this.handleLongStringTemplate(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY())) {
            this.handleShortStringTemplate(node);
        }
    }

    private final void handleLongStringTemplate(ASTNode node) {
        if (this.bracesCanBeOmitted(node)) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            Warnings.warnAndFix$default(Warnings.STRING_TEMPLATE_CURLY_BRACES, list, function3, bl, string, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node, this){
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ StringTemplateFormatRule this$0;
                {
                    this.$node = $node;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    block2: {
                        Unit unit;
                        ASTNode aSTNode;
                        Unit unit2;
                        ASTNode identifierName;
                        ASTNode aSTNode2 = identifierName = this.$node.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                        if (aSTNode2 == null) {
                            unit2 = null;
                        } else {
                            aSTNode = aSTNode2;
                            ASTNode aSTNode3 = this.$node;
                            ASTNode it = aSTNode;
                            boolean bl = false;
                            CompositeElement shortTemplate = new CompositeElement(ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY());
                            CompositeElement reference = new CompositeElement(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                            aSTNode3.getTreeParent().addChild((ASTNode)shortTemplate, aSTNode3);
                            shortTemplate.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getSHORT_TEMPLATE_ENTRY_START(), (CharSequence)"$"), null);
                            shortTemplate.addChild((ASTNode)reference);
                            reference.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getIDENTIFIER(), (CharSequence)identifierName.getText()));
                            aSTNode3.getTreeParent().removeChild(aSTNode3);
                            unit2 = unit = Unit.INSTANCE;
                        }
                        if (unit != null) break block2;
                        StringTemplateFormatRule stringTemplateFormatRule = this.this$0;
                        aSTNode = this.$node;
                        StringTemplateFormatRule $this$invoke_u24lambda_u2d1 = stringTemplateFormatRule;
                        boolean bl = false;
                        ASTNode stringTemplate = aSTNode.getTreeParent();
                        Object object = aSTNode.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
                        String string = object;
                        object = new char[3];
                        object[0] = 36;
                        object[1] = 123;
                        object[2] = 125;
                        String appropriateText = StringsKt.trim((String)string, (char[])object);
                        stringTemplate.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY(), (CharSequence)appropriateText), aSTNode);
                        stringTemplate.removeChild(aSTNode);
                    }
                }
            }, 64, null);
        }
    }

    private final void handleShortStringTemplate(ASTNode node) {
        String identifierName;
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
        String string = identifierName = aSTNode == null ? null : aSTNode.getText();
        if (identifierName != null) {
            Object object = node.getTreeParent().getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.treeParent.text");
            String string2 = object;
            object = new char[2];
            object[0] = 34;
            object[1] = 36;
            if (Intrinsics.areEqual((Object)StringsKt.trim((String)string2, (char[])object), (Object)identifierName)) {
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl = this.isFixMode();
                object = node.getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
                Warnings.warnAndFix$default(Warnings.STRING_TEMPLATE_QUOTES, list, function3, bl, (String)object, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                    final /* synthetic */ ASTNode $node;
                    {
                        this.$node = $node;
                        super(0);
                    }

                    public final void invoke() {
                        ASTNode aSTNode = this.$node.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                        Intrinsics.checkNotNull((Object)aSTNode);
                        ASTNode identifier = aSTNode.copyElement();
                        this.$node.getTreeParent().getTreeParent().addChild(identifier, this.$node.getTreeParent());
                        this.$node.getTreeParent().getTreeParent().removeChild(this.$node.getTreeParent());
                    }
                }, 64, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean bracesCanBeOmitted(ASTNode node) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode aSTNode3 = (ASTNode)CollectionsKt.singleOrNull((List)AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null));
        boolean onlyOneRefExpr = Intrinsics.areEqual(aSTNode3 == null ? null : ((aSTNode2 = aSTNode3.getTreeParent()) == null ? null : aSTNode2.getElementType()), (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY());
        ASTNode aSTNode4 = (ASTNode)CollectionsKt.singleOrNull((List)AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null));
        boolean isArrayAccessExpression = Intrinsics.areEqual(aSTNode4 == null ? null : ((aSTNode = aSTNode4.getTreeParent()) == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getARRAY_ACCESS_EXPRESSION());
        if (onlyOneRefExpr && !isArrayAccessExpression) {
            String string = node.getTreeNext().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treeNext.text");
            if (!Character.isLetterOrDigit(StringsKt.first((CharSequence)string))) {
                String string2 = node.getTreeNext().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.treeNext.text");
                if (!StringsKt.startsWith$default((String)string2, (String)"_", (boolean)false, (int)2, null)) return true;
            }
            if (!Intrinsics.areEqual((Object)node.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getCLOSING_QUOTE())) return false;
            return true;
        }
        if (isArrayAccessExpression) return false;
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getFLOAT_CONSTANT(), ElementType.INSTANCE.getINTEGER_CONSTANT()};
        boolean bl = AstNodeUtilsKt.hasAnyChildOfTypes(node, iElementTypeArray);
        return bl;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/StringTemplateFormatRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

