/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3.files;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/BlankLinesRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "handleBlankLine", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleTooManyBlankLines", "logic", "Companion", "diktat-rules"})
public final class BlankLinesRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "acd-blank-lines";

    public BlankLinesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.TOO_MANY_BLANK_LINES)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            if (AstNodeUtilsKt.numNewLines(node) == 2) {
                this.handleBlankLine(node);
            } else if (AstNodeUtilsKt.numNewLines(node) > 2) {
                this.handleTooManyBlankLines(node);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void handleBlankLine(ASTNode node) {
        block8: {
            ASTNode it;
            block7: {
                it = node.getTreeParent();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) break block7;
                ASTNode aSTNode = it.getTreeParent();
                if (!Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getElementType()), (Object)ElementType.INSTANCE.getSCRIPT())) break block8;
            }
            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getCLASS_BODY())) {
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) return;
            }
        }
        boolean bl = true;
        if (!bl) return;
        ASTNode aSTNode = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getLAMBDA_ARGUMENT());
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl2 = false;
            String string = node.getTreeNext().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treeNext.text");
            if (((CharSequence)string).length() == 0) {
                return;
            }
            boolean bl3 = false;
            if (bl3) {
                return;
            }
        }
        if (!(Intrinsics.areEqual((Object)node.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getRBRACE()) ^ Intrinsics.areEqual((Object)node.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getLBRACE()))) return;
        String freeText = "do not put newlines " + (Intrinsics.areEqual((Object)node.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getLBRACE()) ? "in the beginning" : "at the end") + " of code blocks";
        Warnings.warnAndFix$default(Warnings.TOO_MANY_BLANK_LINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
            final /* synthetic */ ASTNode $node;
            {
                this.$node = $node;
                super(0);
            }

            public final void invoke() {
                AstNodeUtilsKt.leaveOnlyOneNewLine(this.$node);
            }
        }, 64, null);
    }

    private final void handleTooManyBlankLines(ASTNode node) {
        Warnings.warnAndFix$default(Warnings.TOO_MANY_BLANK_LINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "do not use more than two consecutive blank lines", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
            final /* synthetic */ ASTNode $node;
            {
                this.$node = $node;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final void invoke() {
                block2: {
                    block3: {
                        if (Intrinsics.areEqual((Object)this.$node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFILE())) break block2;
                        ASTNode aSTNode = this.$node.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
                        if (Intrinsics.areEqual((Object)AstNodeUtilsKt.getFirstChildWithType(aSTNode, ElementType.INSTANCE.getWHITE_SPACE()), (Object)this.$node)) break block3;
                        aSTNode = this.$node.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeParent");
                        if (!Intrinsics.areEqual((Object)CollectionsKt.last(AstNodeUtilsKt.getAllChildrenWithType(aSTNode, ElementType.INSTANCE.getWHITE_SPACE())), (Object)this.$node)) break block2;
                    }
                    AstNodeUtilsKt.leaveExactlyNumNewLines(this.$node, 1);
                    return;
                }
                AstNodeUtilsKt.leaveExactlyNumNewLines(this.$node, 2);
            }
        }, 64, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/BlankLinesRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

