/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3.files;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstConstantsKt;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.ReplacementResult;
import org.cqfn.diktat.ruleset.utils.StandardPlatforms;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 72\u00020\u0001:\u0003789B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010'\u001a\u00020\u00172\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0003H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J2\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\u00032\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00030\u0003H\u0002J\"\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0\u00030\u00032\f\u0010+\u001a\b\u0012\u0004\u0012\u00020%0\u0003H\u0002JN\u0010.\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0004\u0012\u00020\u00190/*\u00020\u00192\b\u00100\u001a\u0004\u0018\u00010\u00192\b\u00101\u001a\u0004\u0018\u00010\u00192\b\u00102\u001a\u0004\u0018\u00010\u00192\u0006\u00103\u001a\u00020\u00192\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00190\u0003H\u0002J\u0014\u00105\u001a\u00020\u001b*\u00020%2\u0006\u00106\u001a\u00020\u0014H\u0002R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00030\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/FileStructureRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "domainName", "", "getDomainName", "()Ljava/lang/String;", "domainName$delegate", "Lkotlin/Lazy;", "ignoreImportsPatterns", "", "Lkotlin/text/Regex;", "packageName", "refSet", "", "standardImportsAsName", "", "Lorg/cqfn/diktat/ruleset/utils/StandardPlatforms;", "Lorg/jetbrains/kotlin/name/Name;", "checkCodeBlocksOrderAndEmptyLines", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkFileHasCode", "", "checkImportsOrder", "wildCardImportsConfig", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/FileStructureRule$WildCardImportsConfig;", "importsGroupingConfig", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/FileStructureRule$ImportsGroupingConfig;", "checkUnusedImport", "deleteImport", "importPath", "ktImportDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "findAllReferences", "insertNewlinesBetweenBlocks", "blocks", "logic", "rearrangeImports", "imports", "sortedImportsGroups", "regroupImports", "getSiblingBlocks", "Lkotlin/Pair;", "copyrightComment", "headerKdoc", "fileAnnotations", "firstCodeNode", "otherNodesBeforeFirst", "isStandard", "platformName", "Companion", "ImportsGroupingConfig", "WildCardImportsConfig", "diktat-rules"})
public final class FileStructureRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy domainName$delegate;
    @NotNull
    private final Map<StandardPlatforms, List<List<Name>>> standardImportsAsName;
    @NotNull
    private final Set<String> refSet;
    @NotNull
    private String packageName;
    @NotNull
    private final Set<Regex> ignoreImportsPatterns;
    @NotNull
    public static final String NAME_ID = "acq-file-structure";

    /*
     * WARNING - void declaration
     */
    public FileStructureRule(@NotNull List<RulesConfig> configRules) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map map;
        void $this$associateTo$iv$iv;
        Map $this$associate$iv;
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Enum[] enumArray = new Warnings[]{Warnings.FILE_CONTAINS_ONLY_COMMENTS, Warnings.FILE_INCORRECT_BLOCKS_ORDER, Warnings.FILE_NO_BLANK_LINE_BETWEEN_BLOCKS, Warnings.FILE_UNORDERED_IMPORTS, Warnings.FILE_WILDCARD_IMPORTS, Warnings.UNUSED_IMPORT};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])enumArray), null, 8, null);
        this.domainName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(configRules){
            final /* synthetic */ List<RulesConfig> $configRules;
            {
                this.$configRules = $configRules;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return RulesConfigReaderKt.getCommonConfiguration(this.$configRules).getDomainName();
            }
        }));
        enumArray = StandardPlatforms.values();
        FileStructureRule fileStructureRule = this;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associate$iv).length), (int)16);
        void var5_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Map.Entry element$iv$iv : $this$associateTo$iv$iv) {
            map = destination$iv$iv;
            Pair it = element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it, it.getPackages());
            map.put(it.getFirst(), it.getSecond());
        }
        $this$associate$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        void capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void $dstr$_u24__u24$value;
            void it$iv$iv;
            Map.Entry element$iv$iv;
            element$iv$iv = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl2 = false;
            List value = (List)$dstr$_u24__u24$value.getValue();
            Iterable $this$map$iv = value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl3 = false;
                String[] stringArray = new String[]{"."};
                Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void p0;
                    String string2 = (String)item$iv$iv2;
                    Collection collection2 = destination$iv$iv4;
                    boolean bl4 = false;
                    collection2.add(Name.identifier((String)p0));
                }
                collection.add((List)destination$iv$iv4);
            }
            List list = (List)destination$iv$iv3;
            map2.put(k, list);
        }
        fileStructureRule.standardImportsAsName = destination$iv$iv2;
        this.refSet = new LinkedHashSet();
        this.packageName = "";
        this.ignoreImportsPatterns = SetsKt.setOf((Object)new Regex("component\\d+"));
    }

    private final String getDomainName() {
        Lazy lazy = this.domainName$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.FILE_WILDCARD_IMPORTS);
            Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            WildCardImportsConfig wildcardImportsConfig = new WildCardImportsConfig(map);
            RulesConfig rulesConfig2 = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.FILE_UNORDERED_IMPORTS);
            Map map2 = rulesConfig2 == null ? null : rulesConfig2.getConfiguration();
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            ImportsGroupingConfig importsGroupingConfig = new ImportsGroupingConfig(map2);
            this.checkUnusedImport(node);
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getIMPORT_LIST());
            if (aSTNode != null) {
                ASTNode it = aSTNode;
                boolean bl = false;
                this.checkImportsOrder(it, wildcardImportsConfig, importsGroupingConfig);
            }
            if (this.checkFileHasCode(node)) {
                this.checkCodeBlocksOrderAndEmptyLines(node);
            }
            return;
        }
    }

    private final boolean checkFileHasCode(ASTNode node) {
        boolean hasCode;
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getKDOC(), ElementType.INSTANCE.getBLOCK_COMMENT(), ElementType.INSTANCE.getEOL_COMMENT(), ElementType.INSTANCE.getPACKAGE_DIRECTIVE(), ElementType.INSTANCE.getIMPORT_LIST()};
        TokenSet tokenSet = TokenSet.andNot((TokenSet)TokenSet.ANY, (TokenSet)TokenSet.create((IElementType[])iElementTypeArray));
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"andNot(\n            Toke\u2026E, IMPORT_LIST)\n        )");
        TokenSet codeTokens = tokenSet;
        iElementTypeArray = node.getChildren(codeTokens);
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"node.getChildren(codeTokens)");
        boolean bl = hasCode = !(((Object[])iElementTypeArray).length == 0);
        if (!hasCode) {
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            String freeText = ((CharSequence)string).length() == 0 ? "file is empty" : "file contains no code";
            Warnings.FILE_CONTAINS_ONLY_COMMENTS.warn(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), freeText, node.getStartOffset(), node);
        }
        return hasCode;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCodeBlocksOrderAndEmptyLines(ASTNode node) {
        KtPackageDirective ktPackageDirective;
        ASTNode aSTNode;
        Ref.ObjectRef headerKdoc;
        KtPackageDirective $this$prevSibling$iv;
        Ref.ObjectRef objectRef;
        Ref.ObjectRef copyrightComment;
        ASTNode firstCodeNode;
        ASTNode importsList;
        ASTNode packageDirectiveNode;
        block27: {
            Object object;
            ASTNode aSTNode2;
            KtPackageDirective it;
            block25: {
                ASTNode aSTNode3;
                Object object2;
                KtImportList ktImportList;
                KtPackageDirective ktPackageDirective2;
                ASTNode aSTNode4;
                PsiElement psiElement = node.getPsi();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                }
                KtPackageDirective ktPackageDirective3 = ((KtFile)psiElement).getPackageDirective();
                if (ktPackageDirective3 == null) {
                    aSTNode4 = null;
                } else {
                    it = ktPackageDirective2 = ktPackageDirective3;
                    boolean bl = false;
                    ktImportList = !it.isRoot() ? ktPackageDirective2 : null;
                    aSTNode4 = ktImportList == null ? null : ktImportList.getNode();
                }
                packageDirectiveNode = aSTNode4;
                PsiElement psiElement2 = node.getPsi();
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                }
                ktImportList = ((KtFile)psiElement2).getImportList();
                if (ktImportList == null) {
                    object2 = null;
                } else {
                    KtPackageDirective it2 = it = ktImportList;
                    boolean bl = false;
                    List list = it2.getImports();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.imports");
                    ktPackageDirective2 = !((Collection)list).isEmpty() ? it : null;
                    object2 = importsList = ktPackageDirective2 == null ? null : ktPackageDirective2.getNode();
                }
                if ((aSTNode3 = packageDirectiveNode == null ? importsList : packageDirectiveNode) == null) {
                    Object v6;
                    block24: {
                        Sequence $this$firstOrNull$iv = PackageKt.children((ASTNode)node);
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            ASTNode it3 = (ASTNode)element$iv;
                            boolean bl = false;
                            boolean bl2 = !(PackageKt.isWhiteSpace((ASTNode)it3) || PackageKt.isPartOfComment((ASTNode)it3) || Intrinsics.areEqual((Object)it3.getElementType(), (Object)ElementType.INSTANCE.getFILE_ANNOTATION_LIST()) || Intrinsics.areEqual((Object)it3.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_LIST()) || Intrinsics.areEqual((Object)it3.getElementType(), (Object)ElementType.INSTANCE.getPACKAGE_DIRECTIVE()));
                            if (!bl2) continue;
                            v6 = element$iv;
                            break block24;
                        }
                        v6 = null;
                    }
                    it = v6;
                    if (it == null) {
                        return;
                    }
                    aSTNode3 = it;
                }
                firstCodeNode = aSTNode3;
                copyrightComment = new Ref.ObjectRef();
                ASTNode $this$firstOrNull$iv = firstCodeNode;
                objectRef = copyrightComment;
                boolean $i$f$prevSibling = false;
                for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                    ASTNode it4 = n$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it4.getElementType(), (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) continue;
                    aSTNode2 = n$iv;
                    break block25;
                }
                aSTNode2 = null;
            }
            Ref.ObjectRef objectRef2 = objectRef;
            it = aSTNode2;
            if (it == null) {
                object = null;
            } else {
                boolean bl;
                block26: {
                    KtPackageDirective $i$f$prevSibling = $this$prevSibling$iv = it;
                    objectRef = objectRef2;
                    boolean bl3 = false;
                    Iterable $this$any$iv = AstConstantsKt.getCopyrightWords();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            void blockCommentNode;
                            String it5 = (String)element$iv;
                            boolean bl4 = false;
                            String string = blockCommentNode.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blockCommentNode.text");
                            if (!StringsKt.contains((CharSequence)string, (CharSequence)it5, (boolean)true)) continue;
                            bl = true;
                            break block26;
                        }
                        bl = false;
                    }
                }
                boolean bl5 = bl;
                objectRef2 = objectRef;
                object = bl5 ? $this$prevSibling$iv : null;
            }
            objectRef2.element = object;
            headerKdoc = new Ref.ObjectRef();
            ASTNode blockCommentNode = firstCodeNode;
            objectRef = headerKdoc;
            boolean $i$f$prevSibling = false;
            for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                ASTNode it6 = n$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it6.getElementType(), (Object)ElementType.INSTANCE.getKDOC())) continue;
                aSTNode = n$iv;
                break block27;
            }
            aSTNode = null;
        }
        Ref.ObjectRef objectRef3 = objectRef;
        $this$prevSibling$iv = aSTNode;
        if ($this$prevSibling$iv == null) {
            if (Intrinsics.areEqual((Object)firstCodeNode, (Object)packageDirectiveNode)) {
                ASTNode aSTNode5 = importsList;
                if (aSTNode5 == null) {
                    ktPackageDirective = null;
                } else {
                    ASTNode aSTNode6;
                    block28: {
                        ASTNode $i$f$prevSibling = aSTNode5;
                        objectRef = objectRef3;
                        boolean $i$f$prevSibling2 = false;
                        for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                            ASTNode it = n$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getKDOC())) continue;
                            aSTNode6 = n$iv;
                            break block28;
                        }
                        aSTNode6 = null;
                    }
                    ktPackageDirective = aSTNode6;
                    objectRef3 = objectRef;
                }
            } else {
                ktPackageDirective = null;
            }
        } else {
            ktPackageDirective = $this$prevSibling$iv;
        }
        objectRef3.element = ktPackageDirective;
        Ref.ObjectRef fileAnnotations = new Ref.ObjectRef();
        fileAnnotations.element = node.findChildByType(ElementType.INSTANCE.getFILE_ANNOTATION_LIST());
        List otherNodesBeforeCode2 = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)PsiUtilsKt.siblings((ASTNode)firstCodeNode, (boolean)false), (Function1)((Function1)new Function1<ASTNode, Boolean>((Ref.ObjectRef<ASTNode>)copyrightComment, (Ref.ObjectRef<ASTNode>)headerKdoc, (Ref.ObjectRef<ASTNode>)fileAnnotations){
            final /* synthetic */ Ref.ObjectRef<ASTNode> $copyrightComment;
            final /* synthetic */ Ref.ObjectRef<ASTNode> $headerKdoc;
            final /* synthetic */ Ref.ObjectRef<ASTNode> $fileAnnotations;
            {
                this.$copyrightComment = $copyrightComment;
                this.$headerKdoc = $headerKdoc;
                this.$fileAnnotations = $fileAnnotations;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return PackageKt.isWhiteSpace((ASTNode)it) || Intrinsics.areEqual((Object)it, (Object)this.$copyrightComment.element) || Intrinsics.areEqual((Object)it, (Object)this.$headerKdoc.element) || Intrinsics.areEqual((Object)it, (Object)this.$fileAnnotations.element);
            }
        }))));
        Object[] objectArray = new SpreadBuilder(4);
        objectArray.add(copyrightComment.element);
        objectArray.add(headerKdoc.element);
        objectArray.add(fileAnnotations.element);
        Collection $this$toTypedArray$iv = otherNodesBeforeCode2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        ASTNode[] aSTNodeArray = thisCollection$iv.toArray(new ASTNode[0]);
        if (aSTNodeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        objectArray.addSpread((Object)aSTNodeArray);
        AstNodeUtilsKt.handleIncorrectOrder(CollectionsKt.listOfNotNull((Object[])objectArray.toArray((Object[])new ASTNode[objectArray.size()])), (Function1<? super ASTNode, ? extends Pair<? extends ASTNode, ? extends ASTNode>>)((Function1)new Function1<ASTNode, Pair<? extends ASTNode, ? extends ASTNode>>(this, (Ref.ObjectRef<ASTNode>)copyrightComment, (Ref.ObjectRef<ASTNode>)headerKdoc, (Ref.ObjectRef<ASTNode>)fileAnnotations, firstCodeNode, (List<? extends ASTNode>)otherNodesBeforeCode2){
            final /* synthetic */ FileStructureRule this$0;
            final /* synthetic */ Ref.ObjectRef<ASTNode> $copyrightComment;
            final /* synthetic */ Ref.ObjectRef<ASTNode> $headerKdoc;
            final /* synthetic */ Ref.ObjectRef<ASTNode> $fileAnnotations;
            final /* synthetic */ ASTNode $firstCodeNode;
            final /* synthetic */ List<ASTNode> $otherNodesBeforeCode;
            {
                this.this$0 = $receiver;
                this.$copyrightComment = $copyrightComment;
                this.$headerKdoc = $headerKdoc;
                this.$fileAnnotations = $fileAnnotations;
                this.$firstCodeNode = $firstCodeNode;
                this.$otherNodesBeforeCode = $otherNodesBeforeCode;
                super(1);
            }

            @NotNull
            public final Pair<ASTNode, ASTNode> invoke(@NotNull ASTNode $this$handleIncorrectOrder) {
                Intrinsics.checkNotNullParameter((Object)$this$handleIncorrectOrder, (String)"$this$handleIncorrectOrder");
                return FileStructureRule.access$getSiblingBlocks(this.this$0, $this$handleIncorrectOrder, (ASTNode)this.$copyrightComment.element, (ASTNode)this.$headerKdoc.element, (ASTNode)this.$fileAnnotations.element, this.$firstCodeNode, this.$otherNodesBeforeCode);
            }
        }), (Function2<? super ASTNode, ? super ASTNode, Unit>)((Function2)new Function2<ASTNode, ASTNode, Unit>(this, node, (Ref.ObjectRef<ASTNode>)copyrightComment, (Ref.ObjectRef<ASTNode>)headerKdoc, (Ref.ObjectRef<ASTNode>)fileAnnotations){
            final /* synthetic */ FileStructureRule this$0;
            final /* synthetic */ ASTNode $node;
            final /* synthetic */ Ref.ObjectRef<ASTNode> $copyrightComment;
            final /* synthetic */ Ref.ObjectRef<ASTNode> $headerKdoc;
            final /* synthetic */ Ref.ObjectRef<ASTNode> $fileAnnotations;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                this.$copyrightComment = $copyrightComment;
                this.$headerKdoc = $headerKdoc;
                this.$fileAnnotations = $fileAnnotations;
                super(2);
            }

            public final void invoke(@NotNull ASTNode astNode, @NotNull ASTNode beforeThisNode) {
                Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
                Intrinsics.checkNotNullParameter((Object)beforeThisNode, (String)"beforeThisNode");
                List<RulesConfig> list = this.this$0.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.this$0.getEmitWarn();
                boolean bl = this.this$0.isFixMode();
                String string = astNode.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"astNode.text");
                Warnings.warnAndFix$default(Warnings.FILE_INCORRECT_BLOCKS_ORDER, list, function3, bl, (String)CollectionsKt.first((List)StringsKt.lines((CharSequence)string)), astNode.getStartOffset(), astNode, false, (Function0)new Function0<Unit>(this.$node, astNode, beforeThisNode, this.$copyrightComment, this.$headerKdoc, this.$fileAnnotations){
                    final /* synthetic */ ASTNode $node;
                    final /* synthetic */ ASTNode $astNode;
                    final /* synthetic */ ASTNode $beforeThisNode;
                    final /* synthetic */ Ref.ObjectRef<ASTNode> $copyrightComment;
                    final /* synthetic */ Ref.ObjectRef<ASTNode> $headerKdoc;
                    final /* synthetic */ Ref.ObjectRef<ASTNode> $fileAnnotations;
                    {
                        this.$node = $node;
                        this.$astNode = $astNode;
                        this.$beforeThisNode = $beforeThisNode;
                        this.$copyrightComment = $copyrightComment;
                        this.$headerKdoc = $headerKdoc;
                        this.$fileAnnotations = $fileAnnotations;
                        super(0);
                    }

                    public final void invoke() {
                        ReplacementResult result = AstNodeUtilsKt.moveChildBefore(this.$node, this.$astNode, this.$beforeThisNode, true);
                        Object object = CollectionsKt.first(result.getNewNodes());
                        ASTNode aSTNode = this.$copyrightComment;
                        ASTNode aSTNode2 = this.$headerKdoc;
                        Ref.ObjectRef<ASTNode> objectRef = this.$fileAnnotations;
                        ASTNode $this$invoke_u24lambda_u2d0 = (ASTNode)object;
                        boolean bl = false;
                        IElementType iElementType = $this$invoke_u24lambda_u2d0.getElementType();
                        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getBLOCK_COMMENT())) {
                            aSTNode.element = $this$invoke_u24lambda_u2d0;
                        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getKDOC())) {
                            aSTNode2.element = $this$invoke_u24lambda_u2d0;
                        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFILE_ANNOTATION_LIST())) {
                            objectRef.element = $this$invoke_u24lambda_u2d0;
                        }
                        ASTNode aSTNode3 = this.$astNode.getTreeNext();
                        if (aSTNode3 != null) {
                            aSTNode = aSTNode3;
                            aSTNode2 = this.$node;
                            ASTNode it = aSTNode;
                            boolean bl2 = false;
                            aSTNode2.replaceChild(it, (ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n\n"));
                        }
                    }
                }, 64, null);
            }
        }));
        objectArray = new ASTNode[]{(ASTNode)copyrightComment.element, (ASTNode)headerKdoc.element, (ASTNode)fileAnnotations.element, packageDirectiveNode, importsList};
        this.insertNewlinesBetweenBlocks(CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkImportsOrder(ASTNode node, WildCardImportsConfig wildCardImportsConfig, ImportsGroupingConfig importsGroupingConfig) {
        List list;
        Iterable $this$mapTo$iv$iv;
        Object object;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getIMPORT_DIRECTIVE()};
        Object object2 = node.getChildren(TokenSet.create((IElementType[])iElementTypeArray));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"node.getChildren(TokenSe\u2026create(IMPORT_DIRECTIVE))");
        List imports = ArraysKt.toList((Object[])object2);
        object2 = imports;
        boolean $i$f$filter = false;
        void var7_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            ImportPath $this$checkImportsOrder_u24lambda_u2d13_u24lambda_u2d12;
            Object element$iv$iv = iterator.next();
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            PsiElement psiElement = it.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
            }
            Intrinsics.checkNotNull((Object)((KtImportDirective)psiElement).getImportPath());
            boolean bl2 = false;
            boolean bl3 = $this$checkImportsOrder_u24lambda_u2d13_u24lambda_u2d12.isAllUnder() && !wildCardImportsConfig.getAllowedWildcards().contains($this$checkImportsOrder_u24lambda_u2d13_u24lambda_u2d12.toString());
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            List<RulesConfig> list2 = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl4 = this.isFixMode();
            Iterator iterator2 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"it.text");
            int n = it.getStartOffset();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Warnings.FILE_WILDCARD_IMPORTS.warn(list2, function3, bl4, (String)((Object)iterator2), n, it);
        }
        if (importsGroupingConfig.getUseRecommendedImportsOrder()) {
            Iterable $this$map$iv;
            Object element$iv;
            Iterable $i$f$forEach2 = imports;
            object = this;
            boolean $i$f$map = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ASTNode bl = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                PsiElement psiElement = it.getPsi();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                }
                collection.add((KtImportDirective)psiElement);
            }
            $this$map$iv = ((FileStructureRule)((Object)object)).regroupImports((List)destination$iv$iv2);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$mapTo$iv$iv2;
                void group;
                List it = (List)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                Iterable $this$map$iv2 = (Iterable)group;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it2;
                    KtImportDirective ktImportDirective = (KtImportDirective)item$iv$iv2;
                    Collection collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add(it2.getNode());
                }
                object.add((List)destination$iv$iv3);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = CollectionsKt.listOf((Object)imports);
        }
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List group = (List)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            Iterable $this$sortedBy$iv = group;
            boolean $i$f$sortedBy = false;
            object.add(CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ASTNode it = (ASTNode)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getText());
                    it = (ASTNode)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getText())));
                }
            }));
        }
        List sortedImportsGroups = (List)destination$iv$iv4;
        if (!Intrinsics.areEqual((Object)CollectionsKt.flatten((Iterable)sortedImportsGroups), (Object)imports)) {
            Warnings.warnAndFix$default(Warnings.FILE_UNORDERED_IMPORTS, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)((ASTNode)CollectionsKt.first((List)CollectionsKt.flatten((Iterable)sortedImportsGroups))).getText(), (Object)"..."), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node, (List<? extends ASTNode>)imports, (List<? extends List<? extends ASTNode>>)sortedImportsGroups){
                final /* synthetic */ FileStructureRule this$0;
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ List<ASTNode> $imports;
                final /* synthetic */ List<List<ASTNode>> $sortedImportsGroups;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    this.$imports = $imports;
                    this.$sortedImportsGroups = $sortedImportsGroups;
                    super(0);
                }

                public final void invoke() {
                    FileStructureRule.access$rearrangeImports(this.this$0, this.$node, this.$imports, this.$sortedImportsGroups);
                }
            }, 64, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkUnusedImport(ASTNode node) {
        block13: {
            this.findAllReferences(node);
            v0 = node.findChildByType(ElementType.INSTANCE.getPACKAGE_DIRECTIVE());
            v1 /* !! */  = v0 == null ? null : v0.getPsi();
            if (v1 /* !! */  == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPackageDirective");
            }
            var2_2 = ((KtPackageDirective)v1 /* !! */ ).getQualifiedName();
            Intrinsics.checkNotNullExpressionValue((Object)var2_2, (String)"node.findChildByType(PAC\u2026eDirective).qualifiedName");
            this.packageName = var2_2;
            var2_2 = node.findChildByType(ElementType.INSTANCE.getIMPORT_LIST());
            if (var2_2 == null) break block13;
            var4_3 /* !! */  = new IElementType[]{ElementType.INSTANCE.getIMPORT_DIRECTIVE()};
            var3_4 = var2_2.getChildren(TokenSet.create((IElementType[])var4_3 /* !! */ ));
            if (var3_4 == null || (var4_3 /* !! */  = ArraysKt.toList((Object[])var3_4)) == null) break block13;
            var5_5 = (Iterable)var4_3 /* !! */ ;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                block12: {
                    import = (ASTNode)element$iv;
                    $i$a$-forEach-FileStructureRule$checkUnusedImport$1 = false;
                    v2 = import.getPsi();
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtImportDirective");
                    }
                    ktImportDirective = (KtImportDirective)v2;
                    v3 = ktImportDirective.getImportPath();
                    if (v3 == null) {
                        v4 /* !! */  = null;
                    } else {
                        v5 = v3.getImportedName();
                        v4 /* !! */  = v5 == null ? null : v5.asString();
                    }
                    importName = v4 /* !! */ ;
                    v6 = ktImportDirective.getImportPath();
                    Intrinsics.checkNotNull((Object)(v6 == null ? null : v6.getPathStr()));
                    importPath = importPath;
                    if (ktImportDirective.getAliasName() == null && ((CharSequence)this.packageName).length() > 0 && StringsKt.startsWith$default((String)importPath, (String)Intrinsics.stringPlus((String)this.packageName, (Object)"."), (boolean)false, (int)2, null)) {
                        var15_15 = importPath.substring(this.packageName.length() + 1);
                        Intrinsics.checkNotNullExpressionValue((Object)var15_15, (String)"this as java.lang.String).substring(startIndex)");
                        if (StringsKt.indexOf$default((CharSequence)var15_15, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
                            this.deleteImport(importPath, node, ktImportDirective);
                            continue;
                        }
                    }
                    if (importName == null || this.refSet.contains(importName)) continue;
                    if (AstConstantsKt.getIgnoreImports().contains(importName)) ** GOTO lbl-1000
                    $this$any$iv = this.ignoreImportsPatterns;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v7 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (Regex)element$iv;
                            $i$a$-any-FileStructureRule$checkUnusedImport$1$shouldImportBeIgnored$1 = false;
                            if (!it.matches((CharSequence)importName)) continue;
                            v7 = true;
                            break block12;
                        }
                        v7 = false;
                    }
                }
                if (v7) lbl-1000:
                // 2 sources

                {
                    v8 = true;
                } else {
                    v8 = false;
                }
                if (shouldImportBeIgnored = v8) continue;
                this.deleteImport(importPath, node, ktImportDirective);
            }
        }
    }

    private final void deleteImport(String importPath, ASTNode node, KtImportDirective ktImportDirective) {
        Warnings.warnAndFix$default(Warnings.UNUSED_IMPORT, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)importPath, (Object)" - unused import"), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(ktImportDirective){
            final /* synthetic */ KtImportDirective $ktImportDirective;
            {
                this.$ktImportDirective = $ktImportDirective;
                super(0);
            }

            public final void invoke() {
                this.$ktImportDirective.delete();
            }
        }, 64, null);
    }

    private final void findAllReferences(ASTNode node) {
        String string;
        Iterable $this$forEach$iv = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getOPERATION_REFERENCE(), false, 2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode ref = (ASTNode)element$iv;
            boolean bl = false;
            if (PackageKt.isPartOf((ASTNode)ref, (IElementType)ElementType.INSTANCE.getIMPORT_DIRECTIVE())) continue;
            Map<String, List<String>> $this$filterValues$iv = AstConstantsKt.getOperatorMap();
            boolean $i$f$filterValues = false;
            LinkedHashMap<String, List<String>> result$iv = new LinkedHashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry$iv : $this$filterValues$iv.entrySet()) {
                List<String> it = entry$iv.getValue();
                boolean bl2 = false;
                if (!it.contains(ref.getText())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map references = result$iv;
            if (!references.isEmpty()) {
                Iterable $this$forEach$iv2 = references.keySet();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String key = (String)element$iv2;
                    boolean bl3 = false;
                    this.refSet.add(key);
                }
                continue;
            }
            string = ref.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ref.text");
            this.refSet.add(string);
        }
        $this$forEach$iv = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            if (PackageKt.isPartOf((ASTNode)it, (IElementType)ElementType.INSTANCE.getIMPORT_DIRECTIVE())) continue;
            string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            this.refSet.add(StringsKt.replace$default((String)string, (String)"`", (String)"", (boolean)false, (int)4, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void rearrangeImports(ASTNode node, List<? extends ASTNode> imports, List<? extends List<? extends ASTNode>> sortedImportsGroups) {
        void $this$filterNotTo$iv$iv;
        void $this$forEach$iv;
        if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getIMPORT_LIST())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getEOL_COMMENT()};
        Object[] objectArray = node.getChildren(TokenSet.create((IElementType[])iElementTypeArray));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"node.getChildren(TokenSet.create(EOL_COMMENT))");
        objectArray = objectArray;
        boolean $i$f$forEach = false;
        for (Iterator element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            node.getTreeParent().addChild((ASTNode)it.clone(), node);
            node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), node);
        }
        node.removeRange((ASTNode)CollectionsKt.first(imports), (ASTNode)CollectionsKt.last(imports));
        Iterable $this$filterNot$iv = sortedImportsGroups;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            if (it.isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$rearrangeImports_u24lambda_u2d30 = (List)destination$iv$iv;
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = $this$rearrangeImports_u24lambda_u2d30;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void group;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int groupIndex = n;
            boolean bl2 = false;
            Iterable $this$forEachIndexed$iv2 = (Iterable)group;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void importNode;
                int n2 = index$iv2;
                index$iv2 = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ASTNode aSTNode = (ASTNode)item$iv2;
                int index = n2;
                boolean bl3 = false;
                node.addChild((ASTNode)importNode, null);
                if (index == group.size() - 1) continue;
                node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
            }
            if (groupIndex == $this$rearrangeImports_u24lambda_u2d30.size() - 1) continue;
            node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n\n"), null);
        }
    }

    private final void insertNewlinesBetweenBlocks(List<? extends ASTNode> blocks2) {
        Iterable $this$forEach$iv = blocks2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            Object it;
            ASTNode astNode;
            block3: {
                astNode = (ASTNode)element$iv;
                boolean bl = false;
                if (astNode == null) continue;
                boolean $i$f$nextSibling = false;
                for (ASTNode n$iv = $this$nextSibling$iv.getTreeNext(); n$iv != null; n$iv = n$iv.getTreeNext()) {
                    it = n$iv;
                    boolean bl2 = false;
                    String string = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                    boolean bl3 = ((CharSequence)string).length() > 0;
                    if (!bl3) continue;
                    aSTNode2 = n$iv;
                    break block3;
                }
                aSTNode2 = null;
            }
            if (aSTNode2 == null) continue;
            ASTNode $this$insertNewlinesBetweenBlocks_u24lambda_u2d34_u24lambda_u2d33 = aSTNode = aSTNode2;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)$this$insertNewlinesBetweenBlocks_u24lambda_u2d34_u24lambda_u2d33.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) continue;
            it = $this$insertNewlinesBetweenBlocks_u24lambda_u2d34_u24lambda_u2d33.getText();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"text");
            CharSequence $this$count$iv = (CharSequence)it;
            boolean $i$f$count = false;
            int count$iv = 0;
            CharSequence charSequence = $this$count$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv2 = charSequence.charAt(i);
                char it2 = element$iv2;
                boolean bl4 = false;
                if (!(it2 == '\n')) continue;
                ++count$iv;
            }
            if (count$iv == 2) continue;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl5 = this.isFixMode();
            String string = astNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"astNode.text");
            Warnings.warnAndFix$default(Warnings.FILE_NO_BLANK_LINE_BETWEEN_BLOCKS, list, function3, bl5, (String)CollectionsKt.first((List)StringsKt.lines((CharSequence)string)), astNode.getStartOffset(), astNode, false, (Function0)new Function0<Unit>($this$insertNewlinesBetweenBlocks_u24lambda_u2d34_u24lambda_u2d33){
                final /* synthetic */ ASTNode $this_apply;
                {
                    this.$this_apply = $receiver;
                    super(0);
                }

                public final void invoke() {
                    LeafPsiElement leafPsiElement = (LeafPsiElement)this.$this_apply;
                    String string = ((LeafPsiElement)this.$this_apply).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                    leafPsiElement.rawReplaceWithText(Intrinsics.stringPlus((String)"\n\n", (Object)StringsKt.replace$default((String)string, (String)"\n", (String)"", (boolean)false, (int)4, null)));
                }
            }, 64, null);
        }
    }

    private final Pair<ASTNode, ASTNode> getSiblingBlocks(ASTNode $this$getSiblingBlocks, ASTNode copyrightComment, ASTNode headerKdoc, ASTNode fileAnnotations, ASTNode firstCodeNode, List<? extends ASTNode> otherNodesBeforeFirst) {
        Pair pair;
        ASTNode aSTNode = $this$getSiblingBlocks;
        if (Intrinsics.areEqual((Object)aSTNode, (Object)copyrightComment)) {
            Object[] objectArray = new ASTNode[]{headerKdoc, fileAnnotations, (ASTNode)CollectionsKt.firstOrNull(otherNodesBeforeFirst), firstCodeNode};
            pair = TuplesKt.to(null, (Object)CollectionsKt.first((List)CollectionsKt.listOfNotNull((Object[])objectArray)));
        } else if (Intrinsics.areEqual((Object)aSTNode, (Object)headerKdoc)) {
            ASTNode aSTNode2;
            ASTNode aSTNode3 = fileAnnotations;
            if (aSTNode3 == null) {
                aSTNode3 = aSTNode2 = (ASTNode)CollectionsKt.firstOrNull(otherNodesBeforeFirst);
            }
            if (aSTNode3 == null) {
                aSTNode2 = firstCodeNode;
            }
            pair = TuplesKt.to((Object)copyrightComment, (Object)aSTNode2);
        } else if (Intrinsics.areEqual((Object)aSTNode, (Object)fileAnnotations)) {
            ASTNode aSTNode4;
            ASTNode aSTNode5 = headerKdoc;
            if (aSTNode5 == null) {
                aSTNode5 = copyrightComment;
            }
            if ((aSTNode4 = (ASTNode)CollectionsKt.firstOrNull(otherNodesBeforeFirst)) == null) {
                aSTNode4 = firstCodeNode;
            }
            pair = TuplesKt.to((Object)aSTNode5, (Object)aSTNode4);
        } else {
            ASTNode aSTNode6 = headerKdoc;
            if (aSTNode6 == null) {
                aSTNode6 = copyrightComment;
            }
            pair = TuplesKt.to((Object)aSTNode6, (Object)firstCodeNode);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<KtImportDirective>> regroupImports(List<? extends KtImportDirective> imports) {
        Pair pair;
        Iterable $this$partition$iv = imports;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        Pair second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            KtImportDirective it = (KtImportDirective)element$iv;
            boolean bl = false;
            if (this.isStandard(it, StandardPlatforms.ANDROID)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair2 = new Pair(first$iv, second$iv);
        List android = (List)pair2.component1();
        List notAndroid = (List)pair2.component2();
        String string = this.getDomainName();
        if (string == null) {
            pair = null;
        } else {
            String domainName2 = string;
            boolean bl = false;
            Iterable $this$partition$iv2 = notAndroid;
            boolean $i$f$partition2 = false;
            ArrayList first$iv2 = new ArrayList();
            ArrayList second$iv2 = new ArrayList();
            for (Object element$iv : $this$partition$iv2) {
                boolean bl2;
                KtImportDirective ktImportDirective = (KtImportDirective)element$iv;
                boolean bl3 = false;
                ImportPath importPath = ktImportDirective.getImportPath();
                if (importPath == null) {
                    bl2 = false;
                } else {
                    FqName fqName = importPath.getFqName();
                    if (fqName == null) {
                        bl2 = false;
                    } else {
                        List list = fqName.pathSegments();
                        if (list == null) {
                            bl2 = false;
                        } else {
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Object object = new String[]{"."};
                            object = StringsKt.split$default((CharSequence)domainName2, (String[])object, (boolean)false, (int)0, (int)6, null);
                            Iterable iterable = list;
                            boolean $i$f$map2 = false;
                            void var25_36 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void p0;
                                String string2 = (String)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl4 = false;
                                collection.add(Name.identifier((String)p0));
                            }
                            List list2 = CollectionsKt.zip((Iterable)iterable, (Iterable)((List)destination$iv$iv));
                            if (list2 == null) {
                                bl2 = false;
                            } else {
                                boolean bl5;
                                boolean bl6;
                                block22: {
                                    void $this$all$iv;
                                    Iterable $i$f$map2 = list2;
                                    boolean $i$f$all = false;
                                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                        bl6 = true;
                                    } else {
                                        for (Object element$iv2 : $this$all$iv) {
                                            Pair it = (Pair)element$iv2;
                                            boolean bl7 = false;
                                            if (Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond())) continue;
                                            bl6 = false;
                                            break block22;
                                        }
                                        bl6 = true;
                                    }
                                }
                                bl2 = bl5 = bl6;
                            }
                        }
                    }
                }
                if (bl2) {
                    first$iv2.add(element$iv);
                    continue;
                }
                second$iv2.add(element$iv);
            }
            pair = new Pair(first$iv2, second$iv2);
        }
        second$iv = pair;
        Pair pair3 = second$iv == null ? new Pair((Object)CollectionsKt.emptyList(), (Object)notAndroid) : second$iv;
        List ownDomain = (List)pair3.component1();
        List tmp = (List)pair3.component2();
        Iterable $this$partition$iv3 = tmp;
        boolean $i$f$partition3 = false;
        ArrayList first$iv3 = new ArrayList();
        ArrayList second$iv3 = new ArrayList();
        for (Object element$iv : $this$partition$iv3) {
            KtImportDirective it = (KtImportDirective)element$iv;
            boolean bl = false;
            if (!this.isStandard(it, StandardPlatforms.JAVA) && !this.isStandard(it, StandardPlatforms.KOTLIN)) {
                first$iv3.add(element$iv);
                continue;
            }
            second$iv3.add(element$iv);
        }
        Pair pair4 = new Pair(first$iv3, second$iv3);
        List others = (List)pair4.component1();
        List javaAndKotlin = (List)pair4.component2();
        Iterable $this$partition$iv4 = javaAndKotlin;
        boolean $i$f$partition4 = false;
        ArrayList first$iv4 = new ArrayList();
        ArrayList second$iv4 = new ArrayList();
        for (Object element$iv : $this$partition$iv4) {
            KtImportDirective it = (KtImportDirective)element$iv;
            boolean bl = false;
            if (this.isStandard(it, StandardPlatforms.JAVA)) {
                first$iv4.add(element$iv);
                continue;
            }
            second$iv4.add(element$iv);
        }
        Pair pair5 = new Pair(first$iv4, second$iv4);
        List java = (List)pair5.component1();
        List kotlin = (List)pair5.component2();
        Object[] objectArray = new List[]{android, ownDomain, others, java, kotlin};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isStandard(KtImportDirective $this$isStandard, StandardPlatforms platformName) {
        boolean bl;
        List<List<Name>> list = this.standardImportsAsName.get((Object)platformName);
        if (list == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            block11: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl4;
                        block10: {
                            void $this$all$iv;
                            List list2;
                            List names2 = (List)element$iv;
                            boolean bl5 = false;
                            Iterable iterable = names2;
                            ImportPath importPath = $this$isStandard.getImportPath();
                            if (importPath == null) {
                                list2 = null;
                            } else {
                                FqName fqName = importPath.getFqName();
                                list2 = fqName == null ? null : fqName.pathSegments();
                            }
                            Iterable iterable2 = CollectionsKt.zip((Iterable)iterable, (Iterable)(list2 == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)list2));
                            boolean $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl4 = true;
                            } else {
                                for (Object element$iv2 : $this$all$iv) {
                                    Pair it = (Pair)element$iv2;
                                    boolean bl6 = false;
                                    if (Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond())) continue;
                                    bl4 = false;
                                    break block10;
                                }
                                bl4 = true;
                            }
                        }
                        if (!bl4) continue;
                        bl3 = true;
                        break block11;
                    }
                    bl3 = false;
                }
            }
            bl = bl2 = bl3;
        }
        return bl;
    }

    public static final /* synthetic */ Pair access$getSiblingBlocks(FileStructureRule $this, ASTNode $receiver, ASTNode copyrightComment, ASTNode headerKdoc, ASTNode fileAnnotations, ASTNode firstCodeNode, List otherNodesBeforeFirst) {
        return $this.getSiblingBlocks($receiver, copyrightComment, headerKdoc, fileAnnotations, firstCodeNode, otherNodesBeforeFirst);
    }

    public static final /* synthetic */ void access$rearrangeImports(FileStructureRule $this, ASTNode node, List imports, List sortedImportsGroups) {
        $this.rearrangeImports(node, imports, sortedImportsGroups);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/FileStructureRule$WildCardImportsConfig;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "allowedWildcards", "", "getAllowedWildcards", "()Ljava/util/List;", "diktat-rules"})
    public static final class WildCardImportsConfig
    extends RuleConfiguration {
        @NotNull
        private final List<String> allowedWildcards;

        /*
         * WARNING - void declaration
         */
        public WildCardImportsConfig(@NotNull Map<String, String> config2) {
            List list;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            WildCardImportsConfig wildCardImportsConfig = this;
            String string = config2.get("allowedWildcards");
            if (string == null) {
                list = null;
            } else {
                Object object = new String[]{","};
                List list2 = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
                if (list2 == null) {
                    list = null;
                } else {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    object = list2;
                    WildCardImportsConfig wildCardImportsConfig2 = wildCardImportsConfig;
                    boolean $i$f$map = false;
                    void var4_5 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                    }
                    list = (List)destination$iv$iv;
                    wildCardImportsConfig = wildCardImportsConfig2;
                }
            }
            List list3 = list;
            if (list == null) {
                list3 = CollectionsKt.emptyList();
            }
            wildCardImportsConfig.allowedWildcards = list3;
        }

        @NotNull
        public final List<String> getAllowedWildcards() {
            return this.allowedWildcards;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/FileStructureRule$ImportsGroupingConfig;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "useRecommendedImportsOrder", "", "getUseRecommendedImportsOrder", "()Z", "diktat-rules"})
    public static final class ImportsGroupingConfig
    extends RuleConfiguration {
        private final boolean useRecommendedImportsOrder;

        public ImportsGroupingConfig(@NotNull Map<String, String> config2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("useRecommendedImportsOrder");
            this.useRecommendedImportsOrder = string == null ? true : (bl = Boolean.parseBoolean(string));
        }

        public final boolean getUseRecommendedImportsOrder() {
            return this.useRecommendedImportsOrder;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/FileStructureRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

