/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3.files;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter3.files.IndentationError;
import org.cqfn.diktat.ruleset.rules.chapter3.files.IndentationRule;
import org.cqfn.diktat.ruleset.rules.chapter3.files.IndentationRuleKt;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.indentation.CheckResult;
import org.cqfn.diktat.ruleset.utils.indentation.CustomIndentationChecker;
import org.cqfn.diktat.ruleset.utils.indentation.IndentationConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J \u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0002J\u0014\u0010%\u001a\n &*\u0004\u0018\u00010\u00130\u0013*\u00020\u0013H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;", "configuration$delegate", "Lkotlin/Lazy;", "customIndentationCheckers", "Lorg/cqfn/diktat/ruleset/utils/indentation/CustomIndentationChecker;", "filePath", "", "checkIndentation", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkIsIndentedWithSpaces", "", "checkNewlineAtEnd", "checkStringLiteral", "whiteSpace", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiWhiteSpace;", "expectedIndent", "", "actualIndent", "fixFirstTemplateEntries", "textIndent", "fixStringLiteral", "logic", "visitWhiteSpace", "astNode", "context", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$IndentContext;", "getExceptionalIndentInitiator", "kotlin.jvm.PlatformType", "Companion", "IndentContext", "diktat-rules"})
public final class IndentationRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configuration$delegate;
    private String filePath;
    private List<? extends CustomIndentationChecker> customIndentationCheckers;
    private static final Logger log = LoggerFactory.getLogger(IndentationRule.class);
    public static final int INDENT_SIZE = 4;
    @NotNull
    public static final String NAME_ID = "act-indentation";
    @NotNull
    private static final List<IElementType> increasingTokens;
    @NotNull
    private static final List<IElementType> decreasingTokens;
    @NotNull
    private static final List<Pair<IElementType, IElementType>> matchingTokens;
    @NotNull
    private static final List<IElementType> stringLiteralTokens;

    public IndentationRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.WRONG_INDENTATION)), SetsKt.setOf((Object)new Rule.VisitorModifier.RunAfterRule("diktat-ruleset:acs-horizontal-whitespace", false, false, 6, null)));
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IndentationConfig>(configRules){
            final /* synthetic */ List<RulesConfig> $configRules;
            {
                this.$configRules = $configRules;
                super(0);
            }

            @NotNull
            public final IndentationConfig invoke() {
                RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.$configRules, (Rule)Warnings.WRONG_INDENTATION);
                Map<K, V> map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return new IndentationConfig(map);
            }
        }));
    }

    private final IndentationConfig getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (IndentationConfig)((Object)lazy.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            this.filePath = AstNodeUtilsKt.getFilePath(node);
            Object object = new KFunction[]{(KFunction)logic.1.INSTANCE, (KFunction)logic.2.INSTANCE, (KFunction)logic.3.INSTANCE, (KFunction)logic.4.INSTANCE, (KFunction)logic.5.INSTANCE, (KFunction)logic.6.INSTANCE, (KFunction)logic.7.INSTANCE, (KFunction)logic.8.INSTANCE, (KFunction)logic.9.INSTANCE};
            object = CollectionsKt.listOf((Object[])object);
            IndentationRule indentationRule = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KFunction kFunction = (KFunction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((CustomIndentationChecker)((Function1)it).invoke((Object)this.getConfiguration()));
            }
            indentationRule.customIndentationCheckers = (List)destination$iv$iv;
            if (this.checkIsIndentedWithSpaces(node)) {
                this.checkIndentation(node);
            } else {
                log.warn("Not going to check indentation because there are tabs");
            }
            this.checkNewlineAtEnd(node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkIsIndentedWithSpaces(ASTNode node) {
        void $this$filterTo$iv$iv;
        List whiteSpaceNodes = new ArrayList();
        AstNodeUtilsKt.getAllLeafsWithSpecificType(node, ElementType.INSTANCE.getWHITE_SPACE(), whiteSpaceNodes);
        Iterable $this$filter$iv = whiteSpaceNodes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!it.textContains('\t')) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$checkIsIndentedWithSpaces_u24lambda_u2d2 = $this$filter$iv = (List)destination$iv$iv;
        boolean bl = false;
        if ($this$checkIsIndentedWithSpaces_u24lambda_u2d2.isEmpty()) {
            return true;
        }
        Iterable $this$forEach$iv = $this$filter$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl2 = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl3 = this.isFixMode();
            int n = it.getStartOffset();
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            Warnings.warnAndFix$default(Warnings.WRONG_INDENTATION, list, function3, bl3, "tabs are not allowed for indentation", n + StringsKt.indexOf$default((CharSequence)string, (char)'\t', (int)0, (boolean)false, (int)6, null), it, false, (Function0)new Function0<Unit>(it, this){
                final /* synthetic */ ASTNode $it;
                final /* synthetic */ IndentationRule this$0;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    LeafPsiElement leafPsiElement = (LeafPsiElement)this.$it;
                    String string = ((LeafPsiElement)this.$it).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                    leafPsiElement.rawReplaceWithText(StringsKt.replace$default((String)string, (String)"\t", (String)StringsKt.repeat((CharSequence)" ", (int)IndentationRule.access$getConfiguration(this.this$0).getIndentationSize()), (boolean)false, (int)4, null));
                }
            }, 64, null);
        }
        return this.isFixMode();
    }

    private final void checkNewlineAtEnd(ASTNode node) {
        if (this.getConfiguration().getNewlineAtEnd()) {
            ASTNode lastChild2 = (ASTNode)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)node, (Function1)checkNewlineAtEnd.lastChild.1.INSTANCE));
            String string = lastChild2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lastChild.text");
            CharSequence $this$count$iv = string;
            boolean $i$f$count = false;
            int count$iv2 = 0;
            CharSequence charSequence = $this$count$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv2;
            }
            int numBlankLinesAfter = count$iv2;
            if (!Intrinsics.areEqual((Object)lastChild2.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || numBlankLinesAfter != 1) {
                String warnText = !Intrinsics.areEqual((Object)lastChild2.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) || numBlankLinesAfter == 0 ? "no newline" : "too many blank lines";
                String string2 = this.filePath;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"filePath");
                    string2 = null;
                }
                String count$iv2 = File.Companion.getSeparator();
                Intrinsics.checkNotNullExpressionValue((Object)count$iv2, (String)"File.separator");
                String fileName = StringsKt.substringAfterLast$default((String)string2, (String)count$iv2, null, (int)2, null);
                int offset2 = Intrinsics.areEqual((Object)lastChild2.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && lastChild2.textContains('\n') ? node.getTextLength() : node.getTextLength() - 1;
                Warnings.warnAndFix$default(Warnings.WRONG_INDENTATION, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), warnText + " at the end of file " + fileName, offset2, node, false, (Function0)new Function0<Unit>(lastChild2, node){
                    final /* synthetic */ ASTNode $lastChild;
                    final /* synthetic */ ASTNode $node;
                    {
                        this.$lastChild = $lastChild;
                        this.$node = $node;
                        super(0);
                    }

                    public final void invoke() {
                        if (!Intrinsics.areEqual((Object)this.$lastChild.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                            this.$node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), null);
                        } else {
                            AstNodeUtilsKt.leaveOnlyOneNewLine(this.$lastChild);
                        }
                    }
                }, 64, null);
            }
        }
    }

    private final void checkIndentation(ASTNode node) {
        IndentContext context = new IndentContext(this.getConfiguration());
        PackageKt.visit((ASTNode)node, (Function1)((Function1)new Function1<ASTNode, Unit>(context, this){
            final /* synthetic */ IndentContext $context;
            final /* synthetic */ IndentationRule this$0;
            {
                this.$context = $context;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final void invoke(@NotNull ASTNode astNode) {
                Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
                this.$context.checkAndReset(astNode);
                if (IndentationRule.access$getIncreasingTokens$cp().contains(astNode.getElementType())) {
                    IElementType iElementType = astNode.getElementType();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"astNode.elementType");
                    this.$context.storeIncrementingToken(iElementType);
                    return;
                }
                if (IndentationRule.access$getDecreasingTokens$cp().contains(astNode.getElementType())) {
                    ASTNode it = astNode.getTreePrev();
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && it.textContains('\n'))) {
                        IElementType iElementType = astNode.getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"astNode.elementType");
                        this.$context.dec(iElementType);
                        return;
                    }
                }
                if (!Intrinsics.areEqual((Object)astNode.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) return;
                if (!astNode.textContains('\n')) return;
                if (astNode.getTreeNext() == null) return;
                IndentationRule.access$visitWhiteSpace(this.this$0, astNode, this.$context);
            }
        }));
    }

    private final void visitWhiteSpace(ASTNode astNode, IndentContext context) {
        Object object;
        CheckResult checkResult;
        CheckResult checkResult2;
        IndentationError indentError;
        PsiWhiteSpace whiteSpace;
        block9: {
            context.maybeIncrement();
            PsiElement psiElement = astNode.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace");
            }
            whiteSpace = (PsiWhiteSpace)psiElement;
            if (decreasingTokens.contains(astNode.getTreeNext().getElementType())) {
                IElementType iElementType = astNode.getTreeNext().getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"astNode.treeNext.elementType");
                context.dec(iElementType);
            }
            int n = context.indent();
            String string = astNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"astNode.text");
            indentError = new IndentationError(n, IndentationRuleKt.lastIndent(string));
            List<? extends CustomIndentationChecker> list = this.customIndentationCheckers;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customIndentationCheckers");
                list = null;
            }
            for (CustomIndentationChecker it : (Iterable)list) {
                boolean bl = false;
                CheckResult checkResult3 = it.checkNode(whiteSpace, indentError);
                if (checkResult3 == null) continue;
                checkResult2 = checkResult3;
                break block9;
            }
            checkResult2 = null;
        }
        CheckResult checkResult4 = checkResult = checkResult2;
        Integer n = checkResult4 == null ? null : Integer.valueOf(checkResult4.getExpectedIndent());
        int expectedIndent2 = n == null ? indentError.getExpected() : n.intValue();
        CheckResult checkResult5 = checkResult;
        if (checkResult5 == null ? false : checkResult5.getAdjustNext()) {
            boolean bl;
            block10: {
                Sequence $this$none$iv = PsiUtilsKt.parents((ASTNode)astNode);
                boolean $i$f$none = false;
                for (Object element$iv : $this$none$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY())) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
            if (bl) {
                ASTNode exceptionInitiatorNode = this.getExceptionalIndentInitiator(astNode);
                Intrinsics.checkNotNullExpressionValue((Object)exceptionInitiatorNode, (String)"exceptionInitiatorNode");
                context.addException(exceptionInitiatorNode, expectedIndent2 - indentError.getExpected(), checkResult.getIncludeLastChild());
            }
        }
        if (Intrinsics.areEqual((Object)astNode.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY()) && indentError.getExpected() != indentError.getActual()) {
            object = astNode.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"astNode.treeParent");
            context.addException((ASTNode)object, Math.abs(indentError.getExpected() - indentError.getActual()), false);
        }
        CheckResult checkResult6 = checkResult;
        if (!(checkResult6 == null ? false : checkResult6.isCorrect()) && expectedIndent2 != indentError.getActual()) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            String string = "expected " + expectedIndent2 + " but was " + indentError.getActual();
            int n2 = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)whiteSpace));
            object = whiteSpace.getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"whiteSpace.text");
            int n3 = n2 + StringsKt.lastIndexOf$default((CharSequence)((CharSequence)object), (char)'\n', (int)0, (boolean)false, (int)6, null) + 1;
            object = whiteSpace.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"whiteSpace.node");
            Warnings.warnAndFix$default(Warnings.WRONG_INDENTATION, list, function3, bl, string, n3, object, false, (Function0)new Function0<Unit>(this, whiteSpace, expectedIndent2, indentError){
                final /* synthetic */ IndentationRule this$0;
                final /* synthetic */ PsiWhiteSpace $whiteSpace;
                final /* synthetic */ int $expectedIndent;
                final /* synthetic */ IndentationError $indentError;
                {
                    this.this$0 = $receiver;
                    this.$whiteSpace = $whiteSpace;
                    this.$expectedIndent = $expectedIndent;
                    this.$indentError = $indentError;
                    super(0);
                }

                public final void invoke() {
                    IndentationRule.access$checkStringLiteral(this.this$0, this.$whiteSpace, this.$expectedIndent, this.$indentError.getActual());
                    ASTNode aSTNode = this.$whiteSpace.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"whiteSpace.node");
                    AstNodeUtilsKt.indentBy(aSTNode, this.$expectedIndent);
                }
            }, 64, null);
        }
    }

    private final void checkStringLiteral(PsiWhiteSpace whiteSpace, int expectedIndent2, int actualIndent) {
        ASTNode nextNode2 = whiteSpace.getNode().getTreeNext();
        if (nextNode2 != null && Intrinsics.areEqual((Object)nextNode2.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION()) && Intrinsics.areEqual((Object)nextNode2.getFirstChildNode().getElementType(), (Object)ElementType.INSTANCE.getSTRING_TEMPLATE())) {
            String string = nextNode2.getFirstChildNode().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextNode.firstChildNode.text");
            if (StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
                boolean bl;
                ASTNode aSTNode = nextNode2.findChildByType(ElementType.INSTANCE.getCALL_EXPRESSION());
                if (aSTNode == null) {
                    bl = false;
                } else {
                    String string2 = aSTNode.getText();
                    if (string2 == null) {
                        bl = false;
                    } else {
                        String it = string2;
                        boolean bl2 = false;
                        bl = Intrinsics.areEqual((Object)it, (Object)"trimIndent()") || Intrinsics.areEqual((Object)it, (Object)"trimMargin()");
                    }
                }
                if (bl) {
                    this.fixStringLiteral(whiteSpace, expectedIndent2, actualIndent);
                }
            }
        }
    }

    private final void fixStringLiteral(PsiWhiteSpace whiteSpace, int expectedIndent2, int actualIndent) {
        String textIndent = StringsKt.repeat((CharSequence)" ", (int)(expectedIndent2 + 4));
        Object object = whiteSpace.getNode().getTreeNext().getFirstChildNode();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"whiteSpace.node.treeNext.firstChildNode");
        List<ASTNode> templateEntries = AstNodeUtilsKt.getAllChildrenWithType(object, ElementType.INSTANCE.getLITERAL_STRING_TEMPLATE_ENTRY());
        Iterable $this$forEach$iv = templateEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode node = (ASTNode)element$iv;
            boolean bl = false;
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) continue;
            this.fixFirstTemplateEntries(node, textIndent, actualIndent);
        }
        ASTNode aSTNode = ((ASTNode)CollectionsKt.last(templateEntries)).getFirstChildNode();
        if (aSTNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        }
        LeafPsiElement leafPsiElement = (LeafPsiElement)aSTNode;
        String string = StringsKt.repeat((CharSequence)" ", (int)expectedIndent2);
        object = ((ASTNode)CollectionsKt.last(templateEntries)).getFirstChildNode().getText();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"templateEntries\n        \u2026ode\n                .text");
        leafPsiElement.rawReplaceWithText(Intrinsics.stringPlus((String)string, (Object)((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString()));
    }

    private final void fixFirstTemplateEntries(ASTNode node, String textIndent, int actualIndent) {
        int n;
        String string;
        String string2;
        int index$iv;
        int n2;
        int n3;
        boolean $i$f$takeWhile;
        String $this$takeWhile$iv;
        StringBuilder correctedText;
        block14: {
            correctedText = new StringBuilder();
            String string3 = node.getFirstChildNode().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"node.firstChildNode.text");
            $this$takeWhile$iv = string3;
            $i$f$takeWhile = false;
            n3 = 0;
            n2 = $this$takeWhile$iv.length();
            while (n3 < n2) {
                index$iv = n3++;
                char it22 = $this$takeWhile$iv.charAt(index$iv);
                int n4 = 0;
                if (it22 == ' ') continue;
                String it22 = $this$takeWhile$iv;
                n4 = 0;
                string2 = it22.substring(n4, index$iv);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string = string2;
                break block14;
            }
            string = $this$takeWhile$iv;
        }
        if (((CharSequence)string).length() - actualIndent - 4 > 0) {
            String string4;
            block15: {
                $this$takeWhile$iv = node.getFirstChildNode().getText();
                Intrinsics.checkNotNullExpressionValue((Object)$this$takeWhile$iv, (String)"node.firstChildNode.text");
                $i$f$takeWhile = false;
                n3 = 0;
                n2 = $this$takeWhile$iv.length();
                while (n3 < n2) {
                    index$iv = n3++;
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (it == ' ') continue;
                    String string5 = $this$takeWhile$iv;
                    int n5 = 0;
                    string2 = string5.substring(n5, index$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    string4 = string2;
                    break block15;
                }
                string4 = $this$takeWhile$iv;
            }
            n = ((CharSequence)string4).length() - actualIndent - 4;
        } else {
            n = 0;
        }
        int nodeStartIndent = n;
        boolean isPrevStringTemplate = stringLiteralTokens.contains(node.getTreePrev().getElementType());
        boolean isNextStringTemplate = stringLiteralTokens.contains(node.getTreeNext().getElementType());
        if (isPrevStringTemplate && !isNextStringTemplate) {
            String string6 = node.getFirstChildNode().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"node.firstChildNode.text");
            correctedText.append(((Object)StringsKt.trimEnd((CharSequence)string6)).toString());
        } else if (!isPrevStringTemplate && isNextStringTemplate) {
            StringBuilder stringBuilder = new StringBuilder().append(textIndent).append(StringsKt.repeat((CharSequence)" ", (int)nodeStartIndent));
            String string7 = node.getFirstChildNode().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"node.firstChildNode.text");
            correctedText.append(stringBuilder.append(((Object)StringsKt.trimStart((CharSequence)string7)).toString()).toString());
        } else if (!isPrevStringTemplate && !isNextStringTemplate) {
            StringBuilder stringBuilder = new StringBuilder().append(textIndent).append(StringsKt.repeat((CharSequence)" ", (int)nodeStartIndent));
            String string8 = node.getFirstChildNode().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"node.firstChildNode.text");
            correctedText.append(stringBuilder.append(((Object)StringsKt.trim((CharSequence)string8)).toString()).toString());
        } else if (isPrevStringTemplate && isNextStringTemplate) {
            correctedText.append(node.getFirstChildNode().getText());
        } else {
            String string9 = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"node.text");
            if (StringsKt.isBlank((CharSequence)string9)) {
                correctedText.append(textIndent);
            }
        }
        ASTNode aSTNode = node.getFirstChildNode();
        if (aSTNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        }
        ((LeafPsiElement)aSTNode).rawReplaceWithText(correctedText.toString());
    }

    private final ASTNode getExceptionalIndentInitiator(ASTNode $this$getExceptionalIndentInitiator) {
        ASTNode aSTNode;
        ASTNode parent = $this$getExceptionalIndentInitiator.getTreeParent();
        boolean bl = false;
        PsiElement psiElement = parent.getPsi();
        if (psiElement instanceof KtDotQualifiedExpression) {
            aSTNode = (ASTNode)SequencesKt.last((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.parents((ASTNode)$this$getExceptionalIndentInitiator), (Function1)getExceptionalIndentInitiator.1.1.INSTANCE));
        } else if (psiElement instanceof KtIfExpression) {
            aSTNode = parent.findChildByType(ElementType.INSTANCE.getTHEN());
            if (aSTNode == null && (aSTNode = parent.findChildByType(ElementType.INSTANCE.getELSE())) == null) {
                aSTNode = parent;
            }
        } else if (psiElement instanceof KtLoopExpression) {
            PsiElement psiElement2 = parent.getPsi();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLoopExpression");
            }
            KtExpression ktExpression = ((KtLoopExpression)psiElement2).getBody();
            if (ktExpression == null) {
                aSTNode = parent;
            } else {
                aSTNode = ktExpression.getNode();
                if (aSTNode == null) {
                    aSTNode = parent;
                }
            }
        } else {
            aSTNode = parent;
        }
        return aSTNode;
    }

    public static final /* synthetic */ List access$getDecreasingTokens$cp() {
        return decreasingTokens;
    }

    public static final /* synthetic */ void access$visitWhiteSpace(IndentationRule $this, ASTNode astNode, IndentContext context) {
        $this.visitWhiteSpace(astNode, context);
    }

    public static final /* synthetic */ void access$checkStringLiteral(IndentationRule $this, PsiWhiteSpace whiteSpace, int expectedIndent2, int actualIndent) {
        $this.checkStringLiteral(whiteSpace, expectedIndent2, actualIndent);
    }

    public static final /* synthetic */ IndentationConfig access$getConfiguration(IndentationRule $this) {
        return $this.getConfiguration();
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getLPAR(), ElementType.INSTANCE.getLBRACE(), ElementType.INSTANCE.getLBRACKET(), ElementType.INSTANCE.getLONG_TEMPLATE_ENTRY_START()};
        increasingTokens = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new IElementType[]{ElementType.INSTANCE.getRPAR(), ElementType.INSTANCE.getRBRACE(), ElementType.INSTANCE.getRBRACKET(), ElementType.INSTANCE.getLONG_TEMPLATE_ENTRY_END()};
        decreasingTokens = CollectionsKt.listOf((Object[])objectArray);
        matchingTokens = CollectionsKt.zip((Iterable)increasingTokens, (Iterable)decreasingTokens);
        objectArray = new IElementType[]{ElementType.INSTANCE.getSHORT_STRING_TEMPLATE_ENTRY(), ElementType.INSTANCE.getLONG_STRING_TEMPLATE_ENTRY()};
        stringLiteralTokens = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0018\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$IndentContext;", "", "config", "Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;", "(Lorg/cqfn/diktat/ruleset/utils/indentation/IndentationConfig;)V", "activeTokens", "Lorg/jetbrains/kotlin/com/intellij/util/containers/Stack;", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "exceptionalIndents", "", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$IndentContext$ExceptionalIndent;", "regularIndent", "", "addException", "", "initiator", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "indent", "includeLastChild", "checkAndReset", "astNode", "dec", "", "token", "maybeIncrement", "storeIncrementingToken", "ExceptionalIndent", "diktat-rules"})
    private static final class IndentContext {
        @NotNull
        private final IndentationConfig config;
        private int regularIndent;
        @NotNull
        private final List<ExceptionalIndent> exceptionalIndents;
        @NotNull
        private final Stack<IElementType> activeTokens;

        public IndentContext(@NotNull IndentationConfig config2) {
            Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
            this.config = config2;
            this.exceptionalIndents = new ArrayList();
            this.activeTokens = new Stack();
        }

        public final void storeIncrementingToken(@NotNull IElementType token) {
            IElementType iElementType;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            IElementType it = iElementType = token;
            boolean bl = false;
            if (!increasingTokens.contains(it)) {
                boolean bl2 = false;
                String string = "Only tokens that increase indentation should be passed to this method";
                throw new IllegalArgumentException(string.toString());
            }
            Stack<IElementType> stack = this.activeTokens;
            IElementType p0 = iElementType;
            boolean bl3 = false;
            stack.push((Object)p0);
        }

        public final void maybeIncrement() {
            if (!((Collection)this.activeTokens).isEmpty() && !Intrinsics.areEqual((Object)this.activeTokens.peek(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                this.regularIndent += this.config.getIndentationSize();
                this.activeTokens.push((Object)ElementType.INSTANCE.getWHITE_SPACE());
            }
        }

        public final void dec(@NotNull IElementType token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            if (Intrinsics.areEqual((Object)this.activeTokens.peek(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                while (Intrinsics.areEqual((Object)this.activeTokens.peek(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                    this.activeTokens.pop();
                }
                this.regularIndent -= this.config.getIndentationSize();
            }
            if (!((Collection)this.activeTokens).isEmpty()) {
                Object v0;
                Object object;
                block5: {
                    Iterable iterable = matchingTokens;
                    object = this.activeTokens.peek();
                    for (Object t : iterable) {
                        Pair it = (Pair)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSecond(), (Object)token)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                Pair pair = v0;
                if (Intrinsics.areEqual((Object)object, (Object)(pair == null ? null : (IElementType)pair.getFirst()))) {
                    this.activeTokens.pop();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int indent() {
            int n;
            Iterable iterable = this.exceptionalIndents;
            int n2 = this.regularIndent;
            int n3 = 0;
            for (Object t : iterable) {
                void it;
                ExceptionalIndent exceptionalIndent = (ExceptionalIndent)t;
                n = n3;
                boolean bl = false;
                int n4 = it.getIndent();
                n3 = n + n4;
            }
            n = n3;
            return n2 + n;
        }

        public final boolean addException(@NotNull ASTNode initiator, int indent, boolean includeLastChild) {
            Intrinsics.checkNotNullParameter((Object)initiator, (String)"initiator");
            return this.exceptionalIndents.add(new ExceptionalIndent(initiator, indent, includeLastChild));
        }

        public final boolean checkAndReset(@NotNull ASTNode astNode) {
            Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
            return CollectionsKt.retainAll(this.exceptionalIndents, (Function1)((Function1)new Function1<ExceptionalIndent, Boolean>(astNode){
                final /* synthetic */ ASTNode $astNode;
                {
                    this.$astNode = $astNode;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ExceptionalIndent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return it.isActive(this.$astNode);
                }
            }));
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$IndentContext$ExceptionalIndent;", "", "initiator", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "indent", "", "includeLastChild", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;IZ)V", "getIncludeLastChild", "()Z", "getIndent", "()I", "getInitiator", "()Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "isActive", "currentNode", "toString", "", "diktat-rules"})
        private static final class ExceptionalIndent {
            @NotNull
            private final ASTNode initiator;
            private final int indent;
            private final boolean includeLastChild;

            public ExceptionalIndent(@NotNull ASTNode initiator, int indent, boolean includeLastChild) {
                Intrinsics.checkNotNullParameter((Object)initiator, (String)"initiator");
                this.initiator = initiator;
                this.indent = indent;
                this.includeLastChild = includeLastChild;
            }

            public /* synthetic */ ExceptionalIndent(ASTNode aSTNode, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n2 & 4) != 0) {
                    bl = true;
                }
                this(aSTNode, n, bl);
            }

            @NotNull
            public final ASTNode getInitiator() {
                return this.initiator;
            }

            public final int getIndent() {
                return this.indent;
            }

            public final boolean getIncludeLastChild() {
                return this.includeLastChild;
            }

            public final boolean isActive(@NotNull ASTNode currentNode) {
                boolean bl;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)currentNode, (String)"currentNode");
                    PsiElement psiElement = currentNode.getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"currentNode.psi");
                    Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)psiElement);
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getNode(), (Object)this.getInitiator())) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl && (this.includeLastChild || !Intrinsics.areEqual((Object)currentNode.getTreeNext(), (Object)this.initiator.getLastChildNode()));
            }

            @NotNull
            public final ASTNode component1() {
                return this.initiator;
            }

            public final int component2() {
                return this.indent;
            }

            public final boolean component3() {
                return this.includeLastChild;
            }

            @NotNull
            public final ExceptionalIndent copy(@NotNull ASTNode initiator, int indent, boolean includeLastChild) {
                Intrinsics.checkNotNullParameter((Object)initiator, (String)"initiator");
                return new ExceptionalIndent(initiator, indent, includeLastChild);
            }

            public static /* synthetic */ ExceptionalIndent copy$default(ExceptionalIndent exceptionalIndent, ASTNode aSTNode, int n, boolean bl, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    aSTNode = exceptionalIndent.initiator;
                }
                if ((n2 & 2) != 0) {
                    n = exceptionalIndent.indent;
                }
                if ((n2 & 4) != 0) {
                    bl = exceptionalIndent.includeLastChild;
                }
                return exceptionalIndent.copy(aSTNode, n, bl);
            }

            @NotNull
            public String toString() {
                return "ExceptionalIndent(initiator=" + this.initiator + ", indent=" + this.indent + ", includeLastChild=" + this.includeLastChild + ')';
            }

            public int hashCode() {
                int result = this.initiator.hashCode();
                result = result * 31 + Integer.hashCode(this.indent);
                int n = this.includeLastChild ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result = result * 31 + n;
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ExceptionalIndent)) {
                    return false;
                }
                ExceptionalIndent exceptionalIndent = (ExceptionalIndent)other;
                if (!Intrinsics.areEqual((Object)this.initiator, (Object)exceptionalIndent.initiator)) {
                    return false;
                }
                if (this.indent != exceptionalIndent.indent) {
                    return false;
                }
                return this.includeLastChild == exceptionalIndent.includeLastChild;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/IndentationRule$Companion;", "", "()V", "INDENT_SIZE", "", "NAME_ID", "", "decreasingTokens", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "increasingTokens", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "matchingTokens", "Lkotlin/Pair;", "stringLiteralTokens", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

