/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3.files;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter3.files.NewlinesRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.FileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 ?2\u00020\u0001:\u0002?@B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J'\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001f\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0003*\u00020&2\b\b\u0002\u0010'\u001a\u00020#H\u0002J\u001e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0003*\u00020\u000f2\b\b\u0002\u0010)\u001a\u00020#H\u0002J\"\u0010*\u001a\u00020\r*\u00020\u000f2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0.H\u0002J\u0012\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f00*\u00020\u000fH\u0002J\u0013\u00101\u001a\t\u0018\u00010\u0016\u00a2\u0006\u0002\b2*\u00020\u000fH\u0002J\f\u00103\u001a\u00020#*\u00020\u000fH\u0002J\f\u00104\u001a\u00020#*\u00020\u000fH\u0002J\f\u00105\u001a\u00020#*\u00020\u000fH\u0002J\u0014\u00106\u001a\u00020#*\u00020,2\u0006\u00107\u001a\u00020\u0014H\u0002J\f\u00108\u001a\u00020#*\u00020\u000fH\u0002J\f\u00109\u001a\u00020#*\u00020\u000fH\u0002J\u0016\u0010:\u001a\u00020#*\u00020\u000f2\b\b\u0002\u0010)\u001a\u00020#H\u0002J\f\u0010;\u001a\u00020#*\u00020\u000fH\u0002J\u001a\u0010<\u001a\u00020#*\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010=\u001a\u00020#*\u00020\u000fH\u0002J\f\u0010>\u001a\u00020\u000f*\u00020\u000fH\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006A"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/NewlinesRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter3/files/NewlinesRule$NewlinesRuleConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/chapter3/files/NewlinesRule$NewlinesRuleConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "checkForComplexExpression", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleColon", "handleComma", "handleFirstValue", "filterType", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "warnText", "", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;Ljava/lang/String;)Lkotlin/Unit;", "handleLambdaBody", "handleList", "handleOpeningParentheses", "handleOperatorWithLineBreakAfter", "handleOperatorWithLineBreakBefore", "handleReturnStatement", "handleSemicolon", "handleValueParameterList", "entryType", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Ljava/lang/String;)Lkotlin/Unit;", "isMultilineLambda", "", "logic", "dotCalls", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "right", "getCallChain", "dropLeadingProperties", "getOrderedCallExpressions", "psi", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "result", "", "getParentExpressions", "Lkotlin/sequences/Sequence;", "getParentIdentifier", "Lorg/jetbrains/annotations/NotNull;", "isDotFromPackageOrImport", "isElvisCorrect", "isFirstCall", "isFirstChildElementType", "elementType", "isInParentheses", "isInfixCall", "isInvalidCallsChain", "isNewLineNode", "isNotValidCalls", "isSingleDotStatementOnSingleLine", "selfOrOperationReferenceParent", "Companion", "NewlinesRuleConfiguration", "diktat-rules"})
public final class NewlinesRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configuration$delegate;
    private static final Logger log = LoggerFactory.getLogger(NewlinesRule.class);
    public static final int MAX_CALLS_IN_ONE_LINE = 3;
    @NotNull
    public static final String NAME_ID = "acr-newlines";
    @NotNull
    private static final TokenSet lineBreakAfterOperators;
    @NotNull
    private static final TokenSet lineBreakBeforeOperators;
    @NotNull
    private static final TokenSet expressionTypes;
    @NotNull
    private static final TokenSet chainExpressionTypes;
    @NotNull
    private static final TokenSet dropChainValues;
    @NotNull
    private static final TokenSet parenthesesTypes;

    public NewlinesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        Warnings[] warningsArray = new Warnings[]{Warnings.COMPLEX_EXPRESSION, Warnings.REDUNDANT_SEMICOLON, Warnings.WRONG_NEWLINES};
        super(NAME_ID, configRules, CollectionsKt.listOf((Object[])warningsArray), SetsKt.setOf((Object)new Rule.VisitorModifier.RunAfterRule("diktat-ruleset:acq-file-structure", false, false, 6, null)));
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NewlinesRuleConfiguration>(configRules){
            final /* synthetic */ List<RulesConfig> $configRules;
            {
                this.$configRules = $configRules;
                super(0);
            }

            @NotNull
            public final NewlinesRuleConfiguration invoke() {
                RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.$configRules, (Rule)Warnings.WRONG_NEWLINES);
                Map<K, V> map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return new NewlinesRuleConfiguration(map);
            }
        }));
    }

    private final NewlinesRuleConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (NewlinesRuleConfiguration)((Object)lazy.getValue());
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSEMICOLON())) {
            this.handleSemicolon(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getOPERATION_REFERENCE()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEQ())) {
            this.handleOperatorWithLineBreakAfter(node);
        } else if (lineBreakBeforeOperators.contains(iElementType)) {
            this.handleOperatorWithLineBreakBefore(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            this.handleOpeningParentheses(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCOMMA())) {
            this.handleComma(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCOLON())) {
            this.handleColon(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getBLOCK())) {
            this.handleLambdaBody(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRETURN())) {
            this.handleReturnStatement(node);
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSUPER_TYPE_LIST()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST())) {
            this.handleList(node);
        }
    }

    private final void handleSemicolon(ASTNode node) {
        if (AstNodeUtilsKt.isEol(node) && !Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getENUM_ENTRY())) {
            Warnings.warnAndFix$default(Warnings.REDUNDANT_SEMICOLON, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), AstNodeUtilsKt.extractLineOfText(node), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    this.$node.getTreeParent().removeChild(this.$node);
                }
            }, 64, null);
        }
    }

    private final void handleOperatorWithLineBreakAfter(ASTNode node) {
        if (!(Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getEQ()) || lineBreakAfterOperators.contains(node.getFirstChildNode().getElementType()) || this.isInfixCall(node))) {
            return;
        }
        ASTNode aSTNode = PackageKt.prevCodeSibling((ASTNode)node);
        if (aSTNode == null ? false : AstNodeUtilsKt.isFollowedByNewline(aSTNode)) {
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)"should break a line after and not before ", (Object)node.getText()), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    ASTNode $this$invoke_u24lambda_u2d1 = this.$node;
                    boolean bl = false;
                    $this$invoke_u24lambda_u2d1.getTreeParent().removeChild($this$invoke_u24lambda_u2d1.getTreePrev());
                    if (!AstNodeUtilsKt.isFollowedByNewline($this$invoke_u24lambda_u2d1)) {
                        void it;
                        ASTNode aSTNode = $this$invoke_u24lambda_u2d1.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"treeParent");
                        ASTNode aSTNode2 = aSTNode;
                        ASTNode aSTNode3 = aSTNode = $this$invoke_u24lambda_u2d1.getTreeNext();
                        ASTNode aSTNode4 = aSTNode2;
                        boolean bl2 = false;
                        boolean bl3 = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE());
                        AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode4, (ASTNode)(bl3 ? aSTNode : null), $this$invoke_u24lambda_u2d1.getTreeNext());
                    }
                }
            }, 64, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleOperatorWithLineBreakBefore(ASTNode node) {
        block7: {
            block6: {
                if (this.isDotFromPackageOrImport(node)) {
                    return;
                }
                $this$handleOperatorWithLineBreakBefore_u24lambda_u2d0 = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getELVIS()) != false ? node.getTreeParent() : node;
                $i$a$-run-NewlinesRule$handleOperatorWithLineBreakBefore$isIncorrect$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$handleOperatorWithLineBreakBefore_u24lambda_u2d0, (String)"");
                if (!this.isInvalidCallsChain($this$handleOperatorWithLineBreakBefore_u24lambda_u2d0, true)) break block6;
                if (this.isInParentheses(node)) {
                    this.checkForComplexExpression(node);
                }
                v0 = PackageKt.parent((ASTNode)$this$handleOperatorWithLineBreakBefore_u24lambda_u2d0, (Function1)handleOperatorWithLineBreakBefore.isIncorrect.1.isSingleLineIfElse.1.INSTANCE, (boolean)true);
                v1 = isSingleLineIfElse = v0 == null ? false : (var7_4 = AstNodeUtilsKt.isSingleLineIfElse(v0));
                if (!AstNodeUtilsKt.isFollowedByNewline($this$handleOperatorWithLineBreakBefore_u24lambda_u2d0) && AstNodeUtilsKt.isBeginByNewline($this$handleOperatorWithLineBreakBefore_u24lambda_u2d0) || isSingleLineIfElse) ** GOTO lbl-1000
                if (!this.isFirstCall($this$handleOperatorWithLineBreakBefore_u24lambda_u2d0)) ** GOTO lbl-1000
                var6_6 = $this$handleOperatorWithLineBreakBefore_u24lambda_u2d0.getTreeParent();
                Intrinsics.checkNotNullExpressionValue((Object)var6_6, (String)"treeParent");
                if (!this.isMultilineLambda(var6_6)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                break block7;
            }
            if (this.isInvalidCallsChain($this$handleOperatorWithLineBreakBefore_u24lambda_u2d0, false) && this.isInParentheses(node)) {
                this.checkForComplexExpression(node);
            }
            v2 = AstNodeUtilsKt.isFollowedByNewline($this$handleOperatorWithLineBreakBefore_u24lambda_u2d0) && !this.isSingleDotStatementOnSingleLine($this$handleOperatorWithLineBreakBefore_u24lambda_u2d0);
        }
        if ((isIncorrect = v2) || this.isElvisCorrect(node)) {
            freeText = NewlinesRule.isInvalidCallsChain$default(this, node, false, 1, null) != false || this.isElvisCorrect(node) != false ? Intrinsics.stringPlus((String)"should follow functional style at ", (Object)node.getText()) : Intrinsics.stringPlus((String)"should break a line before and not after ", (Object)node.getText());
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node){
                final /* synthetic */ NewlinesRule this$0;
                final /* synthetic */ ASTNode $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    ASTNode $this$invoke_u24lambda_u2d2 = NewlinesRule.access$selfOrOperationReferenceParent(this.this$0, this.$node);
                    boolean bl = false;
                    if (!AstNodeUtilsKt.isBeginByNewline($this$invoke_u24lambda_u2d2)) {
                        void it;
                        ASTNode aSTNode = $this$invoke_u24lambda_u2d2.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"treeParent");
                        ASTNode aSTNode2 = aSTNode;
                        ASTNode aSTNode3 = aSTNode = $this$invoke_u24lambda_u2d2.getTreePrev();
                        ASTNode aSTNode4 = aSTNode2;
                        boolean bl2 = false;
                        boolean bl3 = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE());
                        AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode4, (ASTNode)(bl3 ? aSTNode : null), $this$invoke_u24lambda_u2d2);
                    }
                    if (AstNodeUtilsKt.isFollowedByNewline($this$invoke_u24lambda_u2d2)) {
                        ASTNode aSTNode = PackageKt.parent((ASTNode)$this$invoke_u24lambda_u2d2, (Function1)handleOperatorWithLineBreakBefore.1.2.INSTANCE, (boolean)false);
                        if (aSTNode != null) {
                            ASTNode it = aSTNode;
                            boolean bl4 = false;
                            it.getTreeParent().removeChild(it.getTreeNext());
                        }
                    }
                }
            }, 64, null);
        }
    }

    private final void checkForComplexExpression(ASTNode node) {
        if (FileUtilsKt.isGradleScript(AstNodeUtilsKt.getFilePath(AstNodeUtilsKt.getRootNode(node)))) {
            return;
        }
        List<RulesConfig> list = this.getConfigRules();
        Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
        boolean bl = this.isFixMode();
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        Warnings.COMPLEX_EXPRESSION.warn(list, function3, bl, string, node.getStartOffset(), node);
    }

    private final void handleOpeningParentheses(ASTNode node) {
        ASTNode parent = node.getTreeParent();
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getVALUE_ARGUMENT_LIST(), ElementType.INSTANCE.getVALUE_PARAMETER_LIST()};
        if (CollectionsKt.listOf((Object[])objectArray).contains(parent.getElementType())) {
            Object[] objectArray2;
            Object object;
            ASTNode aSTNode = PackageKt.parent((ASTNode)node, (Function1)handleOpeningParentheses.prevWhiteSpace.1.INSTANCE, (boolean)false);
            if (aSTNode == null) {
                object = null;
            } else {
                objectArray2 = aSTNode.getTreePrev();
                if (objectArray2 == null) {
                    object = null;
                } else {
                    Object[] objectArray3;
                    Object[] it = objectArray3 = objectArray2;
                    boolean bl = false;
                    object = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? objectArray3 : null;
                }
            }
            Object[] prevWhiteSpace2 = object;
            objectArray2 = new IElementType[]{ElementType.INSTANCE.getCALL_EXPRESSION(), ElementType.INSTANCE.getPRIMARY_CONSTRUCTOR(), ElementType.INSTANCE.getSECONDARY_CONSTRUCTOR(), ElementType.INSTANCE.getFUN()};
            boolean isNotAnonymous = CollectionsKt.listOf((Object[])objectArray2).contains(parent.getTreeParent().getElementType());
            if (prevWhiteSpace2 != null && isNotAnonymous) {
                Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "opening parentheses should not be separated from constructor or function name", node.getStartOffset(), node, false, (Function0)new Function0<Unit>((ASTNode)prevWhiteSpace2){
                    final /* synthetic */ ASTNode $prevWhiteSpace;
                    {
                        this.$prevWhiteSpace = $prevWhiteSpace;
                        super(0);
                    }

                    public final void invoke() {
                        this.$prevWhiteSpace.getTreeParent().removeChild(this.$prevWhiteSpace);
                    }
                }, 64, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void handleComma(ASTNode node) {
        ASTNode prevNewLine2;
        ASTNode aSTNode;
        ASTNode aSTNode2 = PackageKt.parent((ASTNode)node, (Function1)handleComma.prevNewLine.1.INSTANCE, (boolean)false);
        if (aSTNode2 == null) {
            return;
        }
        ASTNode aSTNode3 = aSTNode2.getTreePrev();
        if (aSTNode3 == null) {
            return;
        }
        ASTNode it = aSTNode = aSTNode3;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) return;
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) return;
        boolean bl2 = true;
        if (!bl2) return;
        ASTNode aSTNode5 = aSTNode;
        aSTNode5 = prevNewLine2 = aSTNode5;
        if (aSTNode5 == null) return;
        ASTNode it2 = aSTNode5;
        boolean bl3 = false;
        Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "newline should be placed only after comma", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(it2){
            final /* synthetic */ ASTNode $it;
            {
                this.$it = $it;
                super(0);
            }

            public final void invoke() {
                this.$it.getTreeParent().removeChild(this.$it);
            }
        }, 64, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void handleColon(ASTNode node) {
        ASTNode prevNewLine2;
        ASTNode aSTNode;
        ASTNode aSTNode2 = PackageKt.parent((ASTNode)node, (Function1)handleColon.prevNewLine.1.INSTANCE, (boolean)false);
        if (aSTNode2 == null) {
            return;
        }
        ASTNode aSTNode3 = aSTNode2.getTreePrev();
        if (aSTNode3 == null) {
            return;
        }
        ASTNode it = aSTNode = aSTNode3;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) return;
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) return;
        boolean bl2 = true;
        if (!bl2) return;
        ASTNode aSTNode5 = aSTNode;
        aSTNode5 = prevNewLine2 = aSTNode5;
        if (aSTNode5 == null) return;
        ASTNode whiteSpace = aSTNode5;
        boolean bl3 = false;
        Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "newline shouldn't be placed before colon", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(whiteSpace, node){
            final /* synthetic */ ASTNode $whiteSpace;
            final /* synthetic */ ASTNode $node;
            {
                this.$whiteSpace = $whiteSpace;
                this.$node = $node;
                super(0);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void invoke() {
                ASTNode nextNewLine2;
                ASTNode aSTNode;
                this.$whiteSpace.getTreeParent().removeChild(this.$whiteSpace);
                if (!AstNodeUtilsKt.hasParent(this.$node, ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) return;
                ASTNode aSTNode2 = this.$whiteSpace.getTreeParent();
                if (aSTNode2 == null) return;
                ASTNode aSTNode3 = aSTNode2;
                ASTNode aSTNode4 = this.$node;
                ASTNode it = aSTNode3;
                boolean bl = false;
                ASTNode aSTNode5 = PackageKt.parent((ASTNode)aSTNode4, (Function1)handleColon.1.1.nextNewLine.1.INSTANCE, (boolean)false);
                if (aSTNode5 == null) {
                    return;
                }
                ASTNode aSTNode6 = aSTNode5.getTreeNext();
                if (aSTNode6 == null) {
                    return;
                }
                ASTNode it2 = aSTNode = aSTNode6;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it2.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) return;
                String string = it2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) return;
                boolean bl3 = true;
                if (!bl3) return;
                ASTNode aSTNode8 = aSTNode;
                aSTNode8 = nextNewLine2 = aSTNode8;
                if (aSTNode8 == null) return;
                ASTNode it3 = aSTNode8;
                boolean bl4 = false;
                it3.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), it3);
                it3.getTreeParent().removeChild(it3);
            }
        }, 64, null);
    }

    private final void handleLambdaBody(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL())) {
            Object v0;
            boolean isSingleLineLambda;
            block7: {
                String string = node.getTreeParent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treeParent.text");
                isSingleLineLambda = StringsKt.lines((CharSequence)string).size() == 1;
                for (Object e : PsiUtilsKt.siblings((ASTNode)node, (boolean)false)) {
                    ASTNode it = (ASTNode)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getARROW())) continue;
                    v0 = e;
                    break block7;
                }
                v0 = null;
            }
            ASTNode arrowNode = v0;
            if (!isSingleLineLambda && arrowNode != null) {
                List newlinesBeforeArrow2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.siblings((ASTNode)arrowNode, (boolean)false), (Function1)((Function1)new Function1<ASTNode, Boolean>(this){
                    final /* synthetic */ NewlinesRule this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ASTNode it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return NewlinesRule.access$isNewLineNode(this.this$0, it);
                    }
                })));
                if (!((Collection)newlinesBeforeArrow2).isEmpty() || !AstNodeUtilsKt.isFollowedByNewline(arrowNode)) {
                    Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "in lambda with several lines in body newline should be placed after an arrow", arrowNode.getStartOffset(), arrowNode, false, (Function0)new Function0<Unit>((List<? extends ASTNode>)newlinesBeforeArrow2, arrowNode){
                        final /* synthetic */ List<ASTNode> $newlinesBeforeArrow;
                        final /* synthetic */ ASTNode $arrowNode;
                        {
                            this.$newlinesBeforeArrow = $newlinesBeforeArrow;
                            this.$arrowNode = $arrowNode;
                            super(0);
                        }

                        public final void invoke() {
                            ASTNode aSTNode;
                            Iterable $this$forEach$iv = this.$newlinesBeforeArrow;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                ASTNode it = (ASTNode)element$iv;
                                boolean bl = false;
                                it.getTreeParent().replaceChild(it, (ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "));
                            }
                            ASTNode it = aSTNode = this.$arrowNode.getTreeNext();
                            boolean bl = false;
                            Object object = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? aSTNode : null;
                            if (object != null) {
                                AstNodeUtilsKt.leaveOnlyOneNewLine(object);
                            }
                        }
                    }, 64, null);
                }
            } else if (!isSingleLineLambda && arrowNode == null) {
                ASTNode lbraceNode = node.getTreeParent().getFirstChildNode();
                Intrinsics.checkNotNullExpressionValue((Object)lbraceNode, (String)"lbraceNode");
                if (!AstNodeUtilsKt.isFollowedByNewline(lbraceNode)) {
                    Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "in lambda with several lines in body newline should be placed after an opening brace", lbraceNode.getStartOffset(), lbraceNode, false, (Function0)new Function0<Unit>(lbraceNode){
                        final /* synthetic */ ASTNode $lbraceNode;
                        {
                            this.$lbraceNode = $lbraceNode;
                            super(0);
                        }

                        public final void invoke() {
                            ASTNode it = this.$lbraceNode.getTreeNext();
                            boolean bl = false;
                            if (Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                AstNodeUtilsKt.leaveOnlyOneNewLine(it);
                            } else {
                                it.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), it);
                            }
                        }
                    }, 64, null);
                }
            }
        }
    }

    private final void handleReturnStatement(ASTNode node) {
        List list;
        List list2;
        boolean returnsUnit;
        ASTNode aSTNode;
        ASTNode it = aSTNode = node.getTreeParent();
        boolean bl = false;
        ASTNode blockNode = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getBLOCK()) && Intrinsics.areEqual((Object)it.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFUN()) ? aSTNode : null;
        boolean bl2 = returnsUnit = SequencesKt.count((Sequence)PsiUtilsKt.children((ASTNode)node)) == 1;
        if (blockNode == null || returnsUnit) {
            return;
        }
        List it2 = list2 = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)PsiUtilsKt.children((ASTNode)blockNode), (Function1)handleReturnStatement.1.INSTANCE));
        boolean bl3 = false;
        List list3 = list = it2.size() == 1 ? list2 : null;
        if (list != null) {
            it2 = list2 = list;
            boolean bl4 = false;
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "functions with single return statement should be simplified to expression body", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(blockNode, node){
                final /* synthetic */ ASTNode $blockNode;
                final /* synthetic */ ASTNode $node;
                {
                    this.$blockNode = $blockNode;
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    ASTNode aSTNode;
                    Object object;
                    ASTNode funNode = this.$blockNode.getTreeParent();
                    PsiElement psiElement = funNode.getPsi();
                    KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
                    if (ktNamedFunction == null) {
                        object = null;
                    } else {
                        KtTypeReference ktTypeReference = ktNamedFunction.getTypeReference();
                        object = ktTypeReference == null ? null : ktTypeReference.getNode();
                    }
                    ASTNode returnType = object;
                    ASTNode aSTNode2 = this.$node.findChildByType(ElementType.INSTANCE.getRETURN_KEYWORD());
                    Intrinsics.checkNotNull((Object)aSTNode2);
                    psiElement = aSTNode2;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"node.findChildByType(RETURN_KEYWORD)!!");
                    ASTNode aSTNode3 = PackageKt.nextCodeSibling((ASTNode)psiElement);
                    Intrinsics.checkNotNull((Object)aSTNode3);
                    ASTNode expression = aSTNode3;
                    ASTNode blockNode = funNode.findChildByType(ElementType.INSTANCE.getBLOCK());
                    ASTNode $this$invoke_u24lambda_u2d0 = aSTNode = funNode;
                    boolean bl = false;
                    if (returnType != null) {
                        $this$invoke_u24lambda_u2d0.removeRange(returnType.getTreeNext(), null);
                        $this$invoke_u24lambda_u2d0.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), null);
                    } else if (blockNode != null) {
                        $this$invoke_u24lambda_u2d0.removeChild(blockNode);
                    }
                    $this$invoke_u24lambda_u2d0.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getEQ(), (CharSequence)"="), null);
                    $this$invoke_u24lambda_u2d0.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), null);
                    $this$invoke_u24lambda_u2d0.addChild((ASTNode)expression.clone(), null);
                }
            }, 64, null);
        }
    }

    private final void handleList(ASTNode node) {
        Pair pair;
        IElementType $i$f$any2;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) {
            ASTNode aSTNode = AstNodeUtilsKt.findParentNodeWithSpecificType(node, ElementType.INSTANCE.getLAMBDA_ARGUMENT());
            if (aSTNode != null) {
                ASTNode it = aSTNode;
                boolean bl = false;
                return;
            }
            IElementType it = node.getTreeParent().getElementType();
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getFUNCTION_TYPE()) || Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getFUNCTION_TYPE_RECEIVER());
            if (bl2) {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST())) {
            boolean bl;
            block19: {
                Sequence $this$any$iv = PsiUtilsKt.siblings((ASTNode)node, (boolean)false);
                boolean $i$f$any2 = false;
                for (Object element$iv : $this$any$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getREFERENCE_EXPRESSION())) continue;
                    bl = true;
                    break block19;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        if (Intrinsics.areEqual((Object)($i$f$any2 = node.getElementType()), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameterList");
            }
            pair = TuplesKt.to((Object)((KtParameterList)psiElement).getParameters().size(), (Object)"value parameters");
        } else if (Intrinsics.areEqual((Object)$i$f$any2, (Object)ElementType.INSTANCE.getSUPER_TYPE_LIST())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSuperTypeList");
            }
            pair = TuplesKt.to((Object)((KtSuperTypeList)psiElement).getEntries().size(), (Object)"supertype list entries");
        } else if (Intrinsics.areEqual((Object)$i$f$any2, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgumentList");
            }
            pair = TuplesKt.to((Object)((KtValueArgumentList)psiElement).getArguments().size(), (Object)"value arguments");
        } else {
            log.warn(Intrinsics.stringPlus((String)"Unexpected node element type ", (Object)node.getElementType()));
            return;
        }
        Pair pair2 = pair;
        int numEntries = ((Number)pair2.component1()).intValue();
        String entryType = (String)pair2.component2();
        if (numEntries > this.getConfiguration().getMaxParametersInOneLine()) {
            IElementType iElementType = node.getElementType();
            if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) {
                this.handleFirstValue(node, ElementType.INSTANCE.getVALUE_PARAMETER(), "first parameter should be placed on a separate line or all other parameters should be aligned with it in declaration of <" + this.getParentIdentifier(node) + '>');
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST())) {
                this.handleFirstValue(node, ElementType.INSTANCE.getVALUE_ARGUMENT(), "first value argument (%s) should be placed on the new line or all other parameters should be aligned with it");
            }
            this.handleValueParameterList(node, entryType);
        }
    }

    private final Unit handleFirstValue(ASTNode node, IElementType filterType, String warnText) {
        Unit unit;
        List list;
        List list2;
        List it = list2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.children((ASTNode)node), (Function1)handleFirstValue.1.INSTANCE), (Function1)((Function1)new Function1<ASTNode, Boolean>(filterType){
            final /* synthetic */ IElementType $filterType;
            {
                this.$filterType = $filterType;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getElementType(), (Object)this.$filterType);
            }
        })));
        boolean bl = false;
        List list3 = list = it.size() > 1 ? list2 : null;
        if (list == null) {
            unit = null;
        } else {
            String string;
            List list4 = list;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)filterType, (Object)ElementType.INSTANCE.getVALUE_ARGUMENT())) {
                Object[] objectArray = new Object[]{((ASTNode)CollectionsKt.first((List)list4)).getText()};
                String string2 = String.format(warnText, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                string = string2;
            } else {
                string = warnText;
            }
            String freeText = string;
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>((List<? extends ASTNode>)list4, node){
                final /* synthetic */ List<ASTNode> $list;
                final /* synthetic */ ASTNode $node;
                {
                    this.$list = $list;
                    this.$node = $node;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    ASTNode aSTNode = ((ASTNode)CollectionsKt.first(this.$list)).getTreePrev();
                    if (aSTNode != null) {
                        void it;
                        ASTNode aSTNode2;
                        ASTNode aSTNode3 = aSTNode;
                        ASTNode aSTNode4 = this.$node;
                        List<ASTNode> list = this.$list;
                        ASTNode it2 = aSTNode3;
                        boolean bl = false;
                        ASTNode aSTNode5 = aSTNode2 = ((ASTNode)CollectionsKt.first(list)).getTreePrev();
                        ASTNode aSTNode6 = aSTNode4;
                        boolean bl2 = false;
                        boolean bl3 = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE());
                        AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode6, (ASTNode)(bl3 ? aSTNode2 : null), (ASTNode)CollectionsKt.first(list));
                    }
                }
            }, 64, null);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    private final Unit handleValueParameterList(ASTNode node, String entryType) {
        Unit unit;
        List list;
        List list2;
        List it = list2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.children((ASTNode)node), (Function1)((Function1)new Function1<ASTNode, Boolean>(this){
            final /* synthetic */ NewlinesRule this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ASTNode it) {
                boolean bl;
                block4: {
                    block3: {
                        ASTNode aSTNode;
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getCOMMA())) break block2;
                            aSTNode = it.getTreeNext();
                            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.treeNext");
                            if (!NewlinesRule.access$isNewLineNode(this.this$0, aSTNode)) break block3;
                        }
                        if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getRPAR()) || Intrinsics.areEqual((Object)it.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getCOMMA())) break block4;
                        aSTNode = it.getTreePrev();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.treePrev");
                        if (NewlinesRule.access$isNewLineNode(this.this$0, aSTNode)) break block4;
                    }
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        })));
        boolean bl = false;
        List list3 = list = !((Collection)it).isEmpty() ? list2 : null;
        if (list == null) {
            unit = null;
        } else {
            List invalidCommas = list;
            boolean bl2 = false;
            String warnText = this.getParentIdentifier(node) != null ? entryType + " should be placed on different lines in declaration of <" + this.getParentIdentifier(node) + '>' : Intrinsics.stringPlus((String)entryType, (Object)" should be placed on different lines");
            Warnings.warnAndFix$default(Warnings.WRONG_NEWLINES, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), warnText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>((List<? extends ASTNode>)invalidCommas){
                final /* synthetic */ List<ASTNode> $invalidCommas;
                {
                    this.$invalidCommas = $invalidCommas;
                    super(0);
                }

                public final void invoke() {
                    Iterable $this$forEach$iv = this.$invalidCommas;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ASTNode aSTNode;
                        ASTNode nextWhiteSpace;
                        Object object;
                        ASTNode commaOrRpar = (ASTNode)element$iv;
                        boolean bl = false;
                        if (commaOrRpar.getTreeNext() == null) {
                            object = null;
                        } else {
                            ASTNode aSTNode2;
                            ASTNode it = aSTNode2;
                            boolean bl2 = false;
                            object = nextWhiteSpace = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? aSTNode2 : null;
                        }
                        if (Intrinsics.areEqual((Object)commaOrRpar.getElementType(), (Object)ElementType.INSTANCE.getCOMMA())) {
                            Unit unit;
                            ASTNode aSTNode3 = nextWhiteSpace;
                            if (aSTNode3 == null) {
                                unit = null;
                            } else if (aSTNode3.getTreeNext() == null) {
                                unit = null;
                            } else {
                                boolean bl3 = false;
                                AstNodeUtilsKt.appendNewlineMergingWhiteSpace(commaOrRpar, nextWhiteSpace, nextWhiteSpace.getTreeNext());
                                unit = Unit.INSTANCE;
                            }
                            if ((aSTNode = unit) != null) continue;
                            ASTNode aSTNode4 = commaOrRpar.getTreeNext();
                            if (aSTNode4 == null) continue;
                            ASTNode aSTNode5 = aSTNode4.getTreeParent();
                            if (aSTNode5 == null) continue;
                            AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode5, nextWhiteSpace, commaOrRpar.getTreeNext());
                            continue;
                        }
                        aSTNode = commaOrRpar.getTreeParent();
                        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"commaOrRpar.treeParent");
                        AstNodeUtilsKt.appendNewlineMergingWhiteSpace(aSTNode, nextWhiteSpace, commaOrRpar);
                    }
                }
            }, 64, null);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    private final boolean isNewLineNode(ASTNode $this$isNewLineNode) {
        ASTNode $this$isNewLineNode_u24lambda_u2d17 = $this$isNewLineNode;
        boolean bl = false;
        return Intrinsics.areEqual((Object)$this$isNewLineNode_u24lambda_u2d17.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && $this$isNewLineNode_u24lambda_u2d17.textContains('\n');
    }

    private final String getParentIdentifier(ASTNode $this$getParentIdentifier) {
        ASTNode aSTNode;
        IElementType iElementType = $this$getParentIdentifier.getTreeParent().getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPRIMARY_CONSTRUCTOR())) {
            aSTNode = $this$getParentIdentifier.getTreeParent().getTreeParent();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSECONDARY_CONSTRUCTOR())) {
            ASTNode aSTNode2 = PackageKt.parent$default((ASTNode)$this$getParentIdentifier, (IElementType)ElementType.INSTANCE.getCLASS(), (boolean)false, (int)2, null);
            aSTNode = aSTNode2;
            Intrinsics.checkNotNull((Object)aSTNode2);
        } else {
            aSTNode = $this$getParentIdentifier.getTreeParent();
        }
        ASTNode aSTNode3 = aSTNode;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"when (treeParent.element\u2026 else -> treeParent\n    }");
        ASTNode aSTNode4 = AstNodeUtilsKt.getIdentifierName(aSTNode3);
        return aSTNode4 == null ? null : aSTNode4.getText();
    }

    private final void getOrderedCallExpressions(ASTNode $this$getOrderedCallExpressions, PsiElement psi, List<ASTNode> result) {
        PsiElement psiElement = psi.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi.children");
        if (!(((Object[])psiElement).length == 0) && !this.isFirstChildElementType(psi, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION()) && !this.isFirstChildElementType(psi, ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION())) {
            PsiElement psiElement2;
            PsiElement firstChild = psi.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)firstChild, (String)"firstChild");
            if (this.isFirstChildElementType(firstChild, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION()) || this.isFirstChildElementType(firstChild, ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION())) {
                psiElement2 = firstChild.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"firstChild.firstChild");
                this.getOrderedCallExpressions($this$getOrderedCallExpressions, psiElement2, result);
            }
            psiElement2 = firstChild.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"firstChild.node");
            result.add((ASTNode)SequencesKt.first((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings((ASTNode)psiElement2, (boolean)true), (Function1)getOrderedCallExpressions.1.INSTANCE)));
        } else {
            psiElement = psi.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi.children");
            if (!(((Object[])psiElement).length == 0)) {
                psiElement = psi.getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi.firstChild");
                this.getOrderedCallExpressions($this$getOrderedCallExpressions, psiElement, result);
                psiElement = psi.getFirstChild().getNode();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi.firstChild\n                .node");
                result.add((ASTNode)SequencesKt.first((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.siblings((ASTNode)psiElement, (boolean)true), (Function1)getOrderedCallExpressions.2.INSTANCE)));
            }
        }
    }

    private final List<ASTNode> dotCalls(KtBinaryExpression $this$dotCalls, boolean right) {
        List list;
        KtExpression ktExpression;
        KtExpression ktExpression2 = ktExpression = right ? $this$dotCalls.getRight() : $this$dotCalls.getLeft();
        if (ktExpression == null) {
            list = null;
        } else {
            ASTNode aSTNode = ktExpression.getNode();
            if (aSTNode == null) {
                list = null;
            } else {
                ASTNode aSTNode2;
                ASTNode aSTNode3;
                ASTNode it = aSTNode3 = aSTNode;
                boolean bl = false;
                Object object = aSTNode2 = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION()) ? aSTNode3 : null;
                list = aSTNode2 == null ? null : ((aSTNode3 = aSTNode2.findChildByType(ElementType.INSTANCE.getDOT())) == null ? null : NewlinesRule.getCallChain$default(this, aSTNode3, false, 1, null));
            }
        }
        return list;
    }

    static /* synthetic */ List dotCalls$default(NewlinesRule newlinesRule, KtBinaryExpression ktBinaryExpression, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return newlinesRule.dotCalls(ktBinaryExpression, bl);
    }

    private final boolean isElvisCorrect(ASTNode $this$isElvisCorrect) {
        int n;
        if (!Intrinsics.areEqual((Object)$this$isElvisCorrect.getElementType(), (Object)ElementType.INSTANCE.getELVIS())) {
            return false;
        }
        PsiElement psiElement = $this$isElvisCorrect.getTreeParent().getTreeParent().getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        KtBinaryExpression binaryExpression = (KtBinaryExpression)psiElement;
        List<ASTNode> leftDotCalls = this.dotCalls(binaryExpression, false);
        List rightDotCalls = NewlinesRule.dotCalls$default(this, binaryExpression, false, 1, null);
        List<ASTNode> list = leftDotCalls;
        List list2 = rightDotCalls;
        return (list == null ? 0 : (n = list.size())) + (list2 == null ? 0 : (n = list2.size())) > this.getConfiguration().getMaxCallsInOneLine() && !AstNodeUtilsKt.isBeginByNewline($this$isElvisCorrect);
    }

    private final ASTNode selfOrOperationReferenceParent(ASTNode $this$selfOrOperationReferenceParent) {
        ASTNode aSTNode;
        ASTNode it = aSTNode = $this$selfOrOperationReferenceParent.getTreeParent();
        boolean bl = false;
        Object object = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE()) ? aSTNode : null;
        if (object == null) {
            object = $this$selfOrOperationReferenceParent;
        }
        return object;
    }

    private final boolean isSingleDotStatementOnSingleLine(ASTNode $this$isSingleDotStatementOnSingleLine) {
        boolean bl;
        ASTNode aSTNode = (ASTNode)SequencesKt.singleOrNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.parents((ASTNode)$this$isSingleDotStatementOnSingleLine), (Function1)isSingleDotStatementOnSingleLine.1.INSTANCE));
        if (aSTNode == null) {
            bl = false;
        } else {
            boolean bl2;
            ASTNode it = aSTNode;
            boolean bl3 = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.text");
            bl = bl2 = ((Collection)StringsKt.lines((CharSequence)string)).size() == 1;
        }
        return bl;
    }

    private final boolean isDotFromPackageOrImport(ASTNode $this$isDotFromPackageOrImport) {
        return Intrinsics.areEqual((Object)$this$isDotFromPackageOrImport.getElementType(), (Object)ElementType.INSTANCE.getDOT()) && PackageKt.parent((ASTNode)$this$isDotFromPackageOrImport, (Function1)isDotFromPackageOrImport.1.INSTANCE, (boolean)true) != null;
    }

    private final boolean isFirstChildElementType(PsiElement $this$isFirstChildElementType, IElementType elementType) {
        return Intrinsics.areEqual((Object)$this$isFirstChildElementType.getFirstChild().getNode().getElementType(), (Object)elementType);
    }

    private final boolean isInvalidCallsChain(ASTNode $this$isInvalidCallsChain, boolean dropLeadingProperties) {
        boolean bl;
        List<ASTNode> list = this.getCallChain($this$isInvalidCallsChain, dropLeadingProperties);
        return list == null ? false : (bl = this.isNotValidCalls(list, $this$isInvalidCallsChain));
    }

    static /* synthetic */ boolean isInvalidCallsChain$default(NewlinesRule newlinesRule, ASTNode aSTNode, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return newlinesRule.isInvalidCallsChain(aSTNode, bl);
    }

    private final List<ASTNode> getCallChain(ASTNode $this$getCallChain, boolean dropLeadingProperties) {
        List list;
        List list2;
        ASTNode aSTNode = (ASTNode)SequencesKt.lastOrNull(this.getParentExpressions($this$getCallChain));
        if (aSTNode == null) {
            list2 = null;
        } else {
            List list3;
            ASTNode $this$getCallChain_u24lambda_u2d22 = aSTNode;
            boolean bl = false;
            List it = list3 = (List)new ArrayList();
            boolean bl2 = false;
            PsiElement psiElement = $this$getCallChain_u24lambda_u2d22.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi");
            this.getOrderedCallExpressions($this$getCallChain_u24lambda_u2d22, psiElement, it);
            list2 = list3;
        }
        List parentExpressionList = list2;
        if (dropLeadingProperties) {
            List list4 = parentExpressionList;
            if (list4 == null) {
                list = null;
            } else {
                Iterable $this$dropWhile$iv = list4;
                boolean $i$f$dropWhile = false;
                boolean yielding$iv = false;
                ArrayList list$iv = new ArrayList();
                for (Object item$iv : $this$dropWhile$iv) {
                    if (yielding$iv) {
                        list$iv.add(item$iv);
                        continue;
                    }
                    ASTNode it = (ASTNode)item$iv;
                    boolean bl = false;
                    if (!it.getTreeParent().textContains('(') && !it.getTreeParent().textContains('{')) continue;
                    list$iv.add(item$iv);
                    yielding$iv = true;
                }
                list = list$iv;
            }
        } else {
            list = parentExpressionList;
        }
        return list;
    }

    static /* synthetic */ List getCallChain$default(NewlinesRule newlinesRule, ASTNode aSTNode, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return newlinesRule.getCallChain(aSTNode, bl);
    }

    private final boolean isNotValidCalls(List<? extends ASTNode> $this$isNotValidCalls, ASTNode node) {
        Object v0;
        block6: {
            if ($this$isNotValidCalls.size() == 1) {
                return false;
            }
            List callsByNewLine = new ArrayList();
            List callsInOneNewLine = null;
            callsInOneNewLine = new ArrayList();
            Iterable $this$forEach$iv = $this$isNotValidCalls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode astNode = (ASTNode)element$iv;
                boolean bl = false;
                ASTNode aSTNode = astNode.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"astNode.treePrev");
                if (AstNodeUtilsKt.isFollowedByNewline(aSTNode) || PackageKt.isWhiteSpaceWithNewline((ASTNode)astNode.getTreePrev())) {
                    callsByNewLine.add(callsInOneNewLine);
                    callsInOneNewLine = new ArrayList();
                    callsInOneNewLine.add(astNode);
                } else {
                    callsInOneNewLine.add(astNode);
                }
                if (!Intrinsics.areEqual((Object)astNode.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getPOSTFIX_EXPRESSION())) continue;
                aSTNode = astNode.getTreePrev();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"astNode.treePrev");
                if (AstNodeUtilsKt.isFollowedByNewline(aSTNode) || this.getConfiguration().getMaxCallsInOneLine() != 1) continue;
                return true;
            }
            callsByNewLine.add(callsInOneNewLine);
            for (Object t : (Iterable)callsByNewLine) {
                List it = (List)t;
                boolean bl = false;
                if (!it.contains(node)) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        List list = v0;
        if (list == null) {
            return false;
        }
        return list.indexOf(node) + 1 > this.getConfiguration().getMaxCallsInOneLine();
    }

    private final Sequence<ASTNode> getParentExpressions(ASTNode $this$getParentExpressions) {
        return SequencesKt.takeWhile((Sequence)PsiUtilsKt.parents((ASTNode)$this$getParentExpressions), (Function1)getParentExpressions.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMultilineLambda(ASTNode node) {
        int n;
        ASTNode aSTNode = (ASTNode)CollectionsKt.firstOrNull((List)AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getLAMBDA_ARGUMENT(), false, 2, null));
        if (aSTNode == null) {
            n = -1;
        } else {
            String string = aSTNode.getText();
            if (string == null) {
                n = -1;
            } else {
                int n2;
                void $this$count$iv;
                CharSequence charSequence = string;
                boolean $i$f$count = false;
                int count$iv = 0;
                void var8_7 = $this$count$iv;
                for (int i = 0; i < var8_7.length(); ++i) {
                    char element$iv = var8_7.charAt(i);
                    char it = element$iv;
                    boolean bl = false;
                    if (!(it == '\n')) continue;
                    ++count$iv;
                }
                n = n2 = count$iv;
            }
        }
        return n > 0;
    }

    private final boolean isFirstCall(ASTNode $this$isFirstCall) {
        boolean bl;
        ASTNode aSTNode = (ASTNode)SequencesKt.lastOrNull(this.getParentExpressions($this$isFirstCall));
        if (aSTNode == null) {
            bl = false;
        } else {
            boolean bl2;
            List list;
            ASTNode $this$isFirstCall_u24lambda_u2d28 = aSTNode;
            boolean bl3 = false;
            List it = list = (List)new ArrayList();
            boolean bl4 = false;
            PsiElement psiElement = $this$isFirstCall_u24lambda_u2d28.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi");
            this.getOrderedCallExpressions($this$isFirstCall_u24lambda_u2d28, psiElement, it);
            ASTNode firstCallee = (ASTNode)CollectionsKt.first((List)list);
            list = firstCallee.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"firstCallee.elementType");
            bl = bl2 = CollectionsKt.first(AstNodeUtilsKt.findAllDescendantsWithSpecificType($this$isFirstCall_u24lambda_u2d28, (IElementType)list, false)) == $this$isFirstCall;
        }
        return bl;
    }

    private final boolean isInfixCall(ASTNode $this$isInfixCall) {
        return Intrinsics.areEqual((Object)$this$isInfixCall.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE()) && Intrinsics.areEqual((Object)$this$isInfixCall.getFirstChildNode().getElementType(), (Object)ElementType.INSTANCE.getIDENTIFIER()) && Intrinsics.areEqual((Object)$this$isInfixCall.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION());
    }

    private final boolean isInParentheses(ASTNode $this$isInParentheses) {
        boolean bl;
        ASTNode aSTNode = PackageKt.parent$default((ASTNode)$this$isInParentheses, (Function1)isInParentheses.1.INSTANCE, (boolean)false, (int)2, null);
        if (aSTNode == null) {
            bl = false;
        } else {
            ASTNode aSTNode2 = aSTNode.getTreeParent();
            if (aSTNode2 == null) {
                bl = false;
            } else {
                IElementType iElementType = aSTNode2.getElementType();
                if (iElementType == null) {
                    bl = false;
                } else {
                    boolean bl2;
                    IElementType it = iElementType;
                    boolean bl3 = false;
                    bl = bl2 = parenthesesTypes.contains(it);
                }
            }
        }
        return bl;
    }

    public static final /* synthetic */ ASTNode access$selfOrOperationReferenceParent(NewlinesRule $this, ASTNode $receiver) {
        return $this.selfOrOperationReferenceParent($receiver);
    }

    public static final /* synthetic */ boolean access$isNewLineNode(NewlinesRule $this, ASTNode $receiver) {
        return $this.isNewLineNode($receiver);
    }

    public static final /* synthetic */ TokenSet access$getDropChainValues$cp() {
        return dropChainValues;
    }

    public static final /* synthetic */ TokenSet access$getExpressionTypes$cp() {
        return expressionTypes;
    }

    public static final /* synthetic */ TokenSet access$getChainExpressionTypes$cp() {
        return chainExpressionTypes;
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getANDAND(), ElementType.INSTANCE.getOROR(), ElementType.INSTANCE.getPLUS(), ElementType.INSTANCE.getPLUSEQ(), ElementType.INSTANCE.getMINUS(), ElementType.INSTANCE.getMINUSEQ(), ElementType.INSTANCE.getMUL(), ElementType.INSTANCE.getMULTEQ(), ElementType.INSTANCE.getDIV(), ElementType.INSTANCE.getDIVEQ()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(ANDAND, OROR, PLU\u2026 MUL, MULTEQ, DIV, DIVEQ)");
        lineBreakAfterOperators = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getSAFE_ACCESS(), ElementType.INSTANCE.getELVIS(), ElementType.INSTANCE.getCOLONCOLON()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(DOT, SAFE_ACCESS, ELVIS, COLONCOLON)");
        lineBreakBeforeOperators = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION(), ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION(), ElementType.INSTANCE.getCALLABLE_REFERENCE_EXPRESSION(), ElementType.INSTANCE.getBINARY_EXPRESSION()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(DOT_QUALIFIED_EXP\u2026SSION, BINARY_EXPRESSION)");
        expressionTypes = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION(), ElementType.INSTANCE.getSAFE_ACCESS_EXPRESSION()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(DOT_QUALIFIED_EXP\u2026, SAFE_ACCESS_EXPRESSION)");
        chainExpressionTypes = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getEOL_COMMENT(), ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getBLOCK_COMMENT(), ElementType.INSTANCE.getKDOC()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(EOL_COMMENT, WHIT\u2026ACE, BLOCK_COMMENT, KDOC)");
        dropChainValues = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getCONDITION(), ElementType.INSTANCE.getWHEN(), ElementType.INSTANCE.getVALUE_ARGUMENT()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(CONDITION, WHEN, VALUE_ARGUMENT)");
        parenthesesTypes = tokenSet;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/NewlinesRule$NewlinesRuleConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxCallsInOneLine", "", "getMaxCallsInOneLine", "()I", "maxParametersInOneLine", "getMaxParametersInOneLine", "diktat-rules"})
    private static final class NewlinesRuleConfiguration
    extends RuleConfiguration {
        private final int maxParametersInOneLine;
        private final int maxCallsInOneLine;

        public NewlinesRuleConfiguration(@NotNull Map<String, String> config2) {
            int n;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("maxParametersInOneLine");
            this.maxParametersInOneLine = string == null ? 2 : (n = Integer.parseInt(string));
            string = config2.get("maxCallsInOneLine");
            this.maxCallsInOneLine = string == null ? 3 : (n = Integer.parseInt(string));
        }

        public final int getMaxParametersInOneLine() {
            return this.maxParametersInOneLine;
        }

        public final int getMaxCallsInOneLine() {
            return this.maxCallsInOneLine;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/NewlinesRule$Companion;", "", "()V", "MAX_CALLS_IN_ONE_LINE", "", "NAME_ID", "", "chainExpressionTypes", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "dropChainValues", "expressionTypes", "lineBreakAfterOperators", "lineBreakBeforeOperators", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "parenthesesTypes", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

