/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter3.files;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter3.files.WhiteSpaceRule;
import org.cqfn.diktat.ruleset.rules.chapter6.classes.CompactInitialization;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b \u0018\u0000 12\u00020\u0001:\u00011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J1\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J)\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J7\u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\t2\b\u0010%\u001a\u0004\u0018\u00010\f2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010(J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J%\u0010*\u001a\u00020\u0010*\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010!J\f\u0010+\u001a\u00020\u0010*\u00020\u0012H\u0002J\u0013\u0010,\u001a\u0004\u0018\u00010\f*\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\u0004\u0018\u00010\u0010*\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\u0004\u0018\u00010\u0012*\u00020\u0012H\u0002\u00a8\u00062"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/WhiteSpaceRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "getDescription", "", "shouldBefore", "", "shouldAfter", "before", "", "after", "(ZZLjava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/String;", "handleBinaryOperator", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleColon", "handleColonColon", "handleConstructor", "handleEolWhiteSpace", "handleGtOrLt", "handleKeywordWithParOrBrace", "handleLbrace", "handleLbracket", "handleLpar", "handleOperator", "handleRbrace", "handleToken", "requiredSpacesBefore", "requiredSpacesAfter", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Ljava/lang/Integer;Ljava/lang/Integer;)V", "handleWhiteSpaceAfterLeftBrace", "handleWhiteSpaceBeforeLeftBrace", "isFromLambdaAsArgument", "numWhiteSpace", "whitespaceOrPrevNode", "prevNode", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;ZLjava/lang/Integer;Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)V", "logic", "fixSpaceAround", "leaveSingleWhiteSpace", "numWhiteSpaces", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)Ljava/lang/Integer;", "removeIfWhiteSpace", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)Lkotlin/Unit;", "selfOrParentsTreePrev", "Companion", "diktat-rules"})
public final class WhiteSpaceRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(CompactInitialization.class);
    @NotNull
    public static final String NAME_ID = "acs-horizontal-whitespace";
    private static final int NUM_PARENTS_FOR_LAMBDA = 3;
    @NotNull
    private static final TokenSet keywordsWithSpaceAfter;
    @NotNull
    private static final TokenSet operatorsWithNoWhitespace;

    public WhiteSpaceRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.WRONG_WHITESPACE)), SetsKt.setOf((Object)new Rule.VisitorModifier.RunAfterRule("diktat-ruleset:acr-newlines", false, false, 6, null)));
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCONSTRUCTOR_KEYWORD())) {
            this.handleConstructor(node);
        } else if (keywordsWithSpaceAfter.contains(iElementType)) {
            this.handleKeywordWithParOrBrace(node);
        } else if (((Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getDOT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getARROW())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSAFE_ACCESS())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getEQ())) {
            this.handleBinaryOperator(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) {
            this.handleOperator(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCOLON())) {
            this.handleColon(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCOLONCOLON())) {
            this.handleColonColon(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCOMMA()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSEMICOLON())) {
            this.handleToken(node, 0, 1);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getQUEST())) {
            if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getNULLABLE_TYPE())) {
                this.handleToken(node, 0, null);
            }
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLBRACE())) {
            this.handleLbrace(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRBRACE())) {
            this.handleRbrace(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLBRACKET())) {
            this.handleLbracket(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            this.handleLpar(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRBRACKET())) {
            this.handleToken(node, 0, null);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getGT()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLT())) {
            this.handleGtOrLt(node);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            this.handleEolWhiteSpace(node);
        }
    }

    private final void handleLbracket(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getCOLLECTION_LITERAL_EXPRESSION())) {
            this.handleToken(node, 1, 0);
        } else {
            this.handleToken(node, 0, 0);
        }
    }

    private final void handleConstructor(ASTNode node) {
        boolean bl;
        ASTNode aSTNode = node.getTreeNext();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeNext");
        Integer n = this.numWhiteSpaces(aSTNode);
        if (n == null) {
            bl = false;
        } else {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = it > 0;
        }
        if (bl) {
            Warnings.warnAndFix$default(Warnings.WRONG_WHITESPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "keyword '" + node.getText() + "' should not be separated from '(' with a whitespace", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    this.$node.getTreeParent().removeChild(this.$node.getTreeNext());
                }
            }, 64, null);
        }
    }

    private final void handleKeywordWithParOrBrace(ASTNode node) {
        ASTNode aSTNode = node.getTreeNext();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.treeNext");
        Integer n = this.numWhiteSpaces(aSTNode);
        int n2 = 1;
        if (n == null || n != n2) {
            ASTNode aSTNode2 = PackageKt.nextCodeLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
            Intrinsics.checkNotNull((Object)aSTNode2);
            ASTNode nextCodeLeaf = aSTNode2;
            if (!Intrinsics.areEqual((Object)nextCodeLeaf.getElementType(), (Object)ElementType.INSTANCE.getLPAR()) && !Intrinsics.areEqual((Object)nextCodeLeaf.getElementType(), (Object)ElementType.INSTANCE.getLBRACE()) && node.getTreeNext().textContains('\n')) {
                return;
            }
            Warnings.warnAndFix$default(Warnings.WRONG_WHITESPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "keyword '" + node.getText() + "' should be separated from '" + nextCodeLeaf.getText() + "' with a whitespace", nextCodeLeaf.getStartOffset(), nextCodeLeaf, false, (Function0)new Function0<Unit>(this, node){
                final /* synthetic */ WhiteSpaceRule this$0;
                final /* synthetic */ ASTNode $node;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    WhiteSpaceRule.access$leaveSingleWhiteSpace(this.this$0, this.$node);
                }
            }, 64, null);
        }
    }

    private final void handleRbrace(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL()) && !PackageKt.isWhiteSpace((ASTNode)node.getTreePrev()) && Intrinsics.areEqual((Object)node.getTreePrev().getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) {
            String string = node.getTreePrev().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treePrev.text");
            if (((CharSequence)string).length() > 0) {
                Warnings.warnAndFix$default(Warnings.WRONG_WHITESPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "there should be a whitespace before }", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                    final /* synthetic */ ASTNode $node;
                    {
                        this.$node = $node;
                        super(0);
                    }

                    public final void invoke() {
                        this.$node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), this.$node);
                    }
                }, 64, null);
            }
        }
    }

    private final void handleLbrace(ASTNode node) {
        boolean bl;
        List list;
        List list2;
        ASTNode aSTNode = this.selfOrParentsTreePrev(node);
        Intrinsics.checkNotNull((Object)aSTNode);
        ASTNode whitespaceOrPrevNode = aSTNode;
        List it = list2 = SequencesKt.toList((Sequence)SequencesKt.take((Sequence)PsiUtilsKt.parents((ASTNode)node), (int)3));
        boolean bl2 = false;
        List list3 = list = it.size() == 3 ? list2 : null;
        if (list == null) {
            bl = false;
        } else {
            boolean bl3;
            List it2 = list;
            boolean bl4 = false;
            bl = bl3 = Intrinsics.areEqual((Object)((ASTNode)it2.get(0)).getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL()) && Intrinsics.areEqual((Object)((ASTNode)it2.get(1)).getElementType(), (Object)ElementType.INSTANCE.getLAMBDA_EXPRESSION()) && Intrinsics.areEqual((Object)((ASTNode)it2.get(2)).getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT()) && !AstNodeUtilsKt.hasChildOfType((ASTNode)it2.get(2), ElementType.INSTANCE.getEQ());
        }
        boolean isFromLambdaAsArgument = bl;
        it = whitespaceOrPrevNode;
        boolean bl5 = false;
        List prevNode = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? it.getTreePrev() : it;
        Integer numWhiteSpace = this.numWhiteSpaces(whitespaceOrPrevNode);
        Intrinsics.checkNotNullExpressionValue((Object)prevNode, (String)"prevNode");
        this.handleWhiteSpaceBeforeLeftBrace(node, isFromLambdaAsArgument, numWhiteSpace, whitespaceOrPrevNode, (ASTNode)prevNode);
        this.handleWhiteSpaceAfterLeftBrace(node);
    }

    private final void handleWhiteSpaceBeforeLeftBrace(ASTNode node, boolean isFromLambdaAsArgument, Integer numWhiteSpace, ASTNode whitespaceOrPrevNode, ASTNode prevNode) {
        if (isFromLambdaAsArgument) {
            ASTNode aSTNode;
            block8: {
                ASTNode it = PackageKt.parent$default((ASTNode)node, (Function1)handleWhiteSpaceBeforeLeftBrace.isFirstArgument.1.INSTANCE, (boolean)false, (int)2, null);
                boolean bl = false;
                ASTNode aSTNode2 = it;
                if (aSTNode2 == null) {
                    aSTNode = null;
                } else {
                    ASTNode $this$prevSibling$iv = aSTNode2;
                    boolean $i$f$prevSibling = false;
                    for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                        ASTNode prevNode2 = n$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)prevNode2.getElementType(), (Object)ElementType.INSTANCE.getCOMMA())) continue;
                        aSTNode = n$iv;
                        break block8;
                    }
                    aSTNode = null;
                }
            }
            boolean isFirstArgument2 = aSTNode == null;
            Integer n = numWhiteSpace;
            boolean bl = false;
            if ((n == null || n != 0) && isFirstArgument2) {
                Warnings.warnAndFix$default(Warnings.WRONG_WHITESPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "there should be no whitespace before '{' of lambda inside argument list", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(whitespaceOrPrevNode){
                    final /* synthetic */ ASTNode $whitespaceOrPrevNode;
                    {
                        this.$whitespaceOrPrevNode = $whitespaceOrPrevNode;
                        super(0);
                    }

                    public final void invoke() {
                        this.$whitespaceOrPrevNode.getTreeParent().removeChild(this.$whitespaceOrPrevNode);
                    }
                }, 64, null);
            }
        } else if (!keywordsWithSpaceAfter.contains(prevNode.getElementType())) {
            Integer n = numWhiteSpace;
            int n2 = 1;
            if (n == null || n != n2) {
                Warnings.warnAndFix$default(Warnings.WRONG_WHITESPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "there should be a whitespace before '{'", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, prevNode){
                    final /* synthetic */ WhiteSpaceRule this$0;
                    final /* synthetic */ ASTNode $prevNode;
                    {
                        this.this$0 = $receiver;
                        this.$prevNode = $prevNode;
                        super(0);
                    }

                    public final void invoke() {
                        WhiteSpaceRule.access$leaveSingleWhiteSpace(this.this$0, this.$prevNode);
                    }
                }, 64, null);
            }
        }
    }

    private final void handleWhiteSpaceAfterLeftBrace(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL()) && !PackageKt.isWhiteSpace((ASTNode)node.getTreeNext()) && Intrinsics.areEqual((Object)node.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) {
            String string = node.getTreeNext().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.treeNext.text");
            if (((CharSequence)string).length() > 0) {
                Warnings.warnAndFix$default(Warnings.WRONG_WHITESPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "there should be a whitespace after {", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                    final /* synthetic */ ASTNode $node;
                    {
                        this.$node = $node;
                        super(0);
                    }

                    public final void invoke() {
                        this.$node.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), this.$node.getTreeNext());
                    }
                }, 64, null);
            }
        }
    }

    private final void handleColonColon(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getCALLABLE_REFERENCE_EXPRESSION())) {
            if (!Intrinsics.areEqual((Object)node.getTreeParent().getFirstChildNode(), (Object)node)) {
                this.handleBinaryOperator(node);
            } else {
                this.handleToken(node, null, 0);
            }
        }
    }

    private final void handleColon(ASTNode node) {
        IElementType iElementType = node.getTreeParent().getElementType();
        if ((((Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getCLASS()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getSECONDARY_CONSTRUCTOR())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getTYPE_CONSTRAINT())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getTYPE_PARAMETER())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getOBJECT_DECLARATION())) {
            this.handleBinaryOperator(node);
        } else if ((Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER()) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getPROPERTY())) ? true : Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getFUN())) {
            this.handleToken(node, 0, 1);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getANNOTATION_ENTRY())) {
            this.handleToken(node, 0, 0);
        } else {
            log.warn("Colon with treeParent.elementType=" + node.getTreeParent().getElementType() + ", not handled by WhiteSpaceRule");
        }
    }

    private final void handleOperator(ASTNode node) {
        PsiElement psiElement = node.getTreeParent().getPsi();
        if (psiElement instanceof KtPrefixExpression) {
            this.handleToken(node, null, 0);
        } else if (psiElement instanceof KtPostfixExpression) {
            this.handleToken(node, 0, null);
        } else if (psiElement instanceof KtBinaryExpression) {
            this.handleBinaryOperator(node);
        }
    }

    private final void handleBinaryOperator(ASTNode node) {
        block6: {
            ASTNode operatorNode;
            block5: {
                block4: {
                    ASTNode aSTNode = operatorNode = Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE()) ? node.getFirstChildNode() : node;
                    if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getEQ()) && Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) {
                        return;
                    }
                    if (!Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) break block4;
                    IElementType it = node.getTreeParent().getElementType();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getBINARY_EXPRESSION()) || Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getPOSTFIX_EXPRESSION()) || Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getPROPERTY())) break block5;
                }
                if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) break block6;
            }
            int requiredNumSpaces = operatorsWithNoWhitespace.contains(operatorNode.getElementType()) ? 0 : 1;
            this.handleToken(node, requiredNumSpaces, requiredNumSpaces);
        }
    }

    private final void handleToken(ASTNode node, Integer requiredSpacesBefore, Integer requiredSpacesAfter) {
        boolean isErrorAfter;
        Integer n;
        if (!(requiredSpacesBefore != null || requiredSpacesAfter != null)) {
            boolean $i$a$-require-WhiteSpaceRule$handleToken$22 = false;
            String $i$a$-require-WhiteSpaceRule$handleToken$22 = "requiredSpacesBefore=" + requiredSpacesBefore + " and requiredSpacesAfter=" + requiredSpacesAfter + ", but at least one should not be null";
            throw new IllegalArgumentException($i$a$-require-WhiteSpaceRule$handleToken$22.toString());
        }
        ASTNode aSTNode = this.selfOrParentsTreePrev(node);
        Intrinsics.checkNotNull((Object)aSTNode);
        Integer spacesBefore = this.numWhiteSpaces(aSTNode);
        Integer n2 = requiredSpacesAfter;
        if (n2 == null) {
            n = null;
        } else {
            ASTNode aSTNode2;
            int $noName_0 = ((Number)n2).intValue();
            boolean bl = false;
            ASTNode aSTNode3 = node.getTreeNext();
            ASTNode aSTNode4 = aSTNode2 = aSTNode3 == null ? node.getTreeParent().getTreeNext() : aSTNode3;
            n = aSTNode2 == null ? null : this.numWhiteSpaces(aSTNode2);
        }
        Integer spacesAfter = n;
        boolean isErrorBefore = requiredSpacesBefore != null && spacesBefore != null && !Intrinsics.areEqual((Object)spacesBefore, (Object)requiredSpacesBefore);
        boolean bl = isErrorAfter = requiredSpacesAfter != null && spacesAfter != null && !Intrinsics.areEqual(spacesAfter, (Object)requiredSpacesAfter);
        if (isErrorBefore || isErrorAfter) {
            String freeText = node.getText() + " should have" + this.getDescription(requiredSpacesBefore != null, requiredSpacesAfter != null, requiredSpacesBefore, requiredSpacesAfter) + ", but has" + this.getDescription(isErrorBefore, isErrorAfter, spacesBefore, spacesAfter);
            Warnings.warnAndFix$default(Warnings.WRONG_WHITESPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), freeText, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(this, node, requiredSpacesBefore, requiredSpacesAfter){
                final /* synthetic */ WhiteSpaceRule this$0;
                final /* synthetic */ ASTNode $node;
                final /* synthetic */ Integer $requiredSpacesBefore;
                final /* synthetic */ Integer $requiredSpacesAfter;
                {
                    this.this$0 = $receiver;
                    this.$node = $node;
                    this.$requiredSpacesBefore = $requiredSpacesBefore;
                    this.$requiredSpacesAfter = $requiredSpacesAfter;
                    super(0);
                }

                public final void invoke() {
                    WhiteSpaceRule.access$fixSpaceAround(this.this$0, this.$node, this.$requiredSpacesBefore, this.$requiredSpacesAfter);
                }
            }, 64, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleEolWhiteSpace(ASTNode node) {
        block4: {
            var3_2 = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)var3_2, (String)"node.text");
            hasSpaces = StringsKt.contains$default((CharSequence)StringsKt.substringBefore$default((String)var3_2, (char)'\n', null, (int)2, null), (char)' ', (boolean)false, (int)2, null);
            if (node.textContains('\n')) ** GOTO lbl-1000
            var4_5 = node.getPsi();
            Intrinsics.checkNotNullExpressionValue((Object)var4_5, (String)"node.psi");
            $this$all$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)var4_5);
            $i$f$all = false;
            for (E element$iv : $this$all$iv) {
                it = (PsiElement)element$iv;
                $i$a$-all-WhiteSpaceRule$handleEolWhiteSpace$isEol$1 = false;
                if (it.getNextSibling() == null) continue;
                v0 = false;
                break block4;
            }
            v0 = true;
        }
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = isEol = false;
        }
        if (hasSpaces && isEol) {
            Warnings.warnAndFix$default(Warnings.WRONG_WHITESPACE, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "there should be no spaces in the end of line", node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    LeafElement leafElement = (LeafElement)this.$node;
                    Object object = ((LeafElement)this.$node).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.text");
                    String string = object;
                    object = new char[1];
                    object[0] = 32;
                    leafElement.rawReplaceWithText(StringsKt.trimStart((String)string, (char[])object));
                }
            }, 64, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void handleLpar(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getTreeParent().getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getSECONDARY_CONSTRUCTOR())) {
            return;
        }
        v0 = PackageKt.nextCodeLeaf$default((ASTNode)node, (boolean)false, (boolean)false, (int)3, null);
        Intrinsics.checkNotNull((Object)v0);
        if (Intrinsics.areEqual((Object)v0.getElementType(), (Object)ElementType.INSTANCE.getLBRACE())) {
            return;
        }
        if (Intrinsics.areEqual((Object)node.getTreeParent().getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getANNOTATION_ENTRY())) {
            var2_2 = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)var2_2, (String)"node.treeParent");
            this.handleToken(var2_2, 0, null);
        }
        if (!Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST())) ** GOTO lbl-1000
        it = node.getTreeParent().getTreeParent().getElementType();
        $i$a$-let-WhiteSpaceRule$handleLpar$isDeclaration$1 = false;
        if (Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getPRIMARY_CONSTRUCTOR()) != false || Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getFUN()) != false || Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getCALL_EXPRESSION()) != false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = isDeclaration = false;
        }
        if (!Intrinsics.areEqual((Object)node.getTreeParent().getElementType(), (Object)ElementType.INSTANCE.getVALUE_ARGUMENT_LIST())) ** GOTO lbl-1000
        it = node.getTreeParent().getTreeParent().getElementType();
        $i$a$-let-WhiteSpaceRule$handleLpar$isCall$1 = false;
        if (Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getCONSTRUCTOR_DELEGATION_CALL()) != false || Intrinsics.areEqual((Object)it, (Object)ElementType.INSTANCE.getCALL_EXPRESSION()) != false) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = isCall = false;
        }
        if (isDeclaration || isCall) {
            this.handleToken(node, 0, 0);
        } else {
            this.handleToken(node, null, 0);
        }
    }

    private final void handleGtOrLt(ASTNode node) {
        if (Intrinsics.areEqual((Object)node.getTreeParent(), (Object)ElementType.INSTANCE.getTYPE_PARAMETER_LIST())) {
            this.handleToken(node, Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getGT()) ? Integer.valueOf(0) : null, Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getGT()) ? null : Integer.valueOf(0));
        }
    }

    private final void fixSpaceAround(ASTNode $this$fixSpaceAround, Integer requiredSpacesBefore, Integer requiredSpacesAfter) {
        Integer n = requiredSpacesBefore;
        int n2 = 1;
        if (n != null && n == n2) {
            ASTNode aSTNode = this.selfOrParentsTreePrev($this$fixSpaceAround);
            if (aSTNode != null) {
                ASTNode it = aSTNode;
                boolean bl = false;
                ASTNode aSTNode2 = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) ? it.getTreePrev() : it;
                if (aSTNode2 != null) {
                    this.leaveSingleWhiteSpace(aSTNode2);
                }
            }
        } else {
            Integer n3 = requiredSpacesBefore;
            n2 = 0;
            if (n3 != null && n3 == 0) {
                ASTNode aSTNode = this.selfOrParentsTreePrev($this$fixSpaceAround);
                if (aSTNode != null) {
                    this.removeIfWhiteSpace(aSTNode);
                }
            }
        }
        Integer n4 = requiredSpacesAfter;
        n2 = 1;
        if (n4 != null && n4 == n2) {
            this.leaveSingleWhiteSpace($this$fixSpaceAround);
        } else {
            Integer n5 = requiredSpacesAfter;
            n2 = 0;
            if (n5 != null && n5 == 0) {
                ASTNode aSTNode = $this$fixSpaceAround.getTreeNext();
                if (aSTNode == null) {
                    aSTNode = $this$fixSpaceAround.getTreeParent().getTreeNext();
                }
                ASTNode aSTNode3 = aSTNode;
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode3, (String)"treeNext ?: treeParent.treeNext");
                this.removeIfWhiteSpace(aSTNode3);
            }
        }
    }

    private final ASTNode selfOrParentsTreePrev(ASTNode $this$selfOrParentsTreePrev) {
        ASTNode aSTNode = PackageKt.parent((ASTNode)$this$selfOrParentsTreePrev, (Function1)selfOrParentsTreePrev.1.INSTANCE, (boolean)false);
        return aSTNode == null ? null : aSTNode.getTreePrev();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Integer numWhiteSpaces(ASTNode $this$numWhiteSpaces) {
        block6: {
            block5: {
                if (Intrinsics.areEqual((Object)$this$numWhiteSpaces.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) break block5;
                v0 = 0;
                break block6;
            }
            if (!Intrinsics.areEqual((Object)$this$numWhiteSpaces.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getBLOCK())) ** GOTO lbl-1000
            v1 = $this$numWhiteSpaces.getTreeNext().getFirstChildNode();
            if (v1 == null ? false : PackageKt.isPartOfComment((ASTNode)v1) == true) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = isBlockStartingWithComment = false;
            }
            if ($this$numWhiteSpaces.textContains('\n')) ** GOTO lbl-1000
            var3_3 /* !! */  = $this$numWhiteSpaces.getTreeNext();
            Intrinsics.checkNotNullExpressionValue((Object)var3_3 /* !! */ , (String)"treeNext");
            if (PackageKt.isPartOfComment((ASTNode)var3_3 /* !! */ ) || isBlockStartingWithComment) lbl-1000:
            // 2 sources

            {
                v0 = null;
            } else {
                var3_3 /* !! */  = $this$numWhiteSpaces.getText();
                Intrinsics.checkNotNullExpressionValue((Object)var3_3 /* !! */ , (String)"text");
                $this$count$iv = (CharSequence)var3_3 /* !! */ ;
                $i$f$count = false;
                count$iv = 0;
                var6_6 = $this$count$iv;
                for (var7_7 = 0; var7_7 < var6_6.length(); ++var7_7) {
                    element$iv = var6_6.charAt(var7_7);
                    it = element$iv;
                    $i$a$-count-WhiteSpaceRule$numWhiteSpaces$1 = false;
                    if (!(it == ' ')) continue;
                    ++count$iv;
                }
                v0 = count$iv;
            }
        }
        return v0;
    }

    private final void leaveSingleWhiteSpace(ASTNode $this$leaveSingleWhiteSpace) {
        if (Intrinsics.areEqual((Object)$this$leaveSingleWhiteSpace.getTreeNext().getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE())) {
            ASTNode aSTNode = $this$leaveSingleWhiteSpace.getTreeNext();
            if (aSTNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement");
            }
            ((LeafElement)aSTNode).rawReplaceWithText(" ");
        } else {
            $this$leaveSingleWhiteSpace.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)" "), $this$leaveSingleWhiteSpace.getTreeNext());
        }
    }

    private final Unit removeIfWhiteSpace(ASTNode $this$removeIfWhiteSpace) {
        Unit unit;
        ASTNode aSTNode;
        ASTNode aSTNode2;
        ASTNode it = aSTNode2 = $this$removeIfWhiteSpace;
        boolean bl = false;
        Object object = aSTNode = Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && !it.textContains('\n') ? aSTNode2 : null;
        if (aSTNode == null) {
            unit = null;
        } else {
            it = aSTNode;
            boolean bl2 = false;
            it.getTreeParent().removeChild(it);
            unit = Unit.INSTANCE;
        }
        return unit;
    }

    private final String getDescription(boolean shouldBefore, boolean shouldAfter, Integer before, Integer after) {
        return shouldBefore && shouldAfter ? "" + ' ' + before + " space(s) before and " + after + " space(s) after" : (shouldBefore && !shouldAfter ? "" + ' ' + before + " space(s) before" : (shouldAfter ? "" + ' ' + after + " space(s) after" : ""));
    }

    public static final /* synthetic */ void access$leaveSingleWhiteSpace(WhiteSpaceRule $this, ASTNode $receiver) {
        $this.leaveSingleWhiteSpace($receiver);
    }

    public static final /* synthetic */ void access$fixSpaceAround(WhiteSpaceRule $this, ASTNode $receiver, Integer requiredSpacesBefore, Integer requiredSpacesAfter) {
        $this.fixSpaceAround($receiver, requiredSpacesBefore, requiredSpacesAfter);
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getELSE_KEYWORD(), ElementType.INSTANCE.getTRY_KEYWORD(), ElementType.INSTANCE.getDO_KEYWORD(), ElementType.INSTANCE.getFINALLY_KEYWORD(), ElementType.INSTANCE.getINIT_KEYWORD(), ElementType.INSTANCE.getFOR_KEYWORD(), ElementType.INSTANCE.getIF_KEYWORD(), ElementType.INSTANCE.getWHILE_KEYWORD(), ElementType.INSTANCE.getCATCH_KEYWORD(), ElementType.INSTANCE.getWHEN_KEYWORD()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(\n            // t\u2026   WHEN_KEYWORD\n        )");
        keywordsWithSpaceAfter = tokenSet;
        iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getDOT(), ElementType.INSTANCE.getRANGE(), ElementType.INSTANCE.getCOLONCOLON(), ElementType.INSTANCE.getSAFE_ACCESS(), ElementType.INSTANCE.getEXCLEXCL()};
        tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(DOT, RANGE, COLON\u2026N, SAFE_ACCESS, EXCLEXCL)");
        operatorsWithNoWhitespace = tokenSet;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter3/files/WhiteSpaceRule$Companion;", "", "()V", "NAME_ID", "", "NUM_PARENTS_FOR_LAMBDA", "", "keywordsWithSpaceAfter", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "operatorsWithNoWhitespace", "getOperatorsWithNoWhitespace", "()Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TokenSet getOperatorsWithNoWhitespace() {
            return operatorsWithNoWhitespace;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

