/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter4.calculations;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter4.calculations.AccurateCalculationsRuleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0017\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u0013*\u0004\u0018\u00010\u0019H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\rH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0010H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter4/calculations/AccurateCalculationsRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkFloatValue", "", "floatValue", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "handleBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)Lkotlin/Unit;", "handleFunction", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "(Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;)Lkotlin/Unit;", "isComparisonWithAbs", "", "psiElement", "logic", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "isAbsOfFloat", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Companion", "diktat-rules"})
public final class AccurateCalculationsRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "abt-accurate-calculations";
    @NotNull
    private static final List<KtSingleValueToken> arithmeticOperationTokens;
    @NotNull
    private static final List<KtSingleValueToken> comparisonOperators;
    @NotNull
    private static final List<String> arithmeticOperationsFunctions;
    @NotNull
    private static final List<String> comparisonFunctions;

    public AccurateCalculationsRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.FLOAT_IN_ACCURATE_CALCULATIONS)), null, 8, null);
    }

    private final boolean isAbsOfFloat(KtCallExpression $this$isAbsOfFloat) {
        boolean bl;
        KtCallExpression ktCallExpression = $this$isAbsOfFloat;
        if (ktCallExpression == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            KtNameReferenceExpression ktNameReferenceExpression;
            KtCallExpression $this$isAbsOfFloat_u24lambda_u2d0 = ktCallExpression;
            boolean bl4 = false;
            Object object = $this$isAbsOfFloat_u24lambda_u2d0.getCalleeExpression();
            KtNameReferenceExpression ktNameReferenceExpression2 = ktNameReferenceExpression = object instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)object : null;
            if (ktNameReferenceExpression == null) {
                bl3 = false;
            } else {
                object = ktNameReferenceExpression.getReferencedName();
                if (object == null) {
                    bl3 = false;
                } else {
                    boolean bl5;
                    boolean bl6;
                    boolean bl7 = ((String)object).equals("abs");
                    List list = $this$isAbsOfFloat_u24lambda_u2d0.getValueArguments();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"valueArguments");
                    KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list);
                    bl3 = bl6 = bl7 & (ktValueArgument == null ? false : ((list = ktValueArgument.getArgumentExpression()) == null ? false : (bl5 = AccurateCalculationsRuleKt.access$isFloatingPoint((PsiElement)list))));
                }
            }
            bl = bl2 = bl3;
        }
        return bl;
    }

    private final boolean isComparisonWithAbs(KtDotQualifiedExpression $this$isComparisonWithAbs) {
        boolean bl;
        KtDotQualifiedExpression ktDotQualifiedExpression;
        KtDotQualifiedExpression ktDotQualifiedExpression2;
        KtDotQualifiedExpression it = ktDotQualifiedExpression2 = $this$isComparisonWithAbs;
        boolean bl2 = false;
        KtExpression $this$isComparisonWithAbs_u24lambda_u2d2_u24lambda_u2d1 = it.getSelectorExpression();
        boolean bl3 = false;
        Object object = ktDotQualifiedExpression = $this$isComparisonWithAbs_u24lambda_u2d2_u24lambda_u2d1 instanceof KtCallExpression && CollectionsKt.contains((Iterable)comparisonFunctions, (Object)org.cqfn.diktat.ruleset.utils.PsiUtilsKt.getFunctionName((KtCallExpression)$this$isComparisonWithAbs_u24lambda_u2d2_u24lambda_u2d1)) ? ktDotQualifiedExpression2 : null;
        if (ktDotQualifiedExpression == null) {
            bl = false;
        } else {
            boolean bl4;
            boolean bl5;
            KtDotQualifiedExpression $this$isComparisonWithAbs_u24lambda_u2d4 = ktDotQualifiedExpression;
            boolean bl6 = false;
            KtExpression ktExpression = $this$isComparisonWithAbs_u24lambda_u2d4.getSelectorExpression();
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            List list = ((KtCallExpression)ktExpression).getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"selectorExpression as Kt\u2026          .valueArguments");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list);
            if (ktValueArgument == null) {
                bl5 = false;
            } else {
                boolean bl7;
                KtValueArgument it2 = ktValueArgument;
                boolean bl8 = false;
                KtExpression ktExpression2 = it2.getArgumentExpression();
                list = ktExpression2 instanceof KtCallExpression ? (KtCallExpression)ktExpression2 : null;
                bl5 = list == null ? false : (bl7 = this.isAbsOfFloat((KtCallExpression)list));
            }
            bl = bl4 = bl5 || this.isAbsOfFloat((ktValueArgument = $this$isComparisonWithAbs_u24lambda_u2d4.getReceiverExpression()) instanceof KtCallExpression ? (KtCallExpression)ktValueArgument : null);
        }
        return bl;
    }

    private final boolean isComparisonWithAbs(KtBinaryExpression $this$isComparisonWithAbs) {
        boolean bl;
        KtBinaryExpression ktBinaryExpression;
        KtBinaryExpression ktBinaryExpression2;
        KtBinaryExpression it = ktBinaryExpression2 = $this$isComparisonWithAbs;
        boolean bl2 = false;
        Object object = ktBinaryExpression = CollectionsKt.contains((Iterable)comparisonOperators, (Object)it.getOperationToken()) ? ktBinaryExpression2 : null;
        if (ktBinaryExpression == null) {
            bl = false;
        } else {
            KtBinaryExpression $this$isComparisonWithAbs_u24lambda_u2d6 = ktBinaryExpression;
            boolean bl3 = false;
            KtExpression ktExpression = $this$isComparisonWithAbs_u24lambda_u2d6.getLeft();
            Object object2 = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            if (object2 == null) {
                ktExpression = $this$isComparisonWithAbs_u24lambda_u2d6.getRight();
                object2 = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            }
            if ((ktBinaryExpression2 = object2) == null) {
                bl = false;
            } else {
                boolean bl4;
                String string;
                KtBinaryExpression $this$isComparisonWithAbs_u24lambda_u2d7 = ktBinaryExpression2;
                boolean bl5 = false;
                KtExpression ktExpression2 = $this$isComparisonWithAbs_u24lambda_u2d7.getCalleeExpression();
                KtNameReferenceExpression ktNameReferenceExpression = ktExpression2 instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression2 : null;
                bl = ktNameReferenceExpression == null ? false : ((string = ktNameReferenceExpression.getReferencedName()) == null ? false : (bl4 = string.equals("abs")));
            }
        }
        return bl;
    }

    private final boolean isComparisonWithAbs(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        return psiElement2 instanceof KtBinaryExpression ? this.isComparisonWithAbs((KtBinaryExpression)psiElement) : (psiElement2 instanceof KtDotQualifiedExpression ? this.isComparisonWithAbs((KtDotQualifiedExpression)psiElement) : false);
    }

    private final void checkFloatValue(PsiElement floatValue, KtExpression expression) {
        PsiElement psiElement = floatValue;
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl2 = this.isFixMode();
            String string = "float value of <" + it.getText() + "> used in arithmetic expression in " + expression.getText();
            int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)expression));
            ASTNode aSTNode = expression.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"expression.node");
            Warnings.FLOAT_IN_ACCURATE_CALCULATIONS.warn(list, function3, bl2, string, n, aSTNode);
        }
    }

    private final Unit handleFunction(KtDotQualifiedExpression expression) {
        Unit unit;
        KtDotQualifiedExpression ktDotQualifiedExpression;
        KtDotQualifiedExpression ktDotQualifiedExpression2;
        KtDotQualifiedExpression it = ktDotQualifiedExpression2 = expression;
        boolean bl = false;
        Object object = ktDotQualifiedExpression = it.getSelectorExpression() instanceof KtCallExpression ? ktDotQualifiedExpression2 : null;
        if (ktDotQualifiedExpression == null) {
            unit = null;
        } else {
            KtDotQualifiedExpression $this$handleFunction_u24lambda_u2d10 = ktDotQualifiedExpression;
            boolean bl2 = false;
            KtExpression ktExpression = $this$handleFunction_u24lambda_u2d10.getSelectorExpression();
            if (ktExpression == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtCallExpression");
            }
            ktDotQualifiedExpression2 = TuplesKt.to((Object)$this$handleFunction_u24lambda_u2d10.getReceiverExpression(), (Object)((KtCallExpression)ktExpression));
            if (ktDotQualifiedExpression2 == null) {
                unit = null;
            } else {
                KtDotQualifiedExpression ktDotQualifiedExpression3;
                KtDotQualifiedExpression ktDotQualifiedExpression4;
                KtDotQualifiedExpression it2 = ktDotQualifiedExpression4 = ktDotQualifiedExpression2;
                boolean bl3 = false;
                Object object2 = ktDotQualifiedExpression3 = CollectionsKt.contains((Iterable)arithmeticOperationsFunctions, (Object)org.cqfn.diktat.ruleset.utils.PsiUtilsKt.getFunctionName((KtCallExpression)it2.getSecond())) ? ktDotQualifiedExpression4 : null;
                if (ktDotQualifiedExpression3 == null) {
                    unit = null;
                } else {
                    boolean bl4;
                    KtDotQualifiedExpression ktDotQualifiedExpression5;
                    block13: {
                        KtDotQualifiedExpression it3 = ktDotQualifiedExpression5 = ktDotQualifiedExpression3;
                        boolean bl5 = false;
                        Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)expression));
                        boolean $i$f$any = false;
                        for (Object element$iv : $this$any$iv) {
                            PsiElement p0 = (PsiElement)element$iv;
                            boolean bl6 = false;
                            if (!this.isComparisonWithAbs(p0)) continue;
                            bl4 = true;
                            break block13;
                        }
                        bl4 = false;
                    }
                    Object object3 = ktDotQualifiedExpression4 = !bl4 ? ktDotQualifiedExpression5 : null;
                    if (ktDotQualifiedExpression4 == null) {
                        unit = null;
                    } else {
                        KtElement ktElement;
                        Iterator iterator;
                        KtDotQualifiedExpression $dstr$receiverExpression$selectorExpression = ktDotQualifiedExpression4;
                        boolean bl7 = false;
                        KtExpression receiverExpression = (KtExpression)$dstr$receiverExpression$selectorExpression.component1();
                        KtCallExpression selectorExpression = (KtCallExpression)$dstr$receiverExpression$selectorExpression.component2();
                        Object object4 = receiverExpression;
                        Iterator it4 = object4;
                        boolean bl8 = false;
                        Iterator iterator2 = iterator = AccurateCalculationsRuleKt.access$isFloatingPoint((PsiElement)it4) ? object4 : null;
                        if (iterator == null) {
                            Object v8;
                            block14: {
                                object4 = selectorExpression.getValueArguments();
                                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"selectorExpression\n     \u2026          .valueArguments");
                                for (Object t : (Iterable)object4) {
                                    boolean bl9;
                                    KtValueArgument it5 = (KtValueArgument)t;
                                    boolean bl10 = false;
                                    KtExpression ktExpression2 = it5.getArgumentExpression();
                                    if (!(ktExpression2 == null ? false : (bl9 = AccurateCalculationsRuleKt.access$isFloatingPoint((PsiElement)ktExpression2)))) continue;
                                    v8 = t;
                                    break block14;
                                }
                                v8 = null;
                            }
                            ktElement = v8;
                        } else {
                            ktElement = (KtElement)iterator;
                        }
                        KtElement floatValue = ktElement;
                        this.checkFloatValue((PsiElement)floatValue, (KtExpression)expression);
                        unit = Unit.INSTANCE;
                    }
                }
            }
        }
        return unit;
    }

    private final Unit handleBinaryExpression(KtBinaryExpression expression) {
        Unit unit;
        KtBinaryExpression ktBinaryExpression;
        KtBinaryExpression ktBinaryExpression2;
        KtBinaryExpression it = ktBinaryExpression2 = expression;
        boolean bl = false;
        Object object = ktBinaryExpression = CollectionsKt.contains((Iterable)arithmeticOperationTokens, (Object)it.getOperationToken()) ? ktBinaryExpression2 : null;
        if (ktBinaryExpression == null) {
            unit = null;
        } else {
            boolean bl2;
            KtBinaryExpression ktBinaryExpression3;
            block7: {
                KtBinaryExpression it2 = ktBinaryExpression3 = ktBinaryExpression;
                boolean bl3 = false;
                Sequence $this$any$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)((PsiElement)it2));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiElement p0 = (PsiElement)element$iv;
                    boolean bl4 = false;
                    if (!this.isComparisonWithAbs(p0)) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            Object object2 = ktBinaryExpression2 = !bl2 ? ktBinaryExpression3 : null;
            if (ktBinaryExpression2 == null) {
                unit = null;
            } else {
                Object object3;
                KtExpression ktExpression;
                KtExpression ktExpression2;
                KtBinaryExpression $this$handleBinaryExpression_u24lambda_u2d21 = ktBinaryExpression2;
                boolean bl5 = false;
                KtExpression ktExpression3 = $this$handleBinaryExpression_u24lambda_u2d21.getLeft();
                Intrinsics.checkNotNull((Object)ktExpression3);
                KtExpression it3 = ktExpression2 = ktExpression3;
                boolean bl6 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
                Object object4 = ktExpression = AccurateCalculationsRuleKt.access$isFloatingPoint((PsiElement)it3) ? ktExpression2 : null;
                if (ktExpression == null) {
                    KtExpression ktExpression4 = $this$handleBinaryExpression_u24lambda_u2d21.getRight();
                    Intrinsics.checkNotNull((Object)ktExpression4);
                    it3 = ktExpression2 = ktExpression4;
                    boolean bl7 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
                    object3 = AccurateCalculationsRuleKt.access$isFloatingPoint((PsiElement)it3) ? ktExpression2 : null;
                } else {
                    object3 = ktExpression;
                }
                KtExpression floatValue = object3;
                this.checkFloatValue((PsiElement)floatValue, (KtExpression)$this$handleBinaryExpression_u24lambda_u2d21);
                unit = Unit.INSTANCE;
            }
        }
        return unit;
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PsiElement psi = node.getPsi();
        if (psi instanceof KtBinaryExpression) {
            this.handleBinaryExpression((KtBinaryExpression)psi);
        } else if (psi instanceof KtDotQualifiedExpression) {
            this.handleFunction((KtDotQualifiedExpression)psi);
        } else {
            return;
        }
    }

    static {
        Object[] objectArray = new KtSingleValueToken[]{KtTokens.PLUS, KtTokens.PLUSEQ, KtTokens.PLUSPLUS, KtTokens.MINUS, KtTokens.MINUSEQ, KtTokens.MINUSMINUS, KtTokens.MUL, KtTokens.MULTEQ, KtTokens.DIV, KtTokens.DIVEQ, KtTokens.PERC, KtTokens.PERCEQ, KtTokens.GT, KtTokens.LT, KtTokens.LTEQ, KtTokens.GTEQ, KtTokens.EQEQ};
        arithmeticOperationTokens = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new KtSingleValueToken[]{KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ};
        comparisonOperators = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"equals", "compareTo"};
        arithmeticOperationsFunctions = CollectionsKt.listOf((Object[])objectArray);
        comparisonFunctions = CollectionsKt.listOf((Object)"compareTo");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter4/calculations/AccurateCalculationsRule$Companion;", "", "()V", "NAME_ID", "", "arithmeticOperationTokens", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.jvm.PlatformType", "arithmeticOperationsFunctions", "comparisonFunctions", "comparisonOperators", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

