/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000bH\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u000bH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/AsyncAndSyncRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "asyncList", "", "checkRunBlocking", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "logic", "isAsync", "", "isRunBlocking", "isSuspend", "Companion", "diktat-rules"})
public final class AsyncAndSyncRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> asyncList;
    @NotNull
    public static final String NAME_ID = "acf-sync-in-async";

    public AsyncAndSyncRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.RUN_BLOCKING_INSIDE_ASYNC)), null, 8, null);
        Object[] objectArray = new String[]{"async", "launch"};
        this.asyncList = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.isRunBlocking(node)) {
            this.checkRunBlocking(node);
        }
    }

    private final void checkRunBlocking(ASTNode node) {
        ASTNode aSTNode = PackageKt.parent$default((ASTNode)node, (Function1)((Function1)new Function1<ASTNode, Boolean>(this){
            final /* synthetic */ AsyncAndSyncRule this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ASTNode it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return AsyncAndSyncRule.access$isAsync(this.this$0, it) || AsyncAndSyncRule.access$isSuspend(this.this$0, it);
            }
        }), (boolean)false, (int)2, null);
        if (aSTNode != null) {
            ASTNode it = aSTNode;
            boolean bl = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl2 = this.isFixMode();
            String string = node.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
            Warnings.RUN_BLOCKING_INSIDE_ASYNC.warn(list, function3, bl2, string, node.getStartOffset(), node);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAsync(ASTNode $this$isAsync) {
        if (!Intrinsics.areEqual((Object)$this$isAsync.getElementType(), (Object)ElementType.INSTANCE.getCALL_EXPRESSION())) return false;
        ASTNode aSTNode = $this$isAsync.findChildByType(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
        if (!CollectionsKt.contains((Iterable)this.asyncList, (Object)(aSTNode == null ? null : aSTNode.getText()))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuspend(ASTNode $this$isSuspend) {
        boolean bl;
        if (!Intrinsics.areEqual((Object)$this$isSuspend.getElementType(), (Object)ElementType.INSTANCE.getFUN())) return false;
        PsiElement psiElement = $this$isSuspend.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        KtModifierList ktModifierList = ((KtFunction)psiElement).getModifierList();
        if (ktModifierList == null) {
            return false;
        }
        boolean bl2 = bl = PsiUtilsKt.hasSuspendModifier((KtModifierList)ktModifierList);
        if (!bl2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isRunBlocking(ASTNode $this$isRunBlocking) {
        if (!Intrinsics.areEqual((Object)$this$isRunBlocking.getElementType(), (Object)ElementType.INSTANCE.getREFERENCE_EXPRESSION())) return false;
        if (!Intrinsics.areEqual((Object)$this$isRunBlocking.getText(), (Object)"runBlocking")) return false;
        ASTNode aSTNode = $this$isRunBlocking.getTreeParent();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"this.treeParent");
        if (!AstNodeUtilsKt.hasChildOfType(aSTNode, ElementType.INSTANCE.getLAMBDA_ARGUMENT())) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isAsync(AsyncAndSyncRule $this, ASTNode $receiver) {
        return $this.isAsync($receiver);
    }

    public static final /* synthetic */ boolean access$isSuspend(AsyncAndSyncRule $this, ASTNode $receiver) {
        return $this.isSuspend($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/AsyncAndSyncRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

