/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter5.AvoidNestedFunctionsRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00032\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0014\u0010\u0011\u001a\u00020\u0007*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/AvoidNestedFunctionsRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkFunctionReferences", "", "func", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getParameterNames", "", "node", "handleNestedFunctions", "", "isNestedFunction", "logic", "hasFunParentUntil", "stopNode", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "Companion", "diktat-rules"})
public final class AvoidNestedFunctionsRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "acj-avoid-nested-functions";

    public AvoidNestedFunctionsRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.AVOID_NESTED_FUNCTIONS)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN())) {
            this.handleNestedFunctions(node);
        }
    }

    private final void handleNestedFunctions(ASTNode node) {
        if (this.isNestedFunction(node)) {
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            String string = aSTNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getFirstChildWithType(IDENTIFIER)!!.text");
            String funcName = string;
            Warnings.AVOID_NESTED_FUNCTIONS.warnAndFix(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)"fun ", (Object)funcName), node.getStartOffset(), node, this.checkFunctionReferences(node), (Function0<Unit>)((Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    ASTNode lastFunc = (ASTNode)CollectionsKt.last((List)AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(this.$node, ElementType.INSTANCE.getFUN(), false, 2, null));
                    List funcSeq2 = SequencesKt.toMutableList((Sequence)SequencesKt.filter((Sequence)PsiUtilsKt.parents((ASTNode)lastFunc), (Function1)handleNestedFunctions.funcSeq.1.INSTANCE));
                    funcSeq2.add(0, lastFunc);
                    ASTNode firstFunc = (ASTNode)CollectionsKt.last((List)funcSeq2);
                    Iterable $this$forEachIndexed$iv = CollectionsKt.dropLast((List)funcSeq2, (int)1);
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (T item$iv : $this$forEachIndexed$iv) {
                        void it;
                        int n = index$iv;
                        index$iv = n + 1;
                        if (n < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ASTNode aSTNode = (ASTNode)item$iv;
                        int index = n;
                        boolean bl = false;
                        ASTNode parent = (ASTNode)funcSeq2.get(index + 1);
                        if (PackageKt.isWhiteSpaceWithNewline((ASTNode)it.getTreePrev())) {
                            parent.removeChild(it.getTreePrev());
                        }
                        firstFunc.getTreeParent().addChild((ASTNode)it.clone(), firstFunc);
                        firstFunc.getTreeParent().addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)"\n"), firstFunc);
                        parent.removeChild((ASTNode)it);
                    }
                }
            }));
        }
    }

    private final boolean isNestedFunction(ASTNode node) {
        return AstNodeUtilsKt.hasParent(node, ElementType.INSTANCE.getFUN()) && this.hasFunParentUntil(node, ElementType.INSTANCE.getCLASS_BODY()) && !AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getMODIFIER_LIST());
    }

    private final boolean hasFunParentUntil(ASTNode $this$hasFunParentUntil, IElementType stopNode) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.parents((ASTNode)$this$hasFunParentUntil), (Function1)((Function1)new Function1<ASTNode, Boolean>(stopNode){
                final /* synthetic */ IElementType $stopNode;
                {
                    this.$stopNode = $stopNode;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull ASTNode it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !Intrinsics.areEqual((Object)it.getElementType(), (Object)this.$stopNode);
                }
            }));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getFUN())) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkFunctionReferences(ASTNode func) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list;
            List localProperties2 = new ArrayList();
            localProperties2.addAll(AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(func, ElementType.INSTANCE.getPROPERTY(), false, 2, null));
            List $this$checkFunctionReferences_u24lambda_u2d2 = list = (List)new ArrayList();
            boolean bl2 = false;
            Iterable iterable = localProperties2;
            List list2 = $this$checkFunctionReferences_u24lambda_u2d2;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ASTNode aSTNode = (ASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                ASTNode aSTNode2 = AstNodeUtilsKt.getFirstChildWithType((ASTNode)it, ElementType.INSTANCE.getIDENTIFIER());
                Intrinsics.checkNotNull((Object)aSTNode2);
                String string = aSTNode2.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.getFirstChildWithType(IDENTIFIER)!!.text");
                collection.add(string);
            }
            list2.addAll((List)destination$iv$iv);
            $this$checkFunctionReferences_u24lambda_u2d2.addAll((Collection)this.getParameterNames(func));
            List propertiesNames = CollectionsKt.toList((Iterable)list);
            Iterable $this$all$iv = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(func, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ASTNode it = (ASTNode)element$iv;
                    boolean bl4 = false;
                    if (propertiesNames.contains(it.getText())) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getParameterNames(ASTNode node) {
        void $this$mapTo$iv$iv;
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        List list = ((KtFunction)psiElement).getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.psi as KtFunction).valueParameters");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/AvoidNestedFunctionsRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

