/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter5.CheckInverseMethodRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/CheckInverseMethodRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkCallExpressionName", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "logic", "Companion", "diktat-rules"})
public final class CheckInverseMethodRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aay-inverse-method";
    @NotNull
    private static final Map<String, String> methodMap;
    @NotNull
    private static final List<IElementType> intermediateTokens;

    public CheckInverseMethodRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.INVERSE_FUNCTION_PREFERRED)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCALL_EXPRESSION()) && methodMap.keySet().contains(node.getText())) {
            this.checkCallExpressionName(node);
        }
    }

    private final void checkCallExpressionName(ASTNode node) {
        ASTNode operationRef2;
        Object v0;
        block2: {
            ASTNode aSTNode = node.getTreeParent();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node\n            .treeParent");
            Sequence $this$firstOrNull$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((ASTNode)aSTNode, (boolean)false), (Function1)checkCallExpressionName.operationRef.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getOPERATION_REFERENCE())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        ASTNode aSTNode = operationRef2 = (ASTNode)v0;
        if (Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getText()), (Object)"!")) {
            Warnings.warnAndFix$default(Warnings.INVERSE_FUNCTION_PREFERRED, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), methodMap.get(node.getText()) + " instead of !" + node.getText(), node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
                final /* synthetic */ ASTNode $node;
                {
                    this.$node = $node;
                    super(0);
                }

                public final void invoke() {
                    CompositeElement callExpression = new CompositeElement(ElementType.INSTANCE.getCALL_EXPRESSION());
                    CompositeElement referenceExp = new CompositeElement(ElementType.INSTANCE.getREFERENCE_EXPRESSION());
                    CompositeElement argList = new CompositeElement(ElementType.INSTANCE.getVALUE_ARGUMENT_LIST());
                    this.$node.getTreeParent().addChild((ASTNode)callExpression, this.$node);
                    callExpression.addChild((ASTNode)referenceExp);
                    callExpression.addChild((ASTNode)argList);
                    referenceExp.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getIDENTIFIER(), (CharSequence)StringsKt.dropLast((String)String.valueOf(CheckInverseMethodRule.Companion.getMethodMap().get(this.$node.getText())), (int)2)));
                    argList.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getLPAR(), (CharSequence)"("));
                    argList.addChild((ASTNode)new LeafPsiElement(ElementType.INSTANCE.getRPAR(), (CharSequence)")"));
                    this.$node.getTreeParent().getTreeParent().removeChild(this.$node.getTreeParent().getTreePrev());
                    this.$node.getTreeParent().removeChild(this.$node);
                }
            }, 64, null);
        }
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"isEmpty()", (Object)"isNotEmpty()"), TuplesKt.to((Object)"isBlank()", (Object)"isNotBlank()"), TuplesKt.to((Object)"isNotEmpty()", (Object)"isEmpty()"), TuplesKt.to((Object)"isNotBlank()", (Object)"isBlank()")};
        methodMap = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new IElementType[]{ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getOPERATION_REFERENCE(), ElementType.INSTANCE.getBLOCK_COMMENT()};
        intermediateTokens = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/CheckInverseMethodRule$Companion;", "", "()V", "NAME_ID", "", "intermediateTokens", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getIntermediateTokens", "()Ljava/util/List;", "methodMap", "", "getMethodMap", "()Ljava/util/Map;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getMethodMap() {
            return methodMap;
        }

        @NotNull
        public final List<IElementType> getIntermediateTokens() {
            return intermediateTokens;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

