/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize$FunctionArgumentsSizeConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize$FunctionArgumentsSizeConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "checkFun", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "maxParameterSize", "", "logic", "Companion", "FunctionArgumentsSizeConfiguration", "diktat-rules"})
public final class FunctionArgumentsSize
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configuration$delegate;
    public static final long MAX_DEFAULT_PARAMETER_SIZE = 5L;
    @NotNull
    public static final String NAME_ID = "acc-argument-size";

    public FunctionArgumentsSize(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.TOO_MANY_PARAMETERS)), null, 8, null);
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FunctionArgumentsSizeConfiguration>(configRules){
            final /* synthetic */ List<RulesConfig> $configRules;
            {
                this.$configRules = $configRules;
                super(0);
            }

            @NotNull
            public final FunctionArgumentsSizeConfiguration invoke() {
                RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.$configRules, (Rule)Warnings.TOO_MANY_PARAMETERS);
                Map<K, V> map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return new FunctionArgumentsSizeConfiguration(map);
            }
        }));
    }

    private final FunctionArgumentsSizeConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (FunctionArgumentsSizeConfiguration)((Object)lazy.getValue());
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN())) {
            this.checkFun(node, this.getConfiguration().getMaxParameterSize());
        }
    }

    private final void checkFun(ASTNode node, long maxParameterSize) {
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        int parameterListSize = ((KtFunction)psiElement).getValueParameters().size();
        if ((long)parameterListSize > maxParameterSize) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            StringBuilder stringBuilder = new StringBuilder();
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            Warnings.TOO_MANY_PARAMETERS.warn(list, function3, bl, stringBuilder.append(aSTNode.getText()).append(" has ").append(parameterListSize).append(", but allowed ").append(maxParameterSize).toString(), node.getStartOffset(), node);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize$FunctionArgumentsSizeConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxParameterSize", "", "getMaxParameterSize", "()J", "diktat-rules"})
    public static final class FunctionArgumentsSizeConfiguration
    extends RuleConfiguration {
        private final long maxParameterSize;

        public FunctionArgumentsSizeConfiguration(@NotNull Map<String, String> config2) {
            long l;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("maxParameterListSize");
            if (string == null) {
                l = 5L;
            } else {
                Long l2 = StringsKt.toLongOrNull((String)string);
                l = l2 == null ? 5L : l2;
            }
            this.maxParameterSize = l;
        }

        public final long getMaxParameterSize() {
            return this.maxParameterSize;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionArgumentsSize$Companion;", "", "()V", "MAX_DEFAULT_PARAMETER_SIZE", "", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

