/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionLength;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkFun", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionLength$FunctionLengthConfiguration;", "logic", "Companion", "FunctionLengthConfiguration", "diktat-rules"})
public final class FunctionLength
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long MAX_FUNCTION_LENGTH = 30L;
    @NotNull
    public static final String NAME_ID = "abz-function-length";

    public FunctionLength(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.TOO_LONG_FUNCTION)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.getConfigRules(), (Rule)Warnings.TOO_LONG_FUNCTION);
        Map map = rulesConfig == null ? null : rulesConfig.getConfiguration();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        FunctionLengthConfiguration configuration2 = new FunctionLengthConfiguration(map);
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN())) {
            this.checkFun(node, configuration2);
        }
    }

    private final void checkFun(ASTNode node, FunctionLengthConfiguration configuration2) {
        ASTNode aSTNode;
        if (configuration2.isIncludeHeader()) {
            aSTNode = (ASTNode)node.clone();
        } else {
            ASTNode aSTNode2;
            Object object;
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            KtExpression ktExpression = ((KtFunction)psiElement).getBodyExpression();
            Object object2 = ktExpression == null ? null : (object = (aSTNode2 = ktExpression.getNode()) == null ? null : aSTNode2.clone());
            if (object == null) {
                return;
            }
            aSTNode = (ASTNode)object;
        }
        ASTNode copyNode = aSTNode;
        int sizeFun = AstNodeUtilsKt.countCodeLines(copyNode);
        if ((long)sizeFun > configuration2.getMaxFunctionLength()) {
            Warnings.TOO_LONG_FUNCTION.warn(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "max length is " + configuration2.getMaxFunctionLength() + ", but you have " + sizeFun, node.getStartOffset(), node);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionLength$FunctionLengthConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "isIncludeHeader", "", "()Z", "maxFunctionLength", "", "getMaxFunctionLength", "()J", "diktat-rules"})
    public static final class FunctionLengthConfiguration
    extends RuleConfiguration {
        private final long maxFunctionLength;
        private final boolean isIncludeHeader;

        public FunctionLengthConfiguration(@NotNull Map<String, String> config2) {
            boolean bl;
            long l;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("maxFunctionLength");
            this.maxFunctionLength = string == null ? 30L : (l = Long.parseLong(string));
            string = config2.get("isIncludeHeader");
            this.isIncludeHeader = string == null ? true : (bl = Boolean.parseBoolean(string));
        }

        public final long getMaxFunctionLength() {
            return this.maxFunctionLength;
        }

        public final boolean isIncludeHeader() {
            return this.isIncludeHeader;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/FunctionLength$Companion;", "", "()V", "MAX_FUNCTION_LENGTH", "", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

