/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/LambdaLengthRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter5/LambdaLengthRule$LambdaLengthConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/chapter5/LambdaLengthRule$LambdaLengthConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "checkLambda", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "logic", "Companion", "LambdaLengthConfiguration", "diktat-rules"})
public final class LambdaLengthRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configuration$delegate;
    private static final long MAX_LINES_IN_LAMBDA = 10L;
    @NotNull
    public static final String NAME_ID = "acl-lambda-length";

    public LambdaLengthRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.TOO_MANY_LINES_IN_LAMBDA)), null, 8, null);
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LambdaLengthConfiguration>(this){
            final /* synthetic */ LambdaLengthRule this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LambdaLengthConfiguration invoke() {
                RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.this$0.getConfigRules(), (Rule)Warnings.TOO_MANY_LINES_IN_LAMBDA);
                Map<K, V> map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return new LambdaLengthConfiguration(map);
            }
        }));
    }

    private final LambdaLengthConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (LambdaLengthConfiguration)((Object)lazy.getValue());
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getLAMBDA_EXPRESSION())) {
            this.checkLambda(node, this.getConfiguration());
        }
    }

    private final void checkLambda(ASTNode node, LambdaLengthConfiguration configuration2) {
        int sizeLambda = AstNodeUtilsKt.countCodeLines(node);
        if ((long)sizeLambda > configuration2.getMaxLambdaLength() && AstNodeUtilsKt.doesLambdaContainIt(node)) {
            Warnings.TOO_MANY_LINES_IN_LAMBDA.warn(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "max length lambda without arguments is " + configuration2.getMaxLambdaLength() + ", but you have " + sizeLambda, node.getStartOffset(), node);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/LambdaLengthRule$LambdaLengthConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxLambdaLength", "", "getMaxLambdaLength", "()J", "diktat-rules"})
    public static final class LambdaLengthConfiguration
    extends RuleConfiguration {
        private final long maxLambdaLength;

        public LambdaLengthConfiguration(@NotNull Map<String, String> config2) {
            long l;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("maxLambdaLength");
            this.maxLambdaLength = string == null ? 10L : (l = Long.parseLong(string));
        }

        public final long getMaxLambdaLength() {
            return this.maxLambdaLength;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/LambdaLengthRule$Companion;", "", "()V", "MAX_LINES_IN_LAMBDA", "", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

