/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.cqfn.diktat.common.config.rules.Rule;
import org.cqfn.diktat.common.config.rules.RuleConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter5.NestedFunctionBlock;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/NestedFunctionBlock;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "configuration", "Lorg/cqfn/diktat/ruleset/rules/chapter5/NestedFunctionBlock$NestedBlockConfiguration;", "getConfiguration", "()Lorg/cqfn/diktat/ruleset/rules/chapter5/NestedFunctionBlock$NestedBlockConfiguration;", "configuration$delegate", "Lkotlin/Lazy;", "countNestedBlocks", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "maxNestedBlockCount", "", "logic", "Companion", "NestedBlockConfiguration", "diktat-rules"})
public final class NestedFunctionBlock
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configuration$delegate;
    private static final long MAX_NESTED_BLOCK_COUNT = 4L;
    @NotNull
    public static final String NAME_ID = "abn-nested-block";
    @NotNull
    private static final List<IElementType> nullificationType;

    public NestedFunctionBlock(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.NESTED_BLOCK)), null, 8, null);
        this.configuration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NestedBlockConfiguration>(configRules){
            final /* synthetic */ List<RulesConfig> $configRules;
            {
                this.$configRules = $configRules;
                super(0);
            }

            @NotNull
            public final NestedBlockConfiguration invoke() {
                RulesConfig rulesConfig = RulesConfigReaderKt.getRuleConfig(this.$configRules, (Rule)Warnings.NESTED_BLOCK);
                Map<K, V> map = rulesConfig == null ? null : rulesConfig.getConfiguration();
                if (map == null) {
                    map = MapsKt.emptyMap();
                }
                return new NestedBlockConfiguration(map);
            }
        }));
    }

    private final NestedBlockConfiguration getConfiguration() {
        Lazy lazy = this.configuration$delegate;
        return (NestedBlockConfiguration)((Object)lazy.getValue());
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (nullificationType.contains(node.getElementType())) {
            this.countNestedBlocks(node, this.getConfiguration().getMaxNestedBlockQuantity());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void countNestedBlocks(ASTNode node, long maxNestedBlockCount) {
        void $this$forEach$iv;
        Iterable iterable = CollectionsKt.reversed((Iterable)AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getLBRACE(), false, 2, null));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            Object object2;
            Sequence sequence;
            boolean bl;
            Sequence sequence2;
            block7: {
                ASTNode lbraceNode = (ASTNode)element$iv;
                boolean bl2 = false;
                Sequence parentList = sequence2 = SequencesKt.takeWhile((Sequence)PsiUtilsKt.parents((ASTNode)lbraceNode), (Function1)((Function1)new Function1<ASTNode, Boolean>(node){
                    final /* synthetic */ ASTNode $node;
                    {
                        this.$node = $node;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull ASTNode it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return !Intrinsics.areEqual((Object)it, (Object)this.$node);
                    }
                }));
                boolean bl3 = false;
                Sequence $this$none$iv = SequencesKt.map((Sequence)parentList, (Function1)countNestedBlocks.1.blockParent.2.1.INSTANCE);
                boolean $i$f$none = false;
                for (Object element$iv2 : $this$none$iv) {
                    IElementType it = (IElementType)element$iv2;
                    boolean bl4 = false;
                    if (!nullificationType.contains(it)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            Object object3 = sequence = bl ? sequence2 : null;
            if (sequence == null) {
                object2 = null;
            } else {
                void $this$count$iv;
                sequence2 = sequence;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (Object element$iv3 : $this$count$iv) {
                    ASTNode it = (ASTNode)element$iv3;
                    boolean bl5 = false;
                    if (!AstNodeUtilsKt.hasChildOfType(it, ElementType.INSTANCE.getLBRACE()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                object2 = object = Integer.valueOf(count$iv);
            }
            if (object == null) {
                return;
            }
            int blockParent2 = (Integer)object;
            if ((long)blockParent2 <= maxNestedBlockCount) continue;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl6 = this.isFixMode();
            ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
            String string = aSTNode == null ? null : aSTNode.getText();
            if (string == null) {
                string = node.getText();
            }
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"node.findChildByType(IDE\u2026IFIER)?.text ?: node.text");
            Warnings.NESTED_BLOCK.warn(list, function3, bl6, (String)object, node.getStartOffset(), node);
            return;
        }
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getCLASS(), ElementType.INSTANCE.getFUN(), ElementType.INSTANCE.getOBJECT_DECLARATION(), ElementType.INSTANCE.getFUNCTION_LITERAL()};
        nullificationType = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/NestedFunctionBlock$NestedBlockConfiguration;", "Lorg/cqfn/diktat/common/config/rules/RuleConfiguration;", "config", "", "", "(Ljava/util/Map;)V", "maxNestedBlockQuantity", "", "getMaxNestedBlockQuantity", "()J", "diktat-rules"})
    public static final class NestedBlockConfiguration
    extends RuleConfiguration {
        private final long maxNestedBlockQuantity;

        public NestedBlockConfiguration(@NotNull Map<String, String> config2) {
            long l;
            Intrinsics.checkNotNullParameter(config2, (String)"config");
            super(config2);
            String string = config2.get("maxNestedBlockQuantity");
            this.maxNestedBlockQuantity = string == null ? 4L : (l = Long.parseLong(string));
        }

        public final long getMaxNestedBlockQuantity() {
            return this.maxNestedBlockQuantity;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/NestedFunctionBlock$Companion;", "", "()V", "MAX_NESTED_BLOCK_COUNT", "", "NAME_ID", "", "nullificationType", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

