/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter5.OverloadingArgumentsFunction;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/OverloadingArgumentsFunction;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkFun", "", "funPsi", "Lorg/jetbrains/kotlin/psi/KtFunction;", "logic", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "Companion", "diktat-rules"})
public final class OverloadingArgumentsFunction
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aby-overloading-default-values";

    public OverloadingArgumentsFunction(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.WRONG_OVERLOADING_FUNCTION_ARGUMENTS)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFUN())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
            }
            this.checkFun((KtFunction)psiElement);
        }
    }

    private final void checkFun(KtFunction funPsi) {
        Object object = funPsi.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"funPsi\n            .node");
        List allOverloadFunction2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)AstNodeUtilsKt.allSiblings(object, false)), (Function1)checkFun.allOverloadFunction.1.INSTANCE), (Function1)checkFun.allOverloadFunction.2.INSTANCE), (Function1)((Function1)new Function1<KtFunction, Boolean>(funPsi){
            final /* synthetic */ KtFunction $funPsi;
            {
                this.$funPsi = $funPsi;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull KtFunction it) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                PsiElement psiElement = it.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement);
                String string = psiElement.getText();
                PsiElement psiElement2 = this.$funPsi.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement2);
                if (Intrinsics.areEqual((Object)string, (Object)psiElement2.getText())) {
                    List list = it.getValueParameters();
                    List list2 = this.$funPsi.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"funPsi.valueParameters");
                    if (list.containsAll(list2)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        })), (Function1)((Function1)new Function1<KtFunction, Boolean>(funPsi){
            final /* synthetic */ KtFunction $funPsi;
            {
                this.$funPsi = $funPsi;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ASTNode aSTNode = this.$funPsi.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"funPsi.node");
                ASTNode aSTNode2 = AstNodeUtilsKt.findChildBefore(aSTNode, ElementType.INSTANCE.getIDENTIFIER(), ElementType.INSTANCE.getTYPE_REFERENCE());
                String string = aSTNode2 == null ? null : aSTNode2.getText();
                aSTNode = it.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
                ASTNode aSTNode3 = AstNodeUtilsKt.findChildBefore(aSTNode, ElementType.INSTANCE.getIDENTIFIER(), ElementType.INSTANCE.getTYPE_REFERENCE());
                return Intrinsics.areEqual((Object)string, (Object)(aSTNode3 == null ? null : aSTNode3.getText()));
            }
        })), (Function1)((Function1)new Function1<KtFunction, Boolean>(funPsi){
            final /* synthetic */ KtFunction $funPsi;
            {
                this.$funPsi = $funPsi;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtFunction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ASTNode aSTNode = this.$funPsi.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"funPsi.node");
                ASTNode aSTNode2 = AstNodeUtilsKt.findChildAfter(aSTNode, ElementType.INSTANCE.getIDENTIFIER(), ElementType.INSTANCE.getTYPE_REFERENCE());
                String string = aSTNode2 == null ? null : aSTNode2.getText();
                aSTNode = it.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"it.node");
                ASTNode aSTNode3 = AstNodeUtilsKt.findChildAfter(aSTNode, ElementType.INSTANCE.getIDENTIFIER(), ElementType.INSTANCE.getTYPE_REFERENCE());
                return Intrinsics.areEqual((Object)string, (Object)(aSTNode3 == null ? null : aSTNode3.getText()));
            }
        })));
        if (!((Collection)allOverloadFunction2).isEmpty()) {
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl = this.isFixMode();
            ASTNode aSTNode = funPsi.getNode().findChildByType(ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            object = aSTNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"funPsi.node.findChildByType(IDENTIFIER)!!.text");
            Object object2 = object;
            int n = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)funPsi));
            object = funPsi.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"funPsi.node");
            Warnings.WRONG_OVERLOADING_FUNCTION_ARGUMENTS.warn(list, (Function3<? super Integer, ? super String, ? super Boolean, Unit>)function3, bl, (String)object2, n, (ASTNode)object);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/OverloadingArgumentsFunction$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

