/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter5;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter5/ParameterNameInOuterLambdaRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkLambda", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "logic", "diktat-rules"})
public final class ParameterNameInOuterLambdaRule
extends DiktatRule {
    public ParameterNameInOuterLambdaRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super("parameter-name-in-outer-lambda", configRules, CollectionsKt.listOf((Object)((Object)Warnings.PARAMETER_NAME_IN_OUTER_LAMBDA)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getLAMBDA_EXPRESSION())) {
            this.checkLambda(node);
        }
    }

    private final void checkLambda(ASTNode node) {
        boolean hasInnerLambda;
        boolean bl = hasInnerLambda = !((Collection)AstNodeUtilsKt.findAllDescendantsWithSpecificType(node, ElementType.INSTANCE.getLAMBDA_EXPRESSION(), false)).isEmpty();
        if (hasInnerLambda && AstNodeUtilsKt.doesLambdaContainIt(node)) {
            Warnings.PARAMETER_NAME_IN_OUTER_LAMBDA.warn(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), "lambda without arguments has inner lambda", node.getStartOffset(), node);
        }
    }
}

