/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/AvoidEmptyPrimaryConstructor;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkClass", "", "ktClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "logic", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "Companion", "diktat-rules"})
public final class AvoidEmptyPrimaryConstructor
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aao-avoid-empty-primary-constructor";

    public AvoidEmptyPrimaryConstructor(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.EMPTY_PRIMARY_CONSTRUCTOR)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCLASS())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            }
            this.checkClass((KtClass)psiElement);
        }
    }

    private final void checkClass(KtClass ktClass) {
        List list;
        KtPrimaryConstructor ktPrimaryConstructor = ktClass.getPrimaryConstructor();
        if (!(ktPrimaryConstructor == null ? false : ((list = ktPrimaryConstructor.getValueParameters()) == null ? false : !(!((Collection)list).isEmpty()))) || ktClass.getPrimaryConstructorModifierList() != null) {
            return;
        }
        List<RulesConfig> list2 = this.getConfigRules();
        Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
        boolean bl = this.isFixMode();
        PsiElement psiElement = ktClass.getNameIdentifier();
        Intrinsics.checkNotNull((Object)psiElement);
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ktClass.nameIdentifier!!.text");
        String string2 = string;
        int n = ktClass.getNode().getStartOffset();
        string = ktClass.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ktClass.node");
        Warnings.warnAndFix$default(Warnings.EMPTY_PRIMARY_CONSTRUCTOR, list2, function3, bl, string2, n, (ASTNode)string, false, (Function0)new Function0<Unit>(ktClass){
            final /* synthetic */ KtClass $ktClass;
            {
                this.$ktClass = $ktClass;
                super(0);
            }

            public final void invoke() {
                ASTNode aSTNode = this.$ktClass.getNode();
                KtPrimaryConstructor ktPrimaryConstructor = this.$ktClass.getPrimaryConstructor();
                Intrinsics.checkNotNull((Object)ktPrimaryConstructor);
                aSTNode.removeChild(ktPrimaryConstructor.getNode());
            }
        }, 64, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/AvoidEmptyPrimaryConstructor$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

