/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.CommonConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.FileUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/AvoidUtilityClass;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkClass", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "logic", "Companion", "diktat-rules"})
public final class AvoidUtilityClass
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "abe-avoid-utility-class";
    @NotNull
    private static final List<IElementType> utilityClassChildren;

    public AvoidUtilityClass(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.AVOID_USING_UTILITY_CLASS)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CommonConfiguration config2 = RulesConfigReaderKt.getCommonConfiguration(this.getConfigRules());
        String filePath = AstNodeUtilsKt.getFilePath(node);
        if (!AstNodeUtilsKt.hasTestAnnotation(node) && !AstNodeUtilsKt.isLocatedInTest(FileUtilsKt.splitPathToDirs(filePath), config2.getTestAnchors()) && (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getOBJECT_DECLARATION()) || Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCLASS()))) {
            this.checkClass(node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkClass(ASTNode node) {
        Object object;
        String string;
        Locale locale;
        String string2;
        block21: {
            block20: {
                if (!AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getIDENTIFIER()) || AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getPRIMARY_CONSTRUCTOR())) break block20;
                ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
                Intrinsics.checkNotNull((Object)aSTNode);
                string2 = aSTNode.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.findChildByType(IDENTIFIER)!!.text");
                locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                string = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"util", (boolean)false, (int)2, null)) break block21;
            }
            return;
        }
        locale = node.findChildByType(ElementType.INSTANCE.getCLASS_BODY());
        if (locale == null) {
            object = null;
        } else {
            string = PsiUtilsKt.children((ASTNode)locale);
            if (string == null) {
                object = null;
            } else {
                List list = SequencesKt.toList((Sequence)string);
                if (list == null) {
                    object = null;
                } else {
                    List list2;
                    boolean bl;
                    Iterable $this$all$iv;
                    Iterable childList;
                    List list3;
                    block19: {
                        childList = list3 = list;
                        boolean bl2 = false;
                        $this$all$iv = childList;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                ASTNode it = (ASTNode)element$iv;
                                boolean bl3 = false;
                                if (utilityClassChildren.contains(it.getElementType())) continue;
                                bl = false;
                                break block19;
                            }
                            bl = true;
                        }
                    }
                    List list4 = list2 = bl ? list3 : null;
                    if (list2 == null) {
                        object = null;
                    } else {
                        void $this$filterTo$iv$iv;
                        void $this$filter$iv;
                        childList = list2;
                        boolean $i$f$filter = false;
                        $this$all$iv = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            ASTNode it = (ASTNode)element$iv$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getFUN())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        list3 = (List)destination$iv$iv;
                        Collection collection = list3;
                        if (collection.isEmpty()) {
                            boolean bl5 = false;
                            return;
                        }
                        object = string2 = (List)collection;
                    }
                }
            }
        }
        if (string2 == null) {
            return;
        }
        List<RulesConfig> list = this.getConfigRules();
        Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
        boolean bl = this.isFixMode();
        ASTNode aSTNode = node.findChildByType(ElementType.INSTANCE.getIDENTIFIER());
        String string3 = aSTNode == null ? null : aSTNode.getText();
        if (string3 == null) {
            string3 = node.getText();
        }
        string2 = string3;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"node.findChildByType(IDE\u2026IFIER)?.text ?: node.text");
        Warnings.AVOID_USING_UTILITY_CLASS.warn(list, function3, bl, string2, node.getStartOffset(), node);
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getLBRACE(), ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getFUN(), ElementType.INSTANCE.getRBRACE(), ElementType.INSTANCE.getKDOC(), ElementType.INSTANCE.getEOL_COMMENT(), ElementType.INSTANCE.getBLOCK_COMMENT(), ElementType.INSTANCE.getOBJECT_DECLARATION()};
        utilityClassChildren = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/AvoidUtilityClass$Companion;", "", "()V", "NAME_ID", "", "utilityClassChildren", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

