/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/CustomGetterSetterRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "checkForCustomGetersSetters", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "logic", "Companion", "diktat-rules"})
public final class CustomGetterSetterRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aat-custom-getter-setter";

    public CustomGetterSetterRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.CUSTOM_GETTERS_SETTERS)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY_ACCESSOR())) {
            this.checkForCustomGetersSetters(node);
        }
    }

    private final void checkForCustomGetersSetters(ASTNode node) {
        String string;
        ASTNode it;
        boolean bl;
        ASTNode getter = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getGET_KEYWORD());
        ASTNode setter = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getSET_KEYWORD());
        ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getMODIFIER_LIST());
        if (aSTNode == null) {
            bl = false;
        } else {
            boolean bl2;
            IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getPRIVATE_KEYWORD()};
            bl = bl2 = AstNodeUtilsKt.hasAnyChildOfTypes(aSTNode, iElementTypeArray);
        }
        boolean isPrivateSetter = bl;
        ASTNode aSTNode2 = setter;
        if (aSTNode2 != null) {
            it = aSTNode2;
            boolean bl3 = false;
            if (!isPrivateSetter) {
                List<RulesConfig> list = this.getConfigRules();
                Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                boolean bl4 = this.isFixMode();
                string = setter.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setter.text");
                Warnings.CUSTOM_GETTERS_SETTERS.warn(list, function3, bl4, string, setter.getStartOffset(), node);
            }
        }
        ASTNode aSTNode3 = getter;
        if (aSTNode3 != null) {
            it = aSTNode3;
            boolean bl5 = false;
            List<RulesConfig> list = this.getConfigRules();
            Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
            boolean bl6 = this.isFixMode();
            string = getter.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getter.text");
            Warnings.CUSTOM_GETTERS_SETTERS.warn(list, function3, bl6, string, getter.getStartOffset(), node);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/CustomGetterSetterRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

