/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/ExtensionFunctionsInFileRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "collectAllClassNames", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "collectAllExtensionFunctionsWithSameClassName", "classNames", "fireWarning", "", "isExtensionFunctionWithClassName", "", "logic", "Companion", "diktat-rules"})
public final class ExtensionFunctionsInFileRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aax-extension-functions-class-file";

    public ExtensionFunctionsInFileRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.EXTENSION_FUNCTION_WITH_CLASS)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getFILE())) {
            List<String> classNames = this.collectAllClassNames(node);
            Iterable $this$forEach$iv = this.collectAllExtensionFunctionsWithSameClassName(node, classNames);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                this.fireWarning(it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> collectAllClassNames(ASTNode node) {
        void $this$mapTo$iv$iv;
        List classes = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getCLASS(), false, 2, null);
        Iterable $this$map$iv = classes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ASTNode aSTNode = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiElement psiElement = it.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            }
            String string = ((KtClass)psiElement).getName();
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    private final void fireWarning(ASTNode node) {
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        Warnings.EXTENSION_FUNCTION_WITH_CLASS.warn(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), Intrinsics.stringPlus((String)"fun ", (Object)((KtFunction)psiElement).getName()), node.getStartOffset(), node);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ASTNode> collectAllExtensionFunctionsWithSameClassName(ASTNode node, List<String> classNames) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getFUN());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ASTNode it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!this.isExtensionFunctionWithClassName(it, classNames)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isExtensionFunctionWithClassName(ASTNode node, List<String> classNames) {
        ASTNode aSTNode;
        Iterable iterable;
        block1: {
            Iterable iterable2 = classNames;
            ASTNode aSTNode2 = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode2);
            ASTNode aSTNode3 = aSTNode2;
            iterable = iterable2;
            boolean $i$f$prevSibling = false;
            for (ASTNode n$iv = $this$prevSibling$iv.getTreePrev(); n$iv != null; n$iv = n$iv.getTreePrev()) {
                ASTNode it = n$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getElementType(), (Object)ElementType.INSTANCE.getTYPE_REFERENCE())) continue;
                aSTNode = n$iv;
                break block1;
            }
            aSTNode = null;
        }
        return CollectionsKt.contains((Iterable)iterable, (Object)(aSTNode == null ? null : aSTNode.getText()));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/ExtensionFunctionsInFileRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

