/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J&\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u0002J<\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00032\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0003H\u0002J&\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u001e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/ImplicitBackingPropertyRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "findAllProperties", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handleGetAccessors", "accessor", "propsWithBackSymbol", "", "handleReferenceExpressions", "expressions", "backingPropertiesNames", "localProperties", "handleSetAccessors", "logic", "raiseWarning", "propName", "validateAccessors", "Companion", "diktat-rules"})
public final class ImplicitBackingPropertyRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aba-implicit-backing-property";

    public ImplicitBackingPropertyRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.NO_CORRESPONDING_PROPERTY)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCLASS_BODY())) {
            this.findAllProperties(node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findAllProperties(ASTNode node) {
        void $this$forEach$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        ASTNode it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$filterTo$iv$iv2;
        ASTNode[] aSTNodeArray = node.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"node.getChildren(null)");
        Object[] $this$filter$iv2 = aSTNodeArray;
        boolean $i$f$filter22 = false;
        Object[] objectArray = $this$filter$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv2) {
            ASTNode it2 = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it2.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        Iterable $i$f$filter22 = properties;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(it, ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            String string = aSTNode.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.getFirstChildWithType(IDENTIFIER)!!.text");
            if (!StringsKt.startsWith$default((String)string, (String)"_", (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(it, ElementType.INSTANCE.getIDENTIFIER());
            Intrinsics.checkNotNull((Object)aSTNode);
            collection.add(aSTNode.getText());
        }
        List propsWithBackSymbol = (List)destination$iv$iv2;
        $this$filter$iv = properties;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            IElementType[] iElementTypeArray = new IElementType[]{ElementType.INSTANCE.getPROPERTY_ACCESSOR()};
            if (!AstNodeUtilsKt.hasAnyChildOfTypes(it, iElementTypeArray)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it3 = (ASTNode)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
            this.validateAccessors(it3, propsWithBackSymbol);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateAccessors(ASTNode node, List<String> propsWithBackSymbol) {
        void $this$forEach$iv;
        ASTNode it;
        Object element$iv$iv;
        Object $this$filterTo$iv$iv;
        Iterable $this$filter$iv = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getPROPERTY_ACCESSOR(), false, 2, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!AstNodeUtilsKt.hasChildOfType(it, ElementType.INSTANCE.getBLOCK())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List accessors = (List)destination$iv$iv;
        $this$filter$iv = accessors;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (!AstNodeUtilsKt.hasChildOfType(it, ElementType.INSTANCE.getGET_KEYWORD())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it2 = (ASTNode)element$iv;
            boolean bl = false;
            this.handleGetAccessors(it2, node, propsWithBackSymbol);
        }
        $this$filter$iv = accessors;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (ASTNode)element$iv$iv;
            boolean bl2 = false;
            if (!AstNodeUtilsKt.hasChildOfType(it, ElementType.INSTANCE.getSET_KEYWORD())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it3 = (ASTNode)element$iv;
            boolean bl3 = false;
            this.handleSetAccessors(it3, node, propsWithBackSymbol);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleGetAccessors(ASTNode accessor, ASTNode node, List<String> propsWithBackSymbol) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        ASTNode it;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        Iterable iterable = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(accessor, ElementType.INSTANCE.getRETURN(), false, 2, null);
        boolean $i$f$filterNot = false;
        void var7_7 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            if (AstNodeUtilsKt.hasChildOfType(it, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap22 = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ASTNode)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(it, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List refExprs = (List)destination$iv$iv;
        Iterable $i$f$flatMap22 = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(accessor, ElementType.INSTANCE.getPROPERTY(), false, 2, null);
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ASTNode bl = (ASTNode)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            PsiElement psiElement = it2.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            String string = ((KtProperty)psiElement).getName();
            Intrinsics.checkNotNull((Object)string);
            collection.add(string);
        }
        List localProps = (List)destination$iv$iv2;
        if (!((Collection)refExprs).isEmpty()) {
            this.handleReferenceExpressions(node, refExprs, propsWithBackSymbol, localProps);
        }
    }

    private final void handleSetAccessors(ASTNode accessor, ASTNode node, List<String> propsWithBackSymbol) {
        List refExprs = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(accessor, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null);
        if (!((Collection)refExprs).isEmpty()) {
            this.handleReferenceExpressions(node, refExprs, propsWithBackSymbol, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void handleReferenceExpressions(ASTNode node, List<? extends ASTNode> expressions, List<String> backingPropertiesNames, List<String> localProperties2) {
        boolean bl;
        Iterable $this$none$iv = expressions;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                boolean bl2;
                ASTNode it = (ASTNode)element$iv;
                boolean bl3 = false;
                if (backingPropertiesNames.contains(it.getText())) return;
                if (Intrinsics.areEqual((Object)it.getText(), (Object)"field")) return;
                List<String> list = localProperties2;
                if (list == null) {
                    bl2 = false;
                } else {
                    if (list.contains(it.getText())) {
                        return;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return;
                }
                boolean bl4 = false;
                if (!bl4) continue;
                return;
            }
            bl = true;
        }
        if (!bl) return;
        ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getIDENTIFIER());
        Intrinsics.checkNotNull((Object)aSTNode);
        String string = aSTNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getFirstChildWithType(IDENTIFIER)!!.text");
        this.raiseWarning(node, string);
    }

    private final void raiseWarning(ASTNode node, String propName) {
        Warnings.NO_CORRESPONDING_PROPERTY.warn(this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), propName + " has no corresponding property with name _" + propName, node.getStartOffset(), node);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/ImplicitBackingPropertyRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

