/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.cqfn.diktat.ruleset.utils.FileUtilsKt;
import org.cqfn.diktat.ruleset.utils.KotlinParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002Ji\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u000e2O\u0010\u0019\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u0006\u001aK\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u0007j\u0002`\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/RunInScript;", "Lcom/pinterest/ktlint/core/Rule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "emitWarn", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "", "canBeAutoCorrected", "", "Lorg/cqfn/diktat/ruleset/constants/EmitType;", "isFixMode", "checkGradleNode", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "checkScript", "visit", "autoCorrect", "emit", "warnRunInScript", "Companion", "diktat-rules"})
public final class RunInScript
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<RulesConfig> configRules;
    private boolean isFixMode;
    private Function3<? super Integer, ? super String, ? super Boolean, Unit> emitWarn;
    @NotNull
    public static final String NAME_ID = "abw-run-script";

    public RunInScript(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, null, 2, null);
        this.configRules = configRules;
    }

    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(emit, (String)"emit");
        this.isFixMode = autoCorrect;
        this.emitWarn = emit;
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getSCRIPT_INITIALIZER()) && FileUtilsKt.isKotlinScript(AstNodeUtilsKt.getFilePath(node))) {
            if (FileUtilsKt.isGradleScript(AstNodeUtilsKt.getFilePath(node))) {
                this.checkGradleNode(node);
            } else {
                this.checkScript(node);
            }
        }
    }

    private final void checkGradleNode(ASTNode node) {
        if (AstNodeUtilsKt.hasEqBinaryExpression(node)) {
            return;
        }
        ASTNode astNode = Intrinsics.areEqual((Object)node.getFirstChildNode().getElementType(), (Object)ElementType.INSTANCE.getPARENTHESIZED()) ? node.getFirstChildNode() : node;
        Intrinsics.checkNotNullExpressionValue((Object)astNode, (String)"astNode");
        if (!AstNodeUtilsKt.hasChildOfType(astNode, ElementType.INSTANCE.getCALL_EXPRESSION()) && !AstNodeUtilsKt.hasChildOfType(astNode, ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) {
            this.warnRunInScript(astNode);
        }
    }

    private final void checkScript(ASTNode node) {
        boolean isLambdaInsideValueArgument;
        ASTNode aSTNode;
        ASTNode aSTNode2 = node.getFirstChildNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"node.firstChildNode");
        boolean isLambdaArgument = AstNodeUtilsKt.hasChildOfType(aSTNode2, ElementType.INSTANCE.getLAMBDA_ARGUMENT());
        ASTNode aSTNode3 = node.getFirstChildNode().findChildByType(ElementType.INSTANCE.getVALUE_ARGUMENT_LIST());
        if (aSTNode3 == null) {
            aSTNode = null;
        } else {
            ASTNode aSTNode4 = aSTNode3.findChildByType(ElementType.INSTANCE.getVALUE_ARGUMENT());
            aSTNode = aSTNode4 == null ? null : aSTNode4.findChildByType(ElementType.INSTANCE.getLAMBDA_EXPRESSION());
        }
        boolean bl = isLambdaInsideValueArgument = aSTNode != null;
        if (!isLambdaArgument && !isLambdaInsideValueArgument) {
            this.warnRunInScript(node);
        }
    }

    private final void warnRunInScript(ASTNode node) {
        Function3<? super Integer, ? super String, ? super Boolean, Unit> function3 = this.emitWarn;
        if (function3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emitWarn");
            function3 = null;
        }
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        Warnings.warnAndFix$default(Warnings.RUN_IN_SCRIPT, this.configRules, function3, this.isFixMode, string, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
            final /* synthetic */ ASTNode $node;
            {
                this.$node = $node;
                super(0);
            }

            public final void invoke() {
                if (!Intrinsics.areEqual((Object)this.$node.getFirstChildNode().getElementType(), (Object)ElementType.INSTANCE.getDOT_QUALIFIED_EXPRESSION())) {
                    ASTNode parent = this.$node.getTreeParent();
                    ASTNode newNode = KotlinParser.createNode$default(new KotlinParser(), "run {\n " + this.$node.getText() + "\n} \n", false, 2, null);
                    CompositeElement newScript = new CompositeElement(ElementType.INSTANCE.getSCRIPT_INITIALIZER());
                    parent.addChild((ASTNode)newScript, this.$node);
                    newScript.addChild(newNode);
                    parent.removeChild(this.$node);
                }
            }
        }, 64, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/RunInScript$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

