/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/TrivialPropertyAccessors;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "handleGetAccessor", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "handlePropertyAccessors", "handleSetAccessor", "logic", "raiseWarning", "Companion", "diktat-rules"})
public final class TrivialPropertyAccessors
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aas-trivial-property-accessors";
    private static final int ONE_CHILD_IN_ARRAY = 1;
    @NotNull
    private static final List<IElementType> excessChildrenTypes;

    public TrivialPropertyAccessors(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getPROPERTY_ACCESSOR())) {
            this.handlePropertyAccessors(node);
        }
    }

    private final void handlePropertyAccessors(ASTNode node) {
        PsiElement psiElement = node.getPsi();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPropertyAccessor");
        }
        if (((KtPropertyAccessor)psiElement).isGetter()) {
            this.handleGetAccessor(node);
        } else {
            this.handleSetAccessor(node);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleSetAccessor(ASTNode node) {
        ASTNode[] aSTNodeArray;
        String valueParamName;
        ASTNode aSTNode;
        Object object = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getVALUE_PARAMETER_LIST());
        String string = object == null ? null : ((aSTNode = object.getFirstChildNode()) == null ? null : (valueParamName = (aSTNodeArray = AstNodeUtilsKt.getIdentifierName(aSTNode)) == null ? null : aSTNodeArray.getText()));
        if (AstNodeUtilsKt.hasChildOfType(node, ElementType.INSTANCE.getBLOCK()) && !((object = (CharSequence)valueParamName) == null || object.length() == 0)) {
            void $this$filterTo$iv$iv;
            ASTNode aSTNode2 = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getBLOCK());
            Intrinsics.checkNotNull((Object)aSTNode2);
            ASTNode block = aSTNode2;
            aSTNodeArray = block.getChildren(null);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"block.getChildren(null)");
            Object[] $this$filter$iv = aSTNodeArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                ASTNode it = (ASTNode)element$iv$iv;
                boolean bl = false;
                if (!(!excessChildrenTypes.contains(it.getElementType()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List blockChildren = (List)destination$iv$iv;
            if (blockChildren.size() == 1 && Intrinsics.areEqual((Object)((ASTNode)CollectionsKt.first((List)blockChildren)).getElementType(), (Object)ElementType.INSTANCE.getBINARY_EXPRESSION())) {
                PsiElement psiElement = ((ASTNode)CollectionsKt.first((List)blockChildren)).getPsi();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                KtExpression ktExpression = ((KtBinaryExpression)psiElement).getLeft();
                if (Intrinsics.areEqual((Object)(ktExpression == null ? null : ktExpression.getText()), (Object)"field")) {
                    PsiElement psiElement2 = ((ASTNode)CollectionsKt.first((List)blockChildren)).getPsi();
                    if (psiElement2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                    }
                    KtExpression ktExpression2 = ((KtBinaryExpression)psiElement2).getRight();
                    if (Intrinsics.areEqual((Object)(ktExpression2 == null ? null : ktExpression2.getText()), (Object)valueParamName)) {
                        this.raiseWarning(node);
                    }
                }
            }
        }
    }

    private final void handleGetAccessor(ASTNode node) {
        List references = AstNodeUtilsKt.findAllDescendantsWithSpecificType$default(node, ElementType.INSTANCE.getREFERENCE_EXPRESSION(), false, 2, null);
        ASTNode aSTNode = (ASTNode)CollectionsKt.singleOrNull((List)references);
        if (Intrinsics.areEqual((Object)(aSTNode == null ? null : aSTNode.getText()), (Object)"field")) {
            this.raiseWarning(node);
        } else if (node.getChildren(null).length == 1) {
            this.raiseWarning(node);
        }
    }

    private final void raiseWarning(ASTNode node) {
        List<RulesConfig> list = this.getConfigRules();
        Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
        boolean bl = this.isFixMode();
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.text");
        Warnings.warnAndFix$default(Warnings.TRIVIAL_ACCESSORS_ARE_NOT_RECOMMENDED, list, function3, bl, string, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(node){
            final /* synthetic */ ASTNode $node;
            {
                this.$node = $node;
                super(0);
            }

            public final void invoke() {
                PsiElement psiElement = this.$node.getPsi();
                if (psiElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPropertyAccessor");
                }
                ASTNode aSTNode = ((KtPropertyAccessor)psiElement).getProperty().getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"node.psi as KtPropertyAccessor).property.node");
                ASTNode property = aSTNode;
                if (PackageKt.isWhiteSpace((ASTNode)this.$node.getTreePrev())) {
                    property.removeChild(this.$node.getTreePrev());
                }
                property.removeChild(this.$node);
            }
        }, 64, null);
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getLBRACE(), ElementType.INSTANCE.getRBRACE(), ElementType.INSTANCE.getWHITE_SPACE(), ElementType.INSTANCE.getEOL_COMMENT(), ElementType.INSTANCE.getBLOCK_COMMENT()};
        excessChildrenTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/TrivialPropertyAccessors$Companion;", "", "()V", "NAME_ID", "", "ONE_CHILD_IN_ARRAY", "", "excessChildrenTypes", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

