/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6.classes;

import com.pinterest.ktlint.core.ast.ElementType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.rules.chapter6.classes.AbstractClassesRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\tH\u0002J\f\u0010\u000e\u001a\u00020\r*\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/classes/AbstractClassesRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "handleAbstractClass", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "classNode", "logic", "hasAbstractModifier", "", "isNotSubclass", "Companion", "diktat-rules"})
public final class AbstractClassesRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "abg-abstract-classes";

    public AbstractClassesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.CLASS_SHOULD_NOT_BE_ABSTRACT)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCLASS())) {
            ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getCLASS_BODY());
            if (aSTNode == null) {
                return;
            }
            ASTNode classBody = aSTNode;
            if (this.hasAbstractModifier(node) && this.isNotSubclass(node)) {
                this.handleAbstractClass(classBody, node);
            }
        }
    }

    private final boolean hasAbstractModifier(ASTNode $this$hasAbstractModifier) {
        boolean bl;
        ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType($this$hasAbstractModifier, ElementType.INSTANCE.getMODIFIER_LIST());
        return aSTNode == null ? false : (bl = AstNodeUtilsKt.hasChildOfType(aSTNode, ElementType.INSTANCE.getABSTRACT_KEYWORD()));
    }

    private final boolean isNotSubclass(ASTNode $this$isNotSubclass) {
        boolean bl;
        Sequence sequence;
        Sequence sequence2;
        ASTNode aSTNode = $this$isNotSubclass.findChildByType(ElementType.INSTANCE.getSUPER_TYPE_LIST());
        return aSTNode == null ? true : ((sequence2 = PsiUtilsKt.children((ASTNode)aSTNode)) == null ? true : ((sequence = SequencesKt.filter((Sequence)sequence2, (Function1)isNotSubclass.1.INSTANCE)) == null ? true : (bl = SequencesKt.none((Sequence)sequence))));
    }

    private final void handleAbstractClass(ASTNode node, ASTNode classNode2) {
        List<ASTNode> functions = AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getFUN());
        List<ASTNode> properties = AstNodeUtilsKt.getAllChildrenWithType(node, ElementType.INSTANCE.getPROPERTY());
        List members = CollectionsKt.plus((Collection)functions, (Iterable)properties);
        ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(classNode2, ElementType.INSTANCE.getIDENTIFIER());
        Intrinsics.checkNotNull((Object)aSTNode);
        String string = aSTNode.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classNode.getFirstChildWithType(IDENTIFIER)!!.text");
        String identifier = string;
        if (!((Collection)members).isEmpty()) {
            boolean bl;
            block5: {
                Iterable $this$none$iv = members;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ASTNode it = (ASTNode)element$iv;
                        boolean bl2 = false;
                        if (!this.hasAbstractModifier(it)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Warnings.warnAndFix$default(Warnings.CLASS_SHOULD_NOT_BE_ABSTRACT, this.getConfigRules(), this.getEmitWarn(), this.isFixMode(), identifier, node.getStartOffset(), node, false, (Function0)new Function0<Unit>(classNode2){
                    final /* synthetic */ ASTNode $classNode;
                    {
                        this.$classNode = $classNode;
                        super(0);
                    }

                    public final void invoke() {
                        ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(this.$classNode, ElementType.INSTANCE.getMODIFIER_LIST());
                        Intrinsics.checkNotNull((Object)aSTNode);
                        ASTNode modList = aSTNode;
                        ASTNode aSTNode2 = AstNodeUtilsKt.getFirstChildWithType(modList, ElementType.INSTANCE.getABSTRACT_KEYWORD());
                        Intrinsics.checkNotNull((Object)aSTNode2);
                        ASTNode abstractKeyword = aSTNode2;
                        LeafPsiElement newOpenKeyword = new LeafPsiElement(ElementType.INSTANCE.getOPEN_KEYWORD(), (CharSequence)"open");
                        modList.replaceChild(abstractKeyword, (ASTNode)newOpenKeyword);
                    }
                }, 64, null);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/classes/AbstractClassesRule$Companion;", "", "()V", "NAME_ID", "", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

