/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.rules.chapter6.classes;

import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import java.util.List;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.cqfn.diktat.common.config.rules.CommonConfiguration;
import org.cqfn.diktat.common.config.rules.RulesConfig;
import org.cqfn.diktat.common.config.rules.RulesConfigReaderKt;
import org.cqfn.diktat.ruleset.constants.Warnings;
import org.cqfn.diktat.ruleset.rules.DiktatRule;
import org.cqfn.diktat.ruleset.utils.AstNodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/classes/InlineClassesRule;", "Lorg/cqfn/diktat/ruleset/rules/DiktatRule;", "configRules", "", "Lorg/cqfn/diktat/common/config/rules/RulesConfig;", "(Ljava/util/List;)V", "handleClasses", "", "classPsi", "Lorg/jetbrains/kotlin/psi/KtClass;", "hasValidProperties", "", "isExtendingClass", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "logic", "Companion", "diktat-rules"})
public final class InlineClassesRule
extends DiktatRule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME_ID = "aaw-inline-classes";
    @NotNull
    private static final KotlinVersion minKtVersion = new KotlinVersion(1, 3);
    @NotNull
    private static final KotlinVersion maxKtVersion = new KotlinVersion(1, 5, 0);
    @NotNull
    private static final List<IElementType> goodModifiers;

    public InlineClassesRule(@NotNull List<RulesConfig> configRules) {
        Intrinsics.checkNotNullParameter(configRules, (String)"configRules");
        super(NAME_ID, configRules, CollectionsKt.listOf((Object)((Object)Warnings.INLINE_CLASS_CAN_BE_USED)), null, 8, null);
    }

    @Override
    public void logic(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        CommonConfiguration configuration2 = RulesConfigReaderKt.getCommonConfiguration(this.getConfigRules());
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getCLASS())) {
            PsiElement psiElement = node.getPsi();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            }
            if (!((KtClass)psiElement).isInterface() && configuration2.getKotlinVersion().compareTo(minKtVersion) >= 0 && configuration2.getKotlinVersion().compareTo(maxKtVersion) < 0) {
                PsiElement psiElement2 = node.getPsi();
                if (psiElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
                }
                this.handleClasses((KtClass)psiElement2);
            }
        }
    }

    private final void handleClasses(KtClass classPsi) {
        if (this.hasValidProperties(classPsi)) {
            ASTNode aSTNode = classPsi.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"classPsi.node");
            if (!this.isExtendingClass(aSTNode)) {
                boolean bl;
                ASTNode aSTNode2 = classPsi.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode2, (String)"classPsi.node");
                ASTNode aSTNode3 = AstNodeUtilsKt.getFirstChildWithType(aSTNode2, ElementType.INSTANCE.getMODIFIER_LIST());
                if (aSTNode3 == null) {
                    bl = false;
                } else {
                    ASTNode[] aSTNodeArray = aSTNode3.getChildren(null);
                    if (aSTNodeArray == null) {
                        bl = false;
                    } else {
                        boolean bl2;
                        block8: {
                            ASTNode[] $this$all$iv = aSTNodeArray;
                            boolean $i$f$all = false;
                            for (ASTNode element$iv : $this$all$iv) {
                                ASTNode it = element$iv;
                                boolean bl3 = false;
                                if (goodModifiers.contains(it.getElementType())) continue;
                                bl2 = false;
                                break block8;
                            }
                            bl2 = true;
                        }
                        bl = !bl2;
                    }
                }
                if (!bl) {
                    List<RulesConfig> list = this.getConfigRules();
                    Function3<Integer, String, Boolean, Unit> function3 = this.getEmitWarn();
                    boolean bl4 = this.isFixMode();
                    String string = Intrinsics.stringPlus((String)"class ", (Object)classPsi.getName());
                    int n = classPsi.getNode().getStartOffset();
                    aSTNode = classPsi.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"classPsi.node");
                    Warnings.INLINE_CLASS_CAN_BE_USED.warn(list, function3, bl4, string, n, aSTNode);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasValidProperties(KtClass classPsi) {
        boolean bl;
        if (classPsi.getProperties().size() == 1 && !classPsi.hasExplicitPrimaryConstructor()) {
            if (((KtProperty)CollectionsKt.single((List)classPsi.getProperties())).isVar()) return false;
            return true;
        }
        if (!classPsi.getProperties().isEmpty()) return false;
        if (!classPsi.hasExplicitPrimaryConstructor()) return false;
        if (classPsi.getPrimaryConstructorParameters().size() != 1) return false;
        ASTNode aSTNode = ((KtParameter)CollectionsKt.first((List)classPsi.getPrimaryConstructorParameters())).getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"classPsi.primaryConstructorParameters.first().node");
        if (AstNodeUtilsKt.hasChildOfType(aSTNode, ElementType.INSTANCE.getVAR_KEYWORD())) return false;
        KtPrimaryConstructor ktPrimaryConstructor = classPsi.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return true;
        }
        KtModifierKeywordToken ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierType((KtModifierListOwner)((KtModifierListOwner)ktPrimaryConstructor));
        if (ktModifierKeywordToken == null) {
            return true;
        }
        String string = ktModifierKeywordToken.getValue();
        if (string == null) {
            return true;
        }
        String it = string;
        boolean bl2 = false;
        boolean bl3 = bl = Intrinsics.areEqual((Object)it, (Object)"public");
        if (!bl3) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExtendingClass(ASTNode node) {
        boolean bl;
        ASTNode aSTNode = AstNodeUtilsKt.getFirstChildWithType(node, ElementType.INSTANCE.getSUPER_TYPE_LIST());
        if (aSTNode == null) {
            bl = false;
        } else {
            Sequence sequence = PackageKt.children((ASTNode)aSTNode);
            if (sequence == null) {
                bl = false;
            } else {
                boolean bl2;
                boolean bl3;
                block5: {
                    void $this$any$iv;
                    Sequence sequence2 = sequence;
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        ASTNode it = (ASTNode)element$iv;
                        boolean bl4 = false;
                        if (!AstNodeUtilsKt.hasChildOfType(it, ElementType.INSTANCE.getCONSTRUCTOR_CALLEE())) continue;
                        bl3 = true;
                        break block5;
                    }
                    bl3 = false;
                }
                bl = bl2 = bl3;
            }
        }
        return bl;
    }

    static {
        Object[] objectArray = new IElementType[]{ElementType.INSTANCE.getPUBLIC_KEYWORD(), ElementType.INSTANCE.getPRIVATE_KEYWORD(), ElementType.INSTANCE.getFINAL_KEYWORD(), ElementType.INSTANCE.getPROTECTED_KEYWORD(), ElementType.INSTANCE.getINTERNAL_KEYWORD()};
        goodModifiers = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/cqfn/diktat/ruleset/rules/chapter6/classes/InlineClassesRule$Companion;", "", "()V", "NAME_ID", "", "goodModifiers", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "getGoodModifiers", "()Ljava/util/List;", "maxKtVersion", "Lkotlin/KotlinVersion;", "getMaxKtVersion", "()Lkotlin/KotlinVersion;", "minKtVersion", "getMinKtVersion", "diktat-rules"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinVersion getMinKtVersion() {
            return minKtVersion;
        }

        @NotNull
        public final KotlinVersion getMaxKtVersion() {
            return maxKtVersion;
        }

        @NotNull
        public final List<IElementType> getGoodModifiers() {
            return goodModifiers;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

