/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.diktat.ruleset.utils;

import com.google.common.base.CaseFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0004H\u0002\u001a\n\u0010\u000b\u001a\u00020\u0007*\u00020\u0004\u001a\n\u0010\f\u001a\u00020\u0007*\u00020\u0004\u001a\n\u0010\r\u001a\u00020\u0007*\u00020\u0004\u001a\n\u0010\u000e\u001a\u00020\u0007*\u00020\u0004\u001a\n\u0010\u000f\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010\u0010\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010\u0011\u001a\u00020\u0004*\u00020\u0004\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "convertUnknownCaseToCamel", "", "str", "isFirstLetterCapital", "", "convertUnknownCaseToUpperSnake", "getFirstLetterOrDigit", "", "isLowerCamelCase", "isLowerSnakeCase", "isPascalCase", "isUpperSnakeCase", "toLowerCamelCase", "toPascalCase", "toUpperSnakeCase", "diktat-rules"})
public final class StringCaseUtilsKt {
    private static final Logger log = LoggerFactory.getLogger((String)"StringCaseUtils");

    public static final boolean isPascalCase(@NotNull String $this$isPascalCase) {
        Intrinsics.checkNotNullParameter((Object)$this$isPascalCase, (String)"<this>");
        CharSequence charSequence = $this$isPascalCase;
        return new Regex("([A-Z][a-z0-9]+)+").matches(charSequence);
    }

    public static final boolean isLowerCamelCase(@NotNull String $this$isLowerCamelCase) {
        Intrinsics.checkNotNullParameter((Object)$this$isLowerCamelCase, (String)"<this>");
        CharSequence charSequence = $this$isLowerCamelCase;
        return new Regex("[a-z]([a-z0-9])*([A-Z][a-z0-9]+)*").matches(charSequence);
    }

    public static final boolean isUpperSnakeCase(@NotNull String $this$isUpperSnakeCase) {
        Intrinsics.checkNotNullParameter((Object)$this$isUpperSnakeCase, (String)"<this>");
        CharSequence charSequence = $this$isUpperSnakeCase;
        return new Regex("(([A-Z]+)_*)+[A-Z0-9]*").matches(charSequence);
    }

    public static final boolean isLowerSnakeCase(@NotNull String $this$isLowerSnakeCase) {
        Intrinsics.checkNotNullParameter((Object)$this$isLowerSnakeCase, (String)"<this>");
        CharSequence charSequence = $this$isLowerSnakeCase;
        return new Regex("(([a-z]+)_*)+[a-z0-9]*").matches(charSequence);
    }

    @NotNull
    public static final String toUpperSnakeCase(@NotNull String $this$toUpperSnakeCase) {
        boolean bl;
        CharSequence charSequence;
        CharSequence $this$all$iv;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$toUpperSnakeCase, (String)"<this>");
            if (StringCaseUtilsKt.isPascalCase($this$toUpperSnakeCase)) {
                String string = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, $this$toUpperSnakeCase);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, this)");
                return string;
            }
            $this$all$iv = $this$toUpperSnakeCase;
            boolean $i$f$all = false;
            charSequence = $this$all$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl2 = false;
                if (Character.isLowerCase(it)) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            charSequence = $this$toUpperSnakeCase.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"this as java.lang.String).toUpperCase(locale)");
            return charSequence;
        }
        if (StringCaseUtilsKt.isLowerCamelCase($this$toUpperSnakeCase)) {
            $this$all$iv = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, $this$toUpperSnakeCase);
            Intrinsics.checkNotNullExpressionValue((Object)$this$all$iv, (String)"LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, this)");
            return $this$all$iv;
        }
        if (StringCaseUtilsKt.isLowerSnakeCase($this$toUpperSnakeCase)) {
            $this$all$iv = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, $this$toUpperSnakeCase);
            Intrinsics.checkNotNullExpressionValue((Object)$this$all$iv, (String)"LOWER_UNDERSCORE.to(Case\u2026t.UPPER_UNDERSCORE, this)");
            return $this$all$iv;
        }
        int idx = StringCaseUtilsKt.getFirstLetterOrDigit($this$toUpperSnakeCase);
        if (idx != -1) {
            StringBuilder stringBuilder = new StringBuilder().append(Character.toUpperCase($this$toUpperSnakeCase.charAt(idx)));
            String string = $this$toUpperSnakeCase.substring(idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return stringBuilder.append(StringCaseUtilsKt.convertUnknownCaseToUpperSnake(string)).toString();
        }
        log.error(Intrinsics.stringPlus((String)"Not able to fix case format for: ", (Object)$this$toUpperSnakeCase));
        return $this$toUpperSnakeCase;
    }

    @NotNull
    public static final String toLowerCamelCase(@NotNull String $this$toLowerCamelCase) {
        boolean bl;
        CharSequence charSequence;
        CharSequence $this$all$iv;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$toLowerCamelCase, (String)"<this>");
            if (StringCaseUtilsKt.isPascalCase($this$toLowerCamelCase)) {
                String string = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, $this$toLowerCamelCase);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this)");
                return string;
            }
            $this$all$iv = $this$toLowerCamelCase;
            boolean $i$f$all = false;
            charSequence = $this$all$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl2 = false;
                if (Character.isUpperCase(it)) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            charSequence = $this$toLowerCamelCase.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"this as java.lang.String).toLowerCase(locale)");
            return charSequence;
        }
        if (StringCaseUtilsKt.isUpperSnakeCase($this$toLowerCamelCase)) {
            $this$all$iv = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, $this$toLowerCamelCase);
            Intrinsics.checkNotNullExpressionValue((Object)$this$all$iv, (String)"UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this)");
            return $this$all$iv;
        }
        if (StringCaseUtilsKt.isLowerSnakeCase($this$toLowerCamelCase)) {
            $this$all$iv = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, $this$toLowerCamelCase);
            Intrinsics.checkNotNullExpressionValue((Object)$this$all$iv, (String)"LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this)");
            return $this$all$iv;
        }
        int idx = StringCaseUtilsKt.getFirstLetterOrDigit($this$toLowerCamelCase);
        if (idx != -1) {
            StringBuilder stringBuilder = new StringBuilder().append(Character.toLowerCase($this$toLowerCamelCase.charAt(idx)));
            String string = $this$toLowerCamelCase.substring(idx + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            return stringBuilder.append(StringCaseUtilsKt.convertUnknownCaseToCamel(string, Character.isUpperCase($this$toLowerCamelCase.charAt(idx)))).toString();
        }
        log.error(Intrinsics.stringPlus((String)"Not able to fix case format for: ", (Object)$this$toLowerCamelCase));
        return $this$toLowerCamelCase;
    }

    @NotNull
    public static final String toPascalCase(@NotNull String $this$toPascalCase) {
        CharSequence charSequence;
        boolean bl;
        char it;
        char element$iv;
        int n;
        Object object;
        boolean $i$f$all2;
        CharSequence $this$all$iv2;
        block12: {
            Intrinsics.checkNotNullParameter((Object)$this$toPascalCase, (String)"<this>");
            $this$all$iv2 = $this$toPascalCase;
            $i$f$all2 = false;
            object = $this$all$iv2;
            for (n = 0; n < object.length(); ++n) {
                element$iv = object.charAt(n);
                it = element$iv;
                boolean bl2 = false;
                if (Character.isUpperCase(it)) continue;
                bl = false;
                break block12;
            }
            bl = true;
        }
        if (bl) {
            char $this$all$iv2 = $this$toPascalCase.charAt(0);
            String string = $this$toPascalCase.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            object = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefault()");
            string = string.toLowerCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            String $i$f$all2 = string;
            charSequence = $this$all$iv2 + $i$f$all2;
        } else {
            boolean bl3;
            block13: {
                $this$all$iv2 = $this$toPascalCase;
                $i$f$all2 = false;
                object = $this$all$iv2;
                for (n = 0; n < object.length(); ++n) {
                    element$iv = object.charAt(n);
                    it = element$iv;
                    boolean bl4 = false;
                    if (Character.isLowerCase(it)) continue;
                    bl3 = false;
                    break block13;
                }
                bl3 = true;
            }
            if (bl3) {
                char $this$all$iv3 = Character.toUpperCase($this$toPascalCase.charAt(0));
                String string = $this$toPascalCase.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                String string2 = string;
                charSequence = $this$all$iv3 + string2;
            } else if (StringCaseUtilsKt.isUpperSnakeCase($this$toPascalCase)) {
                $this$all$iv2 = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, $this$toPascalCase);
                Intrinsics.checkNotNullExpressionValue((Object)$this$all$iv2, (String)"{\n        // lowerCamel \u2026.UPPER_CAMEL, this)\n    }");
                charSequence = $this$all$iv2;
            } else if (StringCaseUtilsKt.isLowerSnakeCase($this$toPascalCase)) {
                $this$all$iv2 = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, $this$toPascalCase);
                Intrinsics.checkNotNullExpressionValue((Object)$this$all$iv2, (String)"{\n        // lower_snake\u2026.UPPER_CAMEL, this)\n    }");
                charSequence = $this$all$iv2;
            } else {
                int idx = StringCaseUtilsKt.getFirstLetterOrDigit($this$toPascalCase);
                if (idx != -1) {
                    StringBuilder stringBuilder = new StringBuilder().append(Character.toUpperCase($this$toPascalCase.charAt(idx)));
                    String string = $this$toPascalCase.substring(idx + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    charSequence = stringBuilder.append(StringCaseUtilsKt.convertUnknownCaseToCamel(string, true)).toString();
                } else {
                    log.error(Intrinsics.stringPlus((String)"Not able to fix case format for: ", (Object)$this$toPascalCase));
                    charSequence = $this$toPascalCase;
                }
            }
        }
        return charSequence;
    }

    private static final int getFirstLetterOrDigit(String $this$getFirstLetterOrDigit) {
        int n;
        block1: {
            CharSequence $this$indexOfFirst$iv = $this$getFirstLetterOrDigit;
            boolean $i$f$indexOfFirst = false;
            int n2 = 0;
            int n3 = $this$indexOfFirst$iv.length();
            while (n2 < n3) {
                int index$iv = n2++;
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!Character.isLetterOrDigit(it)) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final String convertUnknownCaseToCamel(String str, boolean isFirstLetterCapital) {
        void $this$mapTo$iv$iv;
        boolean isPreviousLetterCapital = false;
        isPreviousLetterCapital = isFirstLetterCapital;
        boolean isPreviousLetterUnderscore = false;
        CharSequence $this$map$iv = str;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var9_9 = $this$mapTo$iv$iv;
        int n = 0;
        while (n < var9_9.length()) {
            String string;
            void char_;
            char item$iv$iv = var9_9.charAt(n);
            ++n;
            char c = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (Character.isUpperCase((char)char_)) {
                void result = isPreviousLetterCapital && !isPreviousLetterUnderscore ? Character.toLowerCase((char)char_) : char_;
                isPreviousLetterCapital = true;
                isPreviousLetterUnderscore = false;
                string = String.valueOf((char)result);
            } else {
                String result;
                String string2;
                if (char_ == 95) {
                    isPreviousLetterUnderscore = true;
                    string2 = "";
                } else if (isPreviousLetterUnderscore) {
                    isPreviousLetterCapital = true;
                    isPreviousLetterUnderscore = false;
                    string2 = String.valueOf(Character.toUpperCase((char)char_));
                } else {
                    isPreviousLetterCapital = false;
                    isPreviousLetterUnderscore = false;
                    string2 = String.valueOf((char)char_);
                }
                string = result = string2;
            }
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final String convertUnknownCaseToUpperSnake(String str) {
        void $this$mapTo$iv$iv;
        boolean alreadyInsertedUnderscore = false;
        alreadyInsertedUnderscore = true;
        CharSequence $this$map$iv = str;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        int n = 0;
        while (n < var7_7.length()) {
            String string;
            void char_;
            char item$iv$iv = var7_7.charAt(n);
            ++n;
            char c = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (Character.isUpperCase((char)char_)) {
                if (!alreadyInsertedUnderscore) {
                    alreadyInsertedUnderscore = true;
                    string = Intrinsics.stringPlus((String)"_", (Object)Character.valueOf((char)char_));
                } else {
                    string = String.valueOf((char)char_);
                }
            } else {
                alreadyInsertedUnderscore = char_ == 95;
                string = String.valueOf(Character.toUpperCase((char)char_));
            }
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }
}

