/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio;

import java.util.concurrent.atomic.AtomicLong;
import org.cqfn.rio.WriteGreed;
import org.reactivestreams.Subscription;

public final class AdaptiveGreed
implements WriteGreed {
    private volatile long amount;
    private volatile long shift;
    private final AtomicLong cnt;
    private final AtomicLong rec;

    public AdaptiveGreed(long amount, long shift) {
        if (shift >= amount) {
            throw new IllegalArgumentException("Shift should be less than amount");
        }
        this.amount = amount;
        this.shift = shift;
        this.cnt = new AtomicLong();
        this.rec = new AtomicLong();
    }

    @Override
    public boolean request(Subscription sub) {
        boolean result;
        long pos = this.cnt.getAndIncrement();
        boolean bl = result = pos == 0L || pos % (this.amount - this.shift + 1L) == 0L;
        if (result) {
            if (this.cnt.get() - this.rec.get() < this.shift + 1L) {
                this.shift *= 2L;
            }
            if (this.shift > this.amount / 2L) {
                this.amount *= 2L;
            }
            sub.request(this.amount);
        }
        return result;
    }

    @Override
    public void received() {
        this.rec.incrementAndGet();
    }
}

