/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class IoExecutor
extends AbstractExecutorService {
    private static volatile ExecutorService shr;
    private final ExecutorService origin;

    IoExecutor() {
        this(new Factory("rio"));
    }

    IoExecutor(ThreadFactory factory) {
        this(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), factory));
    }

    IoExecutor(ExecutorService origin) {
        this.origin = origin;
    }

    @Override
    public void execute(Runnable arg) {
        this.origin.execute(arg);
    }

    @Override
    public boolean awaitTermination(long time, TimeUnit unit) throws InterruptedException {
        return this.origin.awaitTermination(time, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.origin.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.origin.isTerminated();
    }

    @Override
    public void shutdown() {
        this.origin.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.origin.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorService shared() {
        if (shr != null) return shr;
        Class<IoExecutor> clazz = IoExecutor.class;
        synchronized (IoExecutor.class) {
            if (shr != null) return shr;
            shr = new IoExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return shr;
        }
    }

    private static final class Factory
    implements ThreadFactory {
        private final String prefix;
        private final AtomicInteger cnt;

        Factory(String prefix) {
            this.prefix = prefix;
            this.cnt = new AtomicInteger();
        }

        @Override
        public Thread newThread(Runnable run) {
            Thread thr = new Thread(run);
            thr.setName(String.format("%s-%d", this.prefix, this.cnt.getAndIncrement()));
            return thr;
        }
    }
}

