/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio.channel;

import java.util.concurrent.ExecutorService;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class AsyncSubscriber<T>
implements Subscriber<T> {
    private final Subscriber<T> origin;
    private final ExecutorService execs;

    AsyncSubscriber(Subscriber<T> origin, ExecutorService exec) {
        this.origin = origin;
        this.execs = exec;
    }

    public void onSubscribe(Subscription subscription) {
        this.exec(() -> this.origin.onSubscribe(subscription), false);
    }

    public void onNext(T next) {
        this.exec(() -> this.origin.onNext(next), false);
    }

    public void onError(Throwable err) {
        this.exec(() -> this.origin.onError(err), true);
    }

    public void onComplete() {
        this.exec(() -> this.origin.onComplete(), true);
    }

    private void exec(Runnable task, boolean close) {
        if (this.execs == null) {
            task.run();
        } else {
            this.execs.submit(() -> {
                task.run();
                if (close) {
                    this.execs.shutdown();
                }
            });
        }
    }
}

