/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio.channel;

import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;

final class CloseChanOnError
implements Runnable {
    private final Runnable origin;
    private final ReadableByteChannel chan;

    CloseChanOnError(Runnable origin, ReadableByteChannel chan) {
        this.origin = origin;
        this.chan = chan;
    }

    @Override
    public void run() {
        try {
            this.origin.run();
        }
        catch (Throwable err) {
            this.close();
            throw err;
        }
    }

    private void close() {
        if (this.chan.isOpen()) {
            try {
                this.chan.close();
            }
            catch (IOException err) {
                Logger.warn((Object)this, (String)"Failed to close channel: %[exception]s", (Object[])new Object[]{err});
            }
        }
    }
}

