/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio.channel;

import java.nio.ByteBuffer;
import org.cqfn.rio.Buffers;
import org.cqfn.rio.channel.ReadRequest;
import org.cqfn.rio.channel.ReadSubscriberState;
import org.cqfn.rio.channel.ReadTaskQueue;
import org.reactivestreams.Subscription;

final class ReadSubscription
implements Subscription {
    private final ReadSubscriberState<? super ByteBuffer> sub;
    private final Buffers buffers;
    private final ReadTaskQueue queue;

    ReadSubscription(ReadSubscriberState<? super ByteBuffer> sub, Buffers buffers, ReadTaskQueue queue) {
        this.sub = sub;
        this.buffers = buffers;
        this.queue = queue;
    }

    public void request(long count) {
        if (this.sub.done()) {
            return;
        }
        if (count <= 0L) {
            this.queue.clear();
            this.sub.onError(new IllegalArgumentException(String.format("Requested %d items", count)));
        } else {
            this.queue.accept(new ReadRequest.Next(this.sub, this.buffers, count));
        }
    }

    public void cancel() {
        this.sub.cancel();
        this.queue.clear();
    }
}

