/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio.channel;

import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cqfn.rio.channel.CloseChanOnError;
import org.cqfn.rio.channel.ErrorOnException;
import org.cqfn.rio.channel.ReadRequest;
import org.cqfn.rio.channel.ReadSubscriberState;
import org.jctools.queues.SpscUnboundedArrayQueue;

final class ReadTaskQueue
implements Runnable {
    private final Queue<ReadRequest> queue = new SpscUnboundedArrayQueue(128);
    private final ReadSubscriberState<? super ByteBuffer> sub;
    private final ReadableByteChannel channel;
    private final Executor exec;
    private final AtomicBoolean running;

    ReadTaskQueue(ReadSubscriberState<? super ByteBuffer> sub, ReadableByteChannel channel, Executor exec) {
        this.sub = sub;
        this.exec = exec;
        this.channel = channel;
        this.running = new AtomicBoolean();
    }

    @Override
    public void run() {
        while (!this.sub.done()) {
            ReadRequest next = this.queue.poll();
            if (next == null) {
                this.running.set(false);
                if (!this.queue.isEmpty() && this.running.compareAndSet(false, true)) {
                    if (this.sub.done()) break;
                    next = this.queue.poll();
                    if (next == null) {
                        continue;
                    }
                } else {
                    return;
                }
            }
            next.process(this.channel);
        }
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException err) {
                Logger.warn((Object)this, (String)"Failed to close channel: %[exception]s", (Object[])new Object[]{err});
            }
        }
    }

    public void accept(ReadRequest request) {
        if (this.sub.done()) {
            return;
        }
        this.queue.add(request);
        if (this.running.compareAndSet(false, true)) {
            this.exec.execute(new ErrorOnException(new CloseChanOnError(this, this.channel), this.sub));
        }
    }

    public void clear() {
        this.queue.clear();
    }
}

