/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio.channel;

import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.cqfn.rio.IoExecutor;
import org.cqfn.rio.WriteGreed;
import org.cqfn.rio.channel.ChannelSource;
import org.cqfn.rio.channel.WritableChannelSubscriber;
import org.reactivestreams.Publisher;

public final class WritableChannel {
    private final ChannelSource<? extends WritableByteChannel> src;
    private final ExecutorService exec;

    public WritableChannel(ChannelSource<? extends WritableByteChannel> src) {
        this(src, IoExecutor.shared());
    }

    public WritableChannel(ChannelSource<? extends WritableByteChannel> src, ExecutorService exec) {
        this.src = src;
        this.exec = exec;
    }

    public CompletionStage<Void> write(Publisher<ByteBuffer> data) {
        return this.write(data, WriteGreed.SYSTEM.adaptive());
    }

    public CompletionStage<Void> write(Publisher<ByteBuffer> data, WriteGreed greed) {
        WritableChannelSubscriber sub = new WritableChannelSubscriber(this.src, greed, this.exec);
        sub.acceptAsync(data);
        return sub;
    }
}

