/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio.channel;

import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CompletableFuture;

abstract class WriteRequest {
    protected final CompletableFuture<Void> future;

    private WriteRequest(CompletableFuture<Void> future) {
        this.future = future;
    }

    abstract void process(WritableByteChannel var1);

    static final class Init
    extends WriteRequest {
        Init(CompletableFuture<Void> future) {
            super(future);
        }

        @Override
        void process(WritableByteChannel chan) {
        }
    }

    static final class Error
    extends WriteRequest {
        private final Throwable err;

        Error(CompletableFuture<Void> future, Throwable err) {
            super(future);
            this.err = err;
        }

        public String toString() {
            return String.format("Error: %s", this.err.getMessage());
        }

        @Override
        void process(WritableByteChannel chan) {
            try {
                chan.close();
            }
            catch (IOException cex) {
                Logger.warn((Object)this, (String)"Failed to close channel on error: %[exception]s", (Object[])new Object[]{cex});
            }
            this.future.completeExceptionally(this.err);
        }
    }

    static final class Complete
    extends WriteRequest {
        Complete(CompletableFuture<Void> future) {
            super(future);
        }

        @Override
        public void process(WritableByteChannel chan) {
            try {
                chan.close();
            }
            catch (IOException iex) {
                this.future.completeExceptionally(iex);
                return;
            }
            this.future.complete(null);
        }

        public String toString() {
            return "Complete";
        }
    }

    static final class Next
    extends WriteRequest {
        private final ByteBuffer target;

        Next(CompletableFuture<Void> future, ByteBuffer target) {
            super(future);
            this.target = target;
        }

        @Override
        public void process(WritableByteChannel chan) {
            while (this.target.hasRemaining()) {
                try {
                    chan.write(this.target);
                }
                catch (IOException iex) {
                    try {
                        chan.close();
                    }
                    catch (IOException cex) {
                        Logger.warn((Object)this, (String)"Failed to close channel on next failure: %[exception]s", (Object[])new Object[]{cex});
                    }
                    this.future.completeExceptionally(iex);
                    return;
                }
            }
        }

        public String toString() {
            return String.format("Write next %s", this.target);
        }
    }
}

