/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio.channel;

import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.cqfn.rio.WriteGreed;
import org.cqfn.rio.channel.WriteRequest;
import org.jctools.queues.SpscUnboundedArrayQueue;
import org.reactivestreams.Subscription;

final class WriteTaskQueue
implements Runnable {
    private final CompletableFuture<Void> future;
    private final WritableByteChannel channel;
    private final AtomicReference<Subscription> sub;
    private final Queue<WriteRequest> queue;
    private final WriteGreed greed;
    private final Executor exec;
    private final AtomicBoolean running;

    WriteTaskQueue(CompletableFuture<Void> future, WritableByteChannel channel, AtomicReference<Subscription> sub, WriteGreed greed, Executor exec) {
        this.future = future;
        this.channel = channel;
        this.sub = sub;
        this.queue = new SpscUnboundedArrayQueue(128);
        this.greed = greed;
        this.exec = exec;
        this.running = new AtomicBoolean();
    }

    @Override
    public void run() {
        boolean retry = false;
        while (!this.future.isDone()) {
            boolean empty;
            boolean requested = !retry && this.greed.request(this.sub.get());
            WriteRequest next = this.queue.poll();
            boolean bl = empty = next == null;
            if (!requested && empty) {
                Thread.yield();
                retry = false;
                continue;
            }
            if (empty) {
                this.running.set(false);
                if (!this.queue.isEmpty() && this.running.compareAndSet(false, true)) {
                    if (this.future.isDone()) break;
                    next = this.queue.poll();
                    if (next == null) {
                        retry = true;
                        continue;
                    }
                } else {
                    return;
                }
            }
            retry = false;
            this.greed.received();
            next.process(this.channel);
        }
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException err) {
                Logger.warn((Object)this, (String)"Failed to close channel: %[exception]s", (Object[])new Object[]{err});
            }
        }
        Optional.ofNullable(this.sub.getAndSet(null)).ifPresent(Subscription::cancel);
        this.running.set(false);
    }

    public void accept(WriteRequest req) {
        if (this.future.isDone()) {
            return;
        }
        if (req instanceof WriteRequest.Error) {
            this.queue.clear();
        }
        this.queue.add(req);
        if (this.running.compareAndSet(false, true)) {
            this.exec.execute(this);
        }
    }
}

