/*
 * Decompiled with CFR 0.152.
 */
package org.cqfn.rio.file;

import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import org.cqfn.rio.Buffers;
import org.cqfn.rio.IoExecutor;
import org.cqfn.rio.WriteGreed;
import org.cqfn.rio.channel.ReadableChannel;
import org.cqfn.rio.channel.WritableChannel;
import org.reactivestreams.Publisher;

public final class File {
    private final Path path;
    private final ExecutorService exec;

    public File(Path path) {
        this(path, IoExecutor.shared());
    }

    public File(Path path, ExecutorService exec) {
        this.path = path;
        this.exec = exec;
    }

    public Publisher<ByteBuffer> content() {
        return this.content(Buffers.Standard.K8);
    }

    public Publisher<ByteBuffer> content(Buffers buf) {
        return new ReadableChannel(() -> FileChannel.open(this.path, StandardOpenOption.READ), this.exec).read(buf);
    }

    public CompletionStage<Void> write(Publisher<ByteBuffer> data, OpenOption ... opts) {
        return this.write(data, WriteGreed.SYSTEM.adaptive(), opts);
    }

    public CompletionStage<Void> write(Publisher<ByteBuffer> data, WriteGreed greed, OpenOption ... opts) {
        return new WritableChannel(() -> FileChannel.open(this.path, File.writeOpts(opts)), this.exec).write(data, greed);
    }

    private static OpenOption[] writeOpts(OpenOption ... src) {
        OpenOption[] opts = src.length == 0 ? new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE} : src;
        return opts;
    }
}

