/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.descriptor.IllegalValueTypeException;
import org.crsh.cli.type.ValueType;
import org.crsh.cli.type.ValueTypeFactory;

public final class ParameterType<V> {
    private final Multiplicity multiplicity;
    private final Class<?> declaredType;
    private final Class<V> effectiveType;
    private final ValueType<V> valueType;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParameterType create(ValueTypeFactory factory, Type type) throws IllegalValueTypeException {
        void var5_11;
        Class effectiveType;
        Multiplicity multiplicity;
        Class declaredType;
        if (type instanceof Class) {
            declaredType = (Class)type;
            multiplicity = Multiplicity.SINGLE;
        } else {
            if (!(type instanceof ParameterizedType)) throw new IllegalValueTypeException();
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            if (!(type2 instanceof Class)) throw new IllegalValueTypeException();
            Class classRawType = (Class)type2;
            if (!List.class.equals((Object)classRawType)) throw new IllegalValueTypeException();
            Type elementType = parameterizedType.getActualTypeArguments()[0];
            if (!(elementType instanceof Class)) throw new IllegalValueTypeException();
            declaredType = (Class)elementType;
            multiplicity = Multiplicity.MULTI;
        }
        if (declaredType == String.class) {
            effectiveType = String.class;
            ValueType<String> valueType = ValueType.STRING;
            return new ParameterType<String>(multiplicity, declaredType, effectiveType, (ValueType<String>)var5_11);
        } else if (declaredType == Integer.class || declaredType == Integer.TYPE) {
            effectiveType = Integer.class;
            ValueType<Integer> valueType = ValueType.INTEGER;
            return new ParameterType<String>(multiplicity, declaredType, effectiveType, (ValueType<String>)var5_11);
        } else if (declaredType == Boolean.class || declaredType == Boolean.TYPE) {
            effectiveType = Boolean.class;
            ValueType<Boolean> valueType = ValueType.BOOLEAN;
            return new ParameterType<String>(multiplicity, declaredType, effectiveType, (ValueType<String>)var5_11);
        } else if (Enum.class.isAssignableFrom(declaredType)) {
            effectiveType = declaredType;
            ValueType<Enum> valueType = ValueType.ENUM;
            return new ParameterType<String>(multiplicity, declaredType, effectiveType, (ValueType<String>)var5_11);
        } else {
            effectiveType = declaredType;
            ValueType valueType = factory.get(declaredType);
            if (valueType != null) return new ParameterType<String>(multiplicity, declaredType, effectiveType, (ValueType<String>)var5_11);
            throw new IllegalValueTypeException("Type " + declaredType.getName() + " is not handled at the moment");
        }
    }

    ParameterType(Multiplicity multiplicity, Class<?> declaredType, Class<V> effectiveType, ValueType<V> valueType) {
        this.multiplicity = multiplicity;
        this.declaredType = declaredType;
        this.effectiveType = effectiveType;
        this.valueType = valueType;
    }

    public Object parse(String s) throws Exception {
        return this.valueType.parse(this.effectiveType, s);
    }

    public Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    public Class<?> getDeclaredType() {
        return this.declaredType;
    }

    public Class<V> getEffectiveType() {
        return this.effectiveType;
    }

    public ValueType<V> getValueType() {
        return this.valueType;
    }
}

