/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet.term;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.HashMap;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.net.Connection;
import net.wimpi.telnetd.net.ConnectionData;
import org.crsh.telnet.term.CodeType;
import org.crsh.telnet.term.spi.TermIO;
import org.crsh.text.Color;
import org.crsh.text.Style;

public class TelnetIO
implements TermIO {
    private final Connection conn;
    private final BasicTerminalIO termIO;
    private boolean useAlternate;

    public TelnetIO(Connection conn) {
        this.conn = conn;
        this.termIO = conn.getTerminalIO();
        this.useAlternate = false;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.termIO.read();
        }
        catch (EOFException e) {
            return 1305;
        }
        catch (SocketException e) {
            return 1305;
        }
    }

    @Override
    public int getWidth() {
        return this.termIO.getColumns();
    }

    @Override
    public int getHeight() {
        return this.termIO.getRows();
    }

    @Override
    public String getProperty(String name) {
        Object value;
        HashMap map;
        ConnectionData data = this.conn.getConnectionData();
        if (data != null && (map = data.getEnvironment()) != null && (value = map.get(name)) != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public boolean takeAlternateBuffer() throws IOException {
        if (!this.useAlternate) {
            this.useAlternate = true;
            this.termIO.write("\u001b[?47h");
        }
        return true;
    }

    @Override
    public boolean releaseAlternateBuffer() throws IOException {
        if (this.useAlternate) {
            this.useAlternate = false;
            this.termIO.write("\u001b[?47l");
        }
        return true;
    }

    @Override
    public CodeType decode(int code) {
        switch (code) {
            case 1304: {
                return CodeType.BEGINNING_OF_LINE;
            }
            case 5: {
                return CodeType.END_OF_LINE;
            }
            case 3: {
                return CodeType.BREAK;
            }
            case 1301: {
                return CodeType.TAB;
            }
            case 1302: 
            case 1303: {
                return CodeType.BACKSPACE;
            }
            case 1001: {
                return CodeType.UP;
            }
            case 1002: {
                return CodeType.DOWN;
            }
            case 1003: {
                return CodeType.RIGHT;
            }
            case 1004: {
                return CodeType.LEFT;
            }
            case 1305: {
                return CodeType.CLOSE;
            }
        }
        return CodeType.CHAR;
    }

    @Override
    public void close() {
        this.conn.close();
    }

    @Override
    public void flush() throws IOException {
        this.termIO.flush();
    }

    @Override
    public void write(CharSequence s) throws IOException {
        this.termIO.write(s.toString());
    }

    @Override
    public void write(Style style) throws IOException {
        if (style == Style.reset) {
            this.termIO.resetAttributes();
            this.termIO.write("");
        } else if (style instanceof Style.Composite) {
            Color bg;
            Color fg;
            Style.Composite composite = (Style.Composite)style;
            if (composite.getBold() != null) {
                this.termIO.setBold(composite.getBold().booleanValue());
            }
            if (composite.getUnderline() != null) {
                this.termIO.setUnderlined(composite.getUnderline().booleanValue());
            }
            if (composite.getBlink() != null) {
                this.termIO.setBlink(composite.getBlink().booleanValue());
            }
            if ((fg = composite.getForeground()) != null) {
                this.termIO.setForegroundColor(30 + fg.code);
            }
            if ((bg = composite.getBackground()) != null) {
                this.termIO.setBackgroundColor(30 + bg.code);
            }
        } else {
            this.termIO.resetAttributes();
        }
    }

    @Override
    public void write(char c) throws IOException {
        this.termIO.write(c);
    }

    @Override
    public void writeDel() throws IOException {
        this.termIO.moveLeft(1);
        this.termIO.write(' ');
        this.termIO.moveLeft(1);
        this.termIO.flush();
    }

    @Override
    public void writeCRLF() throws IOException {
        this.termIO.write("\r\n");
    }

    @Override
    public boolean moveRight(char c) throws IOException {
        this.termIO.moveRight(1);
        return true;
    }

    @Override
    public boolean moveLeft() throws IOException {
        this.termIO.moveLeft(1);
        return true;
    }

    @Override
    public void cls() throws IOException {
        this.termIO.eraseScreen();
        this.termIO.setCursor(0, 0);
    }
}

